/*
 * Fisoco, a FInding SOrting and COnverting free software
 * Copyright 2015 Félicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/****************
 *    main.h    *
 *    ~~~~~~    *
 ****************/

#if HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif /* HAVE_UNISTD_H */
// C headers
#include <iostream>
#include <getopt.h>
// i18n
#include "../include/gettext.h"
#include <locale.h>
#include <cstdlib>
// Gtkmm headers
#include <gtkmm/application.h>
// Multi-thread
#include <thread> 
#include <X11/Xlib.h>
// Fisoco headers
#include "../include/gui.h"
#include "../include/cli.h"
#include "../include/main.h"

using namespace std;

struct Fisoco : Gtk::Application {
    
    Fisoco () : Gtk::Application ("fisoco.app", Gio::APPLICATION_HANDLES_COMMAND_LINE) {}
    
    int on_command_line(const Glib::RefPtr<Gio::ApplicationCommandLine> &cmd) {
        // parse arguments:
        Glib::OptionContext context;
        Glib::OptionGroup group (gettext ("options"), gettext ("Main options"), gettext ("Show Fisoco options"));
        // CLI option
        bool show_cli = false;
        Glib::OptionEntry cli_opt;
        cli_opt.set_long_name ("cli");
        cli_opt.set_description (gettext ("Use Command Line Interface (CLI) mode"));
        group.add_entry (cli_opt, show_cli);
        // Version option
        bool show_ver = false;
        Glib::OptionEntry ver_opt;
        ver_opt.set_short_name ('v');
        ver_opt.set_long_name ("version");
        ver_opt.set_description (gettext ("Display version and copyrights"));
        group.add_entry (ver_opt, show_ver);
        context.add_group (group);
        // add GTK options, --help-gtk, etc
        Glib::OptionGroup gtkgroup (gtk_get_option_group (true));
        context.add_group (gtkgroup);
        
        int argc;
        char **argv = cmd->get_arguments (argc);
        context.parse (argc, argv);
        // maybe show the gui (if show_cli stay false)
        if (!show_cli)
        {
            if (show_ver)
                version ();
            else
                activate ();
        }
        else
        {
            Cli *main;
            main = new Cli ();
        }
        return 0;
    }
    void on_activate() {
        // can't use Gtk::manage, so we have to keep
        // the reference or the main loop quits.
        Gui *main;
        main = new Gui ();
        add_window(*main);
        main->show();
    }
};

int
main (int argc, char* argv[])
{
    /* locale settings */
    setlocale (LC_CTYPE, "");
    setlocale (LC_MESSAGES, "");
    bindtextdomain (PACKAGE, LOCALEDIR);
    textdomain ( PACKAGE);
    /* graphical interface */
    XInitThreads ();
    return Fisoco ().run (argc, argv);
}

void
version ()
{
    printf ("Fisoco  Copyright  (C) 2015  Felicien PILLOT <felicien.pillot@member.fsf.org>\n");
    printf (gettext ("This program comes with ABSOLUTELY NO WARRANTY; for details use -w option.\n"));
    printf (gettext ("This is free software, and you are welcome to redistribute\n"));
    printf (gettext ("it under certain condition (option -c for details).\n"));
}
