/*
 * Fisoco : FInd, Select, Order and COnvert files
 * Copyright 2015-2016 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/****************
 *    cli.h     *
 *    ~~~~~~    *
 ****************/

#ifndef FISOCO_CLI_H
#define FISOCO_CLI_H

#if HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <iostream>
#include "search.h"
#include "list.h"
// i18n
#include "gettext.h"

class Cli
{
public:
    Cli ();
    
    // Called from the worker thread.
    void notify (std::list<std::string> files, std::string dir);
    
private:
    
    void backup ();
    void backup (std::string filename);
    int check_args (std::string command);
    void clean ();
    void display_version ();
    const std::string currentDateTime ();
    void help ();
    void help (std::string argument);
    void interactive_read ();
    void load ();
    void load (int number);
    void info (int numbers);
    std::string prompt ();
    int read ();
    void search (std::string arg);
    int start_search (Glib::ustring search);

    Search cli_Worker;
    Glib::Threads::Thread* cli_WorkerThread;

    List results;
};

#endif // FISOCO_CLI_H
