/*
 * Fisoco : FInd, Select, Order and COnvert files
 * Copyright 2015-2016 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/****************
 *   search.cc  *
 *    ~~~~~~    *
 ****************/

#ifndef GTKMM_SEARCH_H
#define GTKMM_SEARCH_H

#if HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <iostream>
#include <list>
#include <glibmm/ustring.h>
// i18n
#include "../include/gettext.h"

using namespace std;

class Cli;

class Search
{
public:
  Search ();

  // Thread function.
  void do_work_only (Cli* caller, Glib::ustring search, std::string dir);
  std::list<std::string>  getdir (Glib::ustring search, std::string dir);
  void stop_work ();
  void recursive_search_only (std::list<std::string> results,
                              Glib::ustring search,
                              std::string dir,
                              Cli* caller);
  bool has_stopped ();
  std::list<std::string> extr_files (std::string search,
                                     std::list<std::string> rs, std::string dr);
  std::list<std::string> extr_dirs (std::list<std::string> rs, std::string dr);
  std::string get_type (std::string file, std::string dir);
  
private:
    bool search_shall_stop;
    bool search_has_stopped;
};

#endif // GTKMM_SEARCH_H
