/*
 * Fisoco : FInd, Select, Order and COnvert files
 * Copyright 2015-2016 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/***************
 *    cli.cc    *
 *    ~~~~~~    *
 ****************/

#include "../include/cli.h"
#include "../include/global.h"
#include "../include/search.h"

#include <sys/stat.h>
#include <fstream>
#include <time.h>

void
Cli::backup ()
{
  string name = currentDateTime ();
  backup (name);
}
 
void
Cli::backup (std::string filename)
{
  filename += ".bak.fis";
  ofstream backup_file;
  string path = "/var/tmp/fisoco";
  mkdir (path.c_str(), S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
  int i = 1;
  std::list<std::string> list_names = results.get_complete_names ();
  if (list_names.size () != 0)
    {
      backup_file.open (path + "/" + filename);
      backup_file << "# This is generated data" << std::endl
		  << "# Please do not modify" << std::endl;
      for (std::list<std::string>::iterator complete_name = list_names.begin ();
	   complete_name != list_names.end (); complete_name++, i++)
	{
	  backup_file << i << "\t- " << *complete_name << std::endl;
	}
      backup_file.close ();
      std::cout << "List of files saved as " << filename << "." << std::endl;
    }
  else
    std::cout << "Cannot backup: list is empty" << std::endl;
}
 
// Get current date/time, format is YYYY-MM-DD.HH:mm:ss
const std::string
Cli::currentDateTime() {
    time_t     now = time(0);
    struct tm  tstruct;
    char       buf[80];
    tstruct = *localtime(&now);
    // Visit http://en.cppreference.com/w/cpp/chrono/c/strftime
    // for more information about date/time format
    strftime(buf, sizeof(buf), "%Y-%m-%d.%X", &tstruct);
    return buf;
}
 
void
Cli::load ()
{
  std::cout << gettext ("Scanning backup files...") << std::endl;
  clean ();
  start_search (".bak.fis");
  sleep (1);
  /* FIXME:
   * NOT DYNAMICAL AT ALL !!!!
   */
  if (!read ())
    {
      sleep (1);
      if (!read ())
	{
	  sleep (1);
	  if (!read ())
	      std::cout << "No backup files found !" << std::endl;
	}
    }
  std::cout << gettext ("Choose the backup file you want to load, then type 'load x' where x is the number of the chosen file.") << std::endl;
}

void
Cli::load (int number)
{
  std::vector<std::string> infos = results.get_infos (number);
  if (infos.size () == 0)
    error ("Backup file unknown : check the list by typing 'load'");
  else
    {
      string name = infos.at(1) + "/" + infos.at(0);
      ifstream backup_file (name);
      if (backup_file.is_open())
	{
	  string line;
	  while ( getline (backup_file, line) )
	    {
	      if (line.substr (0,1) != "#")
		{
		  /* TODO:
		   * Not only display it, but store it in a new list
		   */
		  std::cout << "Num: "
			    << line.substr (0, line.find ("\t") )
			    << std::endl
			    << "Path: "
			    << line.substr (line.find ("/"),
					    (line.find_last_of ("/")
					     - line.find ("/")))
			    << std::endl
			    << "Name: "
			    << line.substr ( line.find_last_of ("/")+1 )
			    << std::endl;
		}
	    }
	  backup_file.close();
	}
      else std::cout << "Unable to open file " << name << std::endl; 
    }
}
