/*
 * Fisoco : FInd, Select, Order and COnvert files
 * Copyright 2015-2016-2017 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/****************
 * aux_func.cc  *
 *   ~~~~~~     *
 ***************/

#include "../include/cli.h"
#include "../include/global.h"
#include <sstream>

// Get current date/time, format is YYYY-MM-DD.HH:mm:ss
const std::string
Cli::currentDateTime() {
    time_t     now = time(0);
    struct tm  tstruct;
    char       buf[80];
    tstruct = *localtime(&now);
    // Visit http://en.cppreference.com/w/cpp/chrono/c/strftime
    // for more information about date/time format
    strftime(buf, sizeof(buf), "%Y-%m-%d.%X", &tstruct);
    return buf;
}

std::list<std::string>
Cli::get_file_from_line (std::string line)
{
  std::list<std::string> file;
  if (line.substr (0,1) != "#")
    {
      file.push_back (line.substr
		      (line.find ("/"),
		       (line.find_last_of ("/") - line.find ("/"))
		       )
		      );
      file.push_back (line.substr
		      (line.find_last_of ("/")+1)
		      );
    }
  return file;
}

std::list<int>
Cli::get_numbers (std::list<std::string> command)
{
  std::list<int> numlist;
  int dash_pos, i, number;
  for (std::list<std::string>::iterator arg = ++command.begin ();
       arg != command.end (); arg++)
    {
      if ((*arg).find ('-'))
	{
	  dash_pos = (*arg).find ('-');
	  std::istringstream ((*arg).substr (0, dash_pos)) >> i;
	  std::istringstream ((*arg).substr (dash_pos+1)) >> number;
	  for (; i <= number; i++)
	    numlist.push_back (i);
	}
      else
	{
	  std::istringstream (*arg) >> number;
	  numlist.push_back (number);
	}
    }

  // This sorts and removes doubles in the list
  numlist.sort ();
  std::list<int>::iterator oldN, n;
  oldN = numlist.begin ();
  n = oldN;
  for (n++; n != numlist.end (); n++)
    {
      if (*n == *oldN)
	numlist.erase (oldN);
      oldN = n;
    }
  
  return numlist;
}

void
Cli::init_command_list ()
{
  command_list = {"help",
		  "backup",
		  "clean",
		  "dir",
		  "load",
		  "info",
		  "pick",
		  "purify",
		  "read",
		  "search",
		  "quit",
		  "version"};
}

void
Cli::init_char_map ()
{
  for (std::string command : command_list)
    {
      if (command.substr (0, 1) != "p")
	char_map [command.substr (0, 1)] = command;
      else
	char_map [command.substr (0, 2)] = command;
    }
}

void
Cli::init_entry_map ()
{
  // Declare all entries
  entry help, backup, clean, dir, load, info,
    pick, purify, read, search, quit, version;
  
  // Initialize them
  help.command = "help";
  help.arguments = "[COMMAND]";
  help.short_desc = gettext ("print general help, or help about COMMAND");
  help.long_desc = "Hahaha.";
  backup.command = "backup";
  backup.arguments = "[NAME]";
  backup.short_desc = gettext ("save the current list of files searched/selected");
  backup.long_desc = gettext ("This command accepts one argument. Without argument, it backups the list of files founded or selected into a text file located at '$HOME/.config/fisoco/list_[number].txt'. You can set a different filename by giving it as parameter.");
  clean.command = "clean";
  clean.arguments = "";
  clean.short_desc = gettext ("clean all selected elements from the list");
  clean.long_desc = gettext ("This command requires no arguments, it cleans all elements selected (or not) from the list.  You can use this when you want to cancel your search and start a new one.");
  dir.command = "dir";
  dir.arguments = "DIRPATH";
  dir.short_desc = gettext ("set the search dir to DIRPATH");
  dir.long_desc = gettext ("This command requires one argument. It sets the directory from which the search command is launched. By defaults it is set to '/'.");
  load.command = "load";
  load.arguments = "[BACKUP]";
  load.short_desc = gettext ("load the backup given as parameter");
  load.long_desc = gettext ("This command requires one argument. It opens and loads the backup given as parameter, or, if no parameters are given, the last saved.");
  info.command = "info";
  info.arguments = "(N1 [N2 ...] | N1-NX)*";
  info.short_desc = gettext ("display information about given file(s)");
  info.long_desc = gettext ("This command requires at least one argument(s). It displays all informations (path, size, owner, created date, etc.) about file(s) whose number(s) are given as parameter(s). Numbers can be discrete or continuous.");
  pick.command = "pick";
  pick.arguments = "(N1 [N2 ...] | N1-NX)*";
  pick.short_desc = gettext ("pick elements from the list, by (their name or) their number");
  pick.long_desc = gettext ("This command requires at least one argument(s), which can be (strings or) lists of numbers. A new list is created, containing only the results of the query.");
  purify.command = "purify";
  purify.arguments = "MOTIF";
  purify.short_desc = gettext ("purify elements from the list, by their name or their number");
  purify.long_desc = gettext ("This command requires at least one argument(s), which can be strings or lists of numbers. The current list is cleared of the results of the query.");
  read.command = "read";
  read.arguments = "";
  read.short_desc = gettext ("display the current list of files");
  read.long_desc = gettext ("This command requires no arguments, it displays all elements selected (or just all elements founded, if you haven't yet selected some of them).");
  search.command = "search";
  search.arguments = "FILE";
  search.short_desc = gettext ("search FILE on system");
  search.long_desc = gettext ("This command requires one argument. It takes the FILE or expression given as parameter, and look for it on the entire system (at this point of the development).");
  quit.command = "quit";
  quit.arguments = "";
  quit.short_desc = gettext ("exit program");
  quit.long_desc = "Haha.";
  version.command = "version";
  version.arguments = "";
  version.short_desc = gettext ("version and copyright information");
  version.long_desc = gettext ("Display all version and copyright informations. Simply.");

  // Store them in entry_map
  entry_map ["help"] = help;
  entry_map ["backup"] = backup;
  entry_map ["clean"] = clean;
  entry_map ["dir"] = dir;
  entry_map ["load"] = load;
  entry_map ["info"] = info;
  entry_map ["pick"] = pick;
  entry_map ["purify"] = purify;
  entry_map ["read"] = read;
  entry_map ["search"] = search;
  entry_map ["quit"] = quit;
  entry_map ["version"] = version;
}
