/*
 * Fisoco : FInd, Select, Order and COnvert files
 * Copyright 2015-2016-2017 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/***************
 *  prompt.cc  *
 *   ~~~~~~    *
 ***************/

#include "../include/cli.h"
#include "../include/global.h"
#include "../include/search.h"
#include <algorithm>
#include <map>
#include <sstream>
#include <stdio.h>

/* examine ()
 * Examines, deal with the given command and its arguments
 */
void
Cli::examine (std::list<std::string> command)
{
  std::list<std::string>::iterator arg = command.begin ();
  std::string command_name, first_arg, second_arg;
  command_name = *arg;
  if (command.size () > 1)
    first_arg = *++arg;
  if (command.size () > 2)
    second_arg = *++arg;
  
  if (command_name == "backup")
    {
      if (second_arg != "")
	error ("This command requires one argument.");
      else
	backup (first_arg);
    }
  else if (command_name == "clean")
    {
      if (first_arg != "")
	error ("This command does not require any argument.");
      else
	clean ();
    }
  else if (command_name == "dir")
    {
      if (first_arg == "" || second_arg != "")
	error ("This command requires one argument.");
      else
	dir_term = first_arg;
    }
  else if (command_name == "help")
    {
      if (second_arg != "")
	error ("This command requires (at most) one argument.");
      else
	  help (first_arg);
    }
  else if (command_name == "info")
    {
      if (first_arg == "")
	error ("Info about what ? You need to specify some number(s) !");
      else
	info (command);
    }
  else if (command_name == "load")
    {
      if (first_arg != "")
	error ("This command does not require any argument.");
      else
	load ();
    }
  else if (command_name == "pick")
    {
      if (first_arg == "")
	error ("This command requires one argument.");
      else
	pick (command);
    }
  else if (command_name == "purify")
    {
      if (first_arg == "")
	error ("This command requires one argument");
      else
	purify (command);
    }
  else if (command_name == "read")
    {
      if (first_arg != "")
	error ("This command does not require any argument.");
      else
	read ();
    }
  else if (command_name == "search")
    {
      if (first_arg == "" || second_arg != "")
	error ("This command requires one argument.");
      else
	{
	  dir_term = (dir_term != "") ? dir_term : "/";
	  search_term = first_arg;
	  search ();
	  std::cout << first_arg <<
	    gettext (" is being searched. Type 'read' to see results (you may wait a while before all results are displayed).") << std::endl;
	}
    }
  else if (command_name == "version")
    {
      if (first_arg != "")
	error ("This command does not require any argument.");
      else
	version ();
    }
}

/* parse_input ()
 * Takes user's input (could be anything), extracts the command
 * and eventually the arguments, and returns them in a std::list.
 */
std::list<std::string>
Cli::parse_input (std::string input)
{
  size_t first_space, other_space;
  first_space = input.find (" ");
  std::list<std::string> args = {""};
  
  // Get the first letter and the first word
  std::string cinitial = input.substr (0,1);
  if (cinitial == "p")
    cinitial = input.substr (0,2);
  std::string winitial = input.substr (0, first_space);
  
  // If there is no input, just return nothing
  if (winitial == "")
    return args;
  else
    args.clear ();

  // If they are the same, replace winitial by the corresponding command
  if (winitial == cinitial)
      winitial = char_map [cinitial];

  args.push_back (winitial);
  
  // Check if winitial is really a command
  if (std::find (std::begin (command_list),
		 std::end (command_list),
		 winitial) == std::end (command_list))
    {
      error ("Command unknown !");
      return args;
    }
  
  // Check if there are more arguments
  if (first_space != std::string::npos)
    {
      other_space = input.find (" ", ++first_space);
      while (other_space != std::string::npos)
	{
	  args.push_back (input.substr (first_space, other_space-first_space));
	  first_space = other_space;
	  other_space = input.find (" ", ++first_space);
	}
      args.push_back (input.substr (first_space));
    }
  return args;
}

std::string
Cli::prompt ()
{
  std::string command;
  std::cout << "\033[22;34mfisoco > \033[0;0m";
  getline (std::cin, command);
  return command;
}
