<?php

# FitGallery 0.90
# (C) Copyright  Omar Lpez 'pollo', Enrique D. Bosch 'presi'
# http://fitgallery.presi.org
#
# common security/error functions

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    http://www.gnu.org/licenses/gpl.html


define(VALID_CHARS,'+-.0123456789@ABCDEFGHIJKLMNOPQRSTUVWXYZ^_abcdefghijklmnopqrstuvwxyz');
define(MAX_LENG,200);
define(MAX_NUMBER,2000000000);

function exit_error($texto)
{
  header('Content-type: text/plain');
  echo "FitGallery: $texto";
  exit();
}

function invalid()
{
  exit_error('Invalid input.');
}

function check_input($cad,$limite,$leng=MAX_LENG)
{
  if ($limite=='number')
    {
      if ($cad=='') return 0; 
      if (!is_numeric($cad) || intval($cad)!=$cad || $cad<0 || $cad>MAX_NUMBER) exit_error('Invalid numeric input.'); 
    }
  else
    {
      if (($long=strlen($cad))>$leng) invalid();
      if ($long!=strspn($cad,$limite)) invalid();
    }
  return $cad;
}

?>
