<?php

# FitGallery 0.90
# (C) Copyright  Omar Lpez 'pollo', Enrique D. Bosch 'presi'
# http://fitgallery.presi.org
#
# thumb generator file
# args:
# galeria - string  - gallery name
# valor   - string  - image file name
# tipo    - string  - thumbnail type

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    http://www.gnu.org/licenses/gpl.html

include 'common_sec.php';

define('VIDEO',99);

function thumbnail ($galeria,$fichero,$tipo)
{

  include 'config/config-common.php';

  $dg=$dirgal.'/'.$galeria;
  if (!is_dir($dg)) exit_error('Gallery not found.');
  switch ($tipo)
  {
    case 'm': $rutathumbs=$dg.'/medium';
              $calidad=$quality_medium;
              $resample=$resample_medium;
              $altura=$h_medium;
              break;
    case 't': $rutathumbs=$dg.'/thumbs';
              $calidad=$quality_thumb;
              $resample=$resample_thumb;
              $altura=$h_thumb;
              break;
    default: exit_error('Bad thumbnail type.');
  }
  $ext='.jpeg';
  $imagenthumb=$rutathumbs.'/'.$fichero.$ext;

  if (file_exists($imagenthumb)) header("Location: $imagenthumb");
  else
  {
    include 'common_imgs.php';

    $rutaimgs=$dg.'/imgs';
    $imagen=$rutaimgs.'/'.$fichero;

    if (!is_file($imagen)) exit_error('Image not found.');

    if (es_img($imagen,$content))
    {
      if (($size=getimagesize($imagen))==false )
          exit_error('Source image corrupted or not supported.');
    }
    elseif ($video=es_video($imagen))
    {
      $size[0]=$video->getFrameWidth();
      $size[1]=$video->getFrameHeight();
      $size[2]=VIDEO;
    }
    else exit_error('Source video corrupted or not supported.');
    if ($size[0]==0 || $size[1]==0) exit_error('Source is not a supported image or video.');
    $new_w=$altura*$size[0]/$size[1];
    $new_h=$altura;
    $stipo=$size[2];

    if (!($gdv=gd_v())) exit_error('No GD found.');
    $sop=imagetypes();

    switch ($stipo)
    {
      case IMAGETYPE_JPEG: if ($sop & IMG_JPG) { $src_img=ImageCreateFromJpeg($imagen); break; }
      case IMAGETYPE_PNG:  if ($sop & IMG_PNG) { $src_img=ImageCreateFromPng($imagen); break;  }
      case IMAGETYPE_GIF:  if ($sop & IMG_GIF) { $src_img=ImageCreateFromGif($imagen); break;  }
      case VIDEO: if ($thumb_frame_forced) $capnframe=$thumb_frame;
                  else
                  {
                    $nframes=$video->getFrameCount();
                    $capnframe=round($nframes*$thumb_frame_frac);
                    if ($capnframe<=0) $capnframe=$thumb_frame;
                  }
                  if ($frame=$video->getFrame($capnframe)) $src_img=$frame->toGDImage();
                  else exit_error('Unable to create thumbnail.');
                  break;
      default: exit_error('Cannot read JPEG, PNG, GIF or video.');
    }
    if ($gdv>1) $dst_img=ImageCreateTrueColor($new_w,$new_h);
           else $dst_img=ImageCreate($new_w,$new_h);

    if ($resample)
      ImageCopyResampled($dst_img,$src_img,0,0,0,0,$new_w,$new_h,$size[0],$size[1]);
    else
      ImageCopyResized($dst_img,$src_img,0,0,0,0,$new_w,$new_h,$size[0],$size[1]);

    ImageJpeg($dst_img,$imagenthumb,$calidad);
    Imagedestroy($dst_img);
    header("Location: $imagenthumb");
  }

}


function gd_v()
{
  if (!extension_loaded('gd')) return 0;
  $info=gd_info();
  preg_match('/\d/', $info['GD Version'], $gdv);
  return $gdv[0];
}

$galeria=check_input($_GET['galeria'],VALID_CHARS);
$valor=check_input($_GET['valor'],VALID_CHARS);
$tipo=check_input($_GET['tipo'],'mt',1);

if ($galeria=='' || $valor=='') exit_error('Missing argument.');

thumbnail ($galeria,$valor,$tipo);

?>
