<?php

# FitGallery 0.91
# (C) Copyright  Omar Lpez 'pollo', Enrique D. Bosch 'presi'
# http://fitgallery.presi.org
#
# view thumbs
# args:
# galeria - string  - gallery name
# avance  - integer - number of thumbnails per page
# para    - integer - number of the first thumbnail to show
 
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    http://www.gnu.org/licenses/gpl.html

include 'common_html.php';
include 'common_sec.php';
include 'common_imgs.php';

include 'config/config-common.php';
include 'config/config-pages.php';
include 'config/config-lang.php';

$galeria=check_input($_GET['galeria'],VALID_CHARS);
if ($galeria=='') exit_error('Missing argument.');

if ($npages_user)
 {
   $avance=check_input($_GET['avance'],'number');
   if ($avance>$max_avance) $avance=$max_avance;
 }
if ($avance==0) $avance=$def_avance;

$para=check_input($_GET['para'],'number');

$dirimgs='imgs';
$semiruta=$dirgal.'/'.$galeria;
if (!is_dir($semiruta)) exit_error ('Gallery not found.');
$file_titulo=$semiruta.'/'.$titulo;
$texto_titulo=strtr(strip_tags(file_get_contents($file_titulo)),"\n",'');
$file_subtitulo=$semiruta.'/'.$subtitulo;
$ruta=$semiruta.'/'.$dirimgs;
$n=0;
$total=0;

$handle=opendir($ruta);            # Scan image directory
while ($file = readdir($handle))
{ 
 if ($file != '.' && $file != '..')
  {
    $arr[$n]['date']=date($date_string,filemtime("$ruta/$file"));
    $arr[$n]['file']=$file;
    $arr[$n]['bytes']=filesize("$ruta/$file");
    $arr[$n]['medium']=$h_medium;
    $arr[$n]['thumb']=$h_thumb;
    if (es_img("$ruta/$file",$content))
    {
        $arr[$n]['size']=getimagesize("$ruta/$file");
        $arr[$n]['exif']=false;
        $arr[$n]['exif_thumb']=false;
        $image_type=$arr[$n]['size'][2];
        if ($image_type==IMAGETYPE_JPEG)
        {
          if ($show_exif_thumbs)
            if (exif_thumbnail("$ruta/$file",$exif_w,$exif_h))
              if ($exif_h<=$h_thumb)
                $arr[$n]['exif_thumb']=true;
          
          if ($show_exif_info)
            if (exif_read_data("$ruta/$file",ANY_TAG,false,false))
            {
               $arr[$n]['exif']=true;
               $any_exif=true;
            }
        }
    }
    elseif ($video=es_video("$ruta/$file"))
    {
        $arr[$n]['size'][0]=$video->getFrameWidth();
        $arr[$n]['size'][1]=$video->getFrameHeight();
        $arr[$n]['size'][2]=0;
        $arr[$n]['dur']=dur_string($video->getDuration());
        if ($arr[$n]['size'][0]==0 || $arr[$n]['size'][1]==0) { $arr[$n]['medium']=0; $arr[$n]['thumb']=0; }
    }
    else { $arr[$n]['medium']=0; $arr[$n]['thumb']=0; }
    $total += $arr[$n]['bytes'];
    $n++;
  }
}
closedir($handle); 

$totalmegas=round($total/10485.76)/100;
sort($arr);
$numero_arch=count($arr);

if ($para>$numero_arch) exit_error('Images not found.');

$desde=$para+1;
$avmenosuno=$avance-1;
$hasta=$desde+$avmenosuno;
if ($hasta>$numero_arch) $hasta=$numero_arch;
$para2=$para+($avmenosuno);
$nummenosuno=$numero_arch-1;
$numer_pag=$nummenosuno/$avance;
$numer_pagmasuno=$numer_pag+1;

# Generate navigator array

for ($i = 1, $cuenta=$avance, $cuentaant=1; $i <= $numer_pagmasuno; $i++)
{
   if ($cuentaant!=$desde)
     {
       $arrnav[$i]['enlace']=true;
       $arrnav[$i]['para']=$cuentaant-1;
     }
   else $arrnav[$i]['enlace']=false;
   $arrnav[$i]['cua']=$cuentaant;
   if ($cuenta>$numero_arch) $arrnav[$i]['cu']=$numero_arch;
   else $arrnav[$i]['cu']=$cuenta;
   $cuentaant=$cuenta+1;
   $cuenta=$cuenta+$avance;
}

$anterior=$para-$avance;
$siguiente=$para+$avance;


html_begin($galeria,$style,$texto_titulo,$file_titulo,$file_subtitulo,$desde,$hasta,$version,$charset,$lang);

          # Print top navigator
if ($nav_pos=="top" || $nav_pos=="both")
    out_nav($arrnav,$numer_pagmasuno,$text_galerias,$text_pages,$galeria,$anterior,
            $text_anterior,$siguiente,$text_siguiente,$numero_arch,$avance);


      # Print top number-of-thumbnails-per-page form
if ($tpp_pos=="top" || $tpp_pos=="both")
    html_thpp_form($npages_user,$text_thpp,$avance,$text_change,$galeria);

html_sep();

       # Print images body
if ($para2 >= $numero_arch) $para2 = $nummenosuno;
for ( $i=$para ; $i <= $para2 ; $i++) 
    html_image($ruta,$galeria,$arr[$i]['medium'],$text_medium,$arr[$i]['thumb'],$i,$arr[$i]['file'],
               $arr[$i]['size'],$arr[$i]['bytes'],$arr[$i]['date'],
               $arr[$i]['exif_thumb'],$arr[$i]['exif'],$text_exif,&$any_exif,$arr[$i]['dur']);

html_sep();

      # Print bottom navigator
if ($nav_pos=="bottom" || $nav_pos=="both")
    out_nav($arrnav,$numer_pagmasuno,$text_galerias,$text_pages,$galeria,$anterior,
            $text_anterior,$siguiente,$text_siguiente,$numero_arch,$avance);


      # Print bottom number-of-thumbnails-per-page form
if ($tpp_pos=="bottom" || $tpp_pos=="both")
    html_thpp_form($npages_user,$text_thpp,$avance,$text_change,$galeria);


html_end($text_totales,$total,$totalmegas,$powered,$text_powered,$version,$print_totals,$w3logo);


# ------------- functions

function out_nav($arrnav,$numer_pagmasuno,$text_galerias,$text_pages,$galeria,$anterior,
                 $text_anterior,$siguiente,$text_siguiente,$numero_arch,$avance)
{
  html_nav_begin($text_galerias,$text_pages);

  for ($i = 1; $i <= $numer_pagmasuno; $i++)
     html_nav_elem($arrnav[$i]['enlace'],$galeria,$arrnav[$i]['para'],$avance,
                   $arrnav[$i]['cua'],$arrnav[$i]['cu']);

  html_nav_end($anterior,$text_anterior,$galeria,$siguiente,$text_siguiente,$numero_arch,$avance);

}


function html_begin($galeria,$style_thumb,$texto_titulo,$file_titulo,$file_subtitulo,$desde,$hasta,$version,$charset,$lang)
{

if (file_exists("styles/$galeria-$style_thumb")) { $style="$galeria-$style_thumb"; }
else { $style=$style_thumb; }

html_header($style,$texto_titulo,$version,$charset,$lang);

echo'
<h3 class="normal">';
include "$file_titulo";
echo '</h3>
';
echo "<h4 class=\"normal\">";
include "$file_subtitulo";
echo "\n</h4>
<h4 class=\"normal\">$desde-$hasta</h4>\n";
}


function html_nav_begin($text_galerias,$text_pages)
{
echo '
<p class="clear">
';
if (file_exists('ver_gals.php')) echo "<a class=\"texto\" href=\"ver_gals.php\">$text_galerias</a> | ";
echo "<strong>$text_pages:</strong> ";
}


function html_nav_elem($enlace,$galeria,$para,$avance,$cuentaant,$cuenta)
{
if ($enlace) echo "<a class=\"texto\" href=\"ver_thumb.php?galeria=$galeria&amp;para=$para&amp;avance=$avance\">";
echo "$cuentaant-$cuenta";
if ($enlace) echo '</a>';
echo ' | ';
}


function html_nav_end($anterior,$text_anterior,$galeria,$siguiente,$text_siguiente,$numero_arch,$avance)
{
if ($anterior<0) echo $text_anterior;
            else echo "<a class=\"texto\" href=\"ver_thumb.php?galeria=$galeria&amp;para=$anterior&amp;avance=$avance\">$text_anterior</a>";
echo ' | ';
if ($siguiente>=$numero_arch) echo $text_siguiente;
            else echo "<a class=\"texto\" href=\"ver_thumb.php?galeria=$galeria&amp;para=$siguiente&amp;avance=$avance\">$text_siguiente</a>";
echo '</p>';
}


function html_image($ruta,$galeria,$h_medium,$text_medium,$h_thumb,$i,$valor,$size,$bytes,$fecha,
                     $exif_thumb,$exif,$text_exif,$any_exif,$dur)
{
   echo "
   <div class=\"figure\">
   <p class=\"caption\">";
   if ($h_thumb)
   {
   echo "
   <a href=\"$ruta/$valor\">\n";
   if ($exif_thumb)
     $thumbsrc="exif_thumb.php?img=$valor&amp;galeria=$galeria";
   else
     $thumbsrc="thumb.php?galeria=$galeria&amp;valor=$valor&amp;tipo=t";
   echo "   <img class=\"thumbnail\" src=\"$thumbsrc\" alt=\"$valor\">
   </a>
   <br>\n";
   }
   if ($h_medium) 
     echo "   <a class=\"texto\" href=\"thumb.php?galeria=$galeria&amp;valor=$valor&amp;tipo=m\">$text_medium</a>\n   <br>\n";
   if ($exif)
     echo "   <a class=\"texto\" href=\"exif.php?valor=$valor&amp;galeria=$galeria\">$text_exif</a>\n   <br>\n";
   else
     if ($any_exif) echo "   <br>\n";
   echo "   </p>\n";
   echo "   <p class=\"caption\">\n   ";
   echo $i+1;
   echo ". \n";
   echo "   <a class=\"texto\" href=\"$ruta/$valor\">
   $valor
   </a>
   <br>
   $size[0]x$size[1] $dur<br>
   $bytes bytes<br>
   $fecha
   </p>
   </div>
";
}


function html_thpp_form($npages_user,$text_thpp,$avance,$text_change,$galeria)
{
if ($npages_user) echo "
<form class=\"tpp\" action=\"ver_thumb.php\" method=\"get\">
<p class=\"normal\">
$text_thpp <input class=\"tppin\" type=\"text\" name=\"avance\" value=\"$avance\" size=\"3\" maxlength=\"3\">
<input class=\"tppbu\" type=\"submit\" value=\"$text_change\">
<input type=\"hidden\" name=\"galeria\" value=\"$galeria\">
</p>
</form>";
}


function html_end($text_totales,$total,$totalmegas,$powered,$text_powered,$version,$print_totals,$w3logo)
{

if ($print_totals)
{
echo "<p class=\"clear\">
$text_totales$total ($totalmegas MB)
";
echo '</p>
';
}

html_bottom($powered,$text_powered,$version,$w3logo);

}


function dur_string($s)
{
  if ($s)
  {
    $m=floor($s/60)%60;
    $h=floor($s/3600);
    $s=$s%60;
    return "$h:$m:$s";
  }
}

?>
