<?php

# FitGallery 0.92
# (C) Copyright  Enrique D. Bosch 'presi'
# http://fitgallery.presi.org
#
# common image and video functions

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    http://www.gnu.org/licenses/gpl.html


function es_img($fichero,$content)
{
   if ($content)
   {
     $f_tipo=mime_content_type($fichero);
     return ($f_tipo=='image/gif' || $f_tipo=='image/jpeg' || $f_tipo=='image/png');
   }
   else
   {
     $ext=strtolower(array_pop(explode('.',$fichero)));
     return ($ext=='jpg' || $ext=='png' || $ext=='gif' || $ext=='jpeg' ||
             $ext=='jpe' || $ext=='jif' || $ext=='jfi' || $ext=='jfif');
   }
}

function es_video($fichero)
{
    if (!esta_ffmpeg()) exit_error('No ffmpeg found.');
    return (new ffmpeg_movie($fichero));
}

if (!function_exists('mime_content_type'))
{
   function mime_content_type($fichero)
   {
      $finfo=finfo_open(FILEINFO_MIME);
      $tipo_mime=finfo_file($finfo,$fichero);
      finfo_close($finfo);
      return $tipo_mime;
   }
}

function esta_ffmpeg()
{
   if (extension_loaded('ffmpeg')) return 1;
   return 0;
}

?>
