<?php

# FitGallery 0.92
# (C) Copyright  Omar Lpez 'pollo', Enrique D. Bosch 'presi'
# http://fitgallery.presi.org
#
# view gallery thumbs
# args:
# avance - integer - number of thumbnails per page
# para   - integer - number of the first thumbnail to show

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    http://www.gnu.org/licenses/gpl.html

include 'common_html.php';
include 'common_sec.php';

include 'config/config-common.php';

if (file_exists('config/config-gals.php')) { include 'config/config-gals.php'; }
else { include 'config/config-pages.php'; }

include 'config/config-lang.php';

if ($npages_user)
 {
   $avance=check_input($_GET['avance'],'number');
   if ($avance>$max_avance) $avance=$max_avance;
 }
if ($avance==0) $avance=$def_avance;

$para=check_input($_GET['para'],'number');

$dirimgs="imgs";
$titulo_texto=strtr(strip_tags(file_get_contents($titulo)),"\n",'');
$n=0;
$total=0;
$subtotal=0;
$numimgs=0;

$handle=opendir($dirgal);         # Scan galeries directory
while ($file = readdir($handle))
{ 
 if ($file != '.' && $file != '..')
  {
    $item="$dirgal/$file";
    if (is_readable($item))
    {
      if (is_dir($item))
       {
         include 'scan_gal_dir.php';

         $arr[$n]['file']=$file;
         $arr[$n]['mtime']=date($date_string,$mtime);
         $arr[$n]['subtotal']=$subtotal;
         $subtotal=0;
         $arr[$n]['numimgs']=$numimgs;
         $numimgs=0;
         $arr[$n]['primero']=$primero;
       }
      else
       {
         $arrfich=file($item);
         $arr[$n]['url_prefix']=rtrim($arrfich[0]).'/';
         $arr[$n]['file']=rtrim($arrfich[1]);
         if (($thumb_remoto=rtrim($arrfich[2])) == '')
           {
             $url_fich=file($arr[$n]['url_prefix'].'info_gal.php?valor='.$arr[$n]['file']);
             $arr[$n]['mtime']=date($date_string,$url_fich[0]);
             $arr[$n]['subtotal']=$url_fich[1];
             $arr[$n]['numimgs']=$url_fich[2];
             $arr[$n]['primero']=$url_fich[3];
             $arr[$n]['titulo']=$url_fich[4];
           }
         else
           {
             $arr[$n]['primero']=$thumb_remoto;
             $arr[$n]['titulo']=$arrfich[3];
           }
       }
      $total += $arr[$n]['subtotal'];
      $n++;
    }
  }
}
closedir($handle); 

sort($arr);
$numero_arch=count($arr);

if ($para>$numero_arch) exit_error('Images not found.');

$desde=$para+1;
$avmenosuno=$avance-1;
$hasta=$desde+$avmenosuno;
if ($hasta>$numero_arch) $hasta=$numero_arch;
$para2=$para+($avmenosuno);
$nummenosuno=$numero_arch-1;
if ($para2 >= $numero_arch) $para2 = $nummenosuno;
$numer_pag=$nummenosuno/$avance;
$numer_pagmasuno=$numer_pag+1;


# Generate navigator array

for ($i = 1, $cuenta=$avance, $cuentaant=1; $i <= $numer_pagmasuno; $i++)
{
   if ($cuentaant!=$desde)
     {
       $arrnav[$i]['enlace']=true;
       $arrnav[$i]['para']=$cuentaant-1;
       $arrnav[$i]['avance']=$avance;
     }
   else $arrnav[$i]['enlace']=false;
   $arrnav[$i]['cua']=$cuentaant;
   if ($cuenta>$numero_arch) $arrnav[$i]['cu']=$numero_arch;
   else $arrnav[$i]['cu']=$cuenta;
   $cuentaant=$cuenta+1;
   $cuenta=$cuenta+$avance;
}

$totalmegas=round($total/10485.76)/100;
$anterior=$para-$avance;
$siguiente=$para+$avance;


html_begin($style,$titulo_texto,$titulo,$subtitulo,$desde,$hasta,$version,$charset,$lang);


          # Print top navigator
if ($nav_pos=="top" || $nav_pos=="both")
    out_nav($arrnav,$numer_pagmasuno,$text_pages,$anterior,
            $text_anterior,$siguiente,$text_siguiente,$numero_arch,$avance);


      # Print number-of-thumbnails-per-page form
if ($tpp_pos=="top" || $tpp_pos=="both")
    html_gapp_form($npages_user,$text_gapp,$avance,$text_change);

html_sep();

       # Print images body
if ($para2 >= $numero_arch) $para2 = $nummenosuno;
for ( $i=$para ; $i <= $para2 ; $i++)
   {
     $valor=$arr[$i]['file'];
     if ($arr[$i]['titulo'] != '') $titulo_galeria_texto=$arr[$i]['titulo'];
     else $titulo_galeria_texto=strtr(strip_tags(file_get_contents("$dirgal/$valor/$titulo")),"\n",'');

     $megas=round($arr[$i]['subtotal']/10485.76)/100;

     html_image($arr[$i]['url_prefix'],$valor,$arr[$i]['primero'],$i,
                $titulo_galeria_texto,$arr[$i]['numimgs'],$text_images,
                $arr[$i]['subtotal'],$megas,$arr[$i]['mtime'],$remote_espace);

   }

html_sep();

      # Print bottom navigator
if ($nav_pos=="bottom" || $nav_pos=="both")
    out_nav($arrnav,$numer_pagmasuno,$text_pages,$anterior,
            $text_anterior,$siguiente,$text_siguiente,$numero_arch,$avance);


      # Print number-of-thumbnails-per-page form
if ($tpp_pos=="bottom" || $tpp_pos=="both")
    html_gapp_form($npages_user,$text_gapp,$avance,$text_change);


html_end($text_totales,$total,$totalmegas,$powered,$text_powered,$version,$print_totals,$w3logo);


# ------------- functions

function out_nav($arrnav,$numer_pagmasuno,$text_pages,$anterior,
                 $text_anterior,$siguiente,$text_siguiente,$numero_arch,$avance)
{
  html_nav_begin($text_pages);

  for ($i = 1; $i <= $numer_pagmasuno; $i++)
     html_nav_elem($arrnav[$i]['enlace'],$arrnav[$i]['para'],$arrnav[$i]['avance'],
                   $arrnav[$i]['cua'],$arrnav[$i]['cu']);

  html_nav_end($anterior,$text_anterior,$siguiente,$text_siguiente,$numero_arch,$avance);

}


function html_begin($style,$texto_titulo,$file_titulo,$file_subtitulo,$desde,$hasta,$version,$charset,$lang)
{

html_header($style,$texto_titulo,$version,$charset,$lang);

echo '<h3 class="normal">';
include "$file_titulo";
echo '</h3>
';
echo "<h4 class=\"normal\">";
include "$file_subtitulo";
echo "\n</h4>
<h4 class=\"normal\">$desde-$hasta</h4>\n";
}


function html_nav_begin($text_pages)
{
echo "
<p class=\"nav\">
<strong>$text_pages:</strong> ";
}


function html_nav_elem($enlace,$para,$avance,$cuentaant,$cuenta)
{
if ($enlace) echo "<a class=\"texto\" href=\"ver_gals.php?para=$para&amp;avance=$avance\">";
echo "$cuentaant-$cuenta";
if ($enlace) echo '</a>';
echo ' | ';
}


function html_nav_end($anterior,$text_anterior,$siguiente,$text_siguiente,$numero_arch,$avance)
{
if ($anterior<0) echo $text_anterior;
            else echo "<a class=\"texto\" href=\"ver_gals.php?para=$anterior&amp;avance=$avance\">$text_anterior</a>";
echo ' | ';
if ($siguiente>=$numero_arch) echo $text_siguiente;
            else echo "<a class=\"texto\" href=\"ver_gals.php?para=$siguiente&amp;avance=$avance\">$text_siguiente</a>";
echo '</p>';
}


function html_image($url_prefix,$valor,$portada,$i,$titulo_galeria_texto,
                    $size,$text_images,$bytes,$megas,$fecha,$remote_espace)
{
   echo "
   <div class=\"figure\">
   <p class=\"caption\">
   <a href=\"".$url_prefix."ver_thumb.php?galeria=$valor\">
   <img class=\"thumbnail\" src=\"".$url_prefix."thumb.php?galeria=$valor&amp;valor=$portada&amp;tipo=t\" alt=\"$valor\">
   </a>
   </p>
   <p class=\"caption\">\n   ";
   echo $i+1;
   echo ". \n";
   echo "   <a class=\"texto\" href=\"".$url_prefix."ver_thumb.php?galeria=$valor\">
   $valor<br>
   </a>
   $titulo_galeria_texto   <br>";
   if ($size != '')
    {
      echo "
      $size $text_images<br>
      $bytes bytes ($megas MB)<br>
      $fecha";
    }
   else if ($remote_espace) echo '<br><br><br>';
   echo '
   </p>
   </div>
';
}


function html_gapp_form($npages_user,$text_gapp,$avance,$text_change)
{
if ($npages_user) echo "
<form class=\"tpp\" action=\"ver_gals.php\" method=\"get\">
<p class=\"normal\">
$text_gapp <input class=\"tppin\" type=\"text\" name=\"avance\" value=\"$avance\" size=\"3\" maxlength=\"3\">
<input class=\"tppbu\" type=\"submit\" value=\"$text_change\">
</p>
</form>";
}


function html_end($text_totales,$total,$totalmegas,$powered,$text_powered,$version,$print_totals,$w3logo)
{

if ($print_totals)
{
echo "<p class=\"clear\">
$text_totales$total ($totalmegas MB)
";
echo '</p>
';
}

html_bottom($powered,$text_powered,$version,$w3logo);

}

?>
