<?php

# FitGallery 0.95
# (C) Copyright  Omar Lpez 'pollo', Enrique D. Bosch 'presi'
# http://fitgallery.presi.org
#
# show exif thumbnail
# args:
# galeria - string - gallery name
# img     - string - image file name

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    http://www.gnu.org/licenses/gpl.html

include 'common_sec.php';
include 'config/config-common.php';

function exif_thumb($valor,$galeria)
{
    include 'config/config-common.php';

    $dg="$dirgal/$galeria";
    $fichero="$dg/imgs/$valor";

    if (!is_dir($dg)) exit_error('Gallery not found.');
    if (!is_file($fichero)) exit_error('Image not found.');

    $image = exif_thumbnail($fichero, $width, $height, $type);
    header('Content-type: ' .image_type_to_mime_type($type));
    echo $image;
}

$img=check_input($_GET['img'],VALID_CHARS);
$galeria=check_input($_GET['galeria'],VALID_CHARS);

if ($img=='' || $galeria=='') exit_error('Missing argument.');

if ($show_exif_thumbs || $show_exif_info) exif_thumb($img,$galeria);

?> 
