<?php

# FitGallery 1.01
# (C) Copyright  Omar Lpez 'pollo', Enrique D. Bosch 'presi'
# http://fitgallery.presi.org
#
# show exif information
# args:
# galeria - string - gallery name
# valor   - string - image file name

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    http://www.gnu.org/licenses/gpl.html

include 'common_html.php';
include 'common_sec.php';
include 'config/config-common.php';

function html_exif_info($galeria,$valor)
{
  include 'config/config-common.php';

  if (file_exists('config/config-exif.php')) { include 'config/config-exif.php'; }
  else { include 'config/config-pages.php'; }

  include 'config/config-lang.php';

  $dg="$dirgal/$galeria";
  $fichero="$dg/imgs/$valor";

  if (!is_dir($dg)) exit_error('Gallery not found.');
  if (!is_file($fichero)) exit_error('Image not found.');

  $exif = exif_read_data($fichero,ANY_TAG,true,false);

  html_header($style,$text_exif,$version,$charset,$lang);
  
  echo "
<h2 class=\"normal\">$text_exif</h2>\n
<table class=\"table_exif\">\n
<tr class=\"table_header\"><td>$text_exif_section</td><td>$text_exif_variable</td><td>$text_exif_value</td></tr>
<tr><td class=\"table_item\">THUMBNAIL</td><td class=\"table_item\">$text_exif_thumbnail</td><td class=\"table_item\"><img class=\"exif_thumb\" src=\"exif_thumb.php?img=$valor&amp;galeria=$galeria\" alt=\"Thumb\"></td></tr>
";

  foreach ($exif as $key => $section)
    foreach ($section as $name => $val)
      if ($name!='MakerNote' && substr($name,0,12)!='UndefinedTag')
         {
           if ($name=='FileDateTime') $val=date($date_string,$val);
           $val=trim($val,"\x00..\x1f\x7b..\x7f");
           echo "<tr><td class=\"table_item\">$key</td><td class=\"table_item\">$name</td><td class=\"table_item\">$val</td></tr>\n";
         }
  echo "</table>\n\n";

  html_bottom($powered, $text_powered, $version, $w3logo);
}

$galeria=check_input($_GET['galeria'],VALID_CHARS);
$valor=check_input($_GET['valor'],VALID_CHARS);

if ($galeria=='' || $valor=='') exit_error('Missing argument.');

if ($show_exif_info) html_exif_info($galeria,$valor);

?> 
