#include "../config.h"

#ifdef MARCEL
#define MARCEL_INTERNAL_INCLUDE
#include "marcel.h"
#endif

#ifdef HAVE_CLOCK_GETTIME
#include <time.h>
#else
/* to get an efficient implementation of the TBX_GET_TICK on various archs */
#include "tbx_timing.h"
#endif

#define tbx_unlikely(x) __builtin_expect(!!(x), 0)

#include "fxt.h"
#include "fut.h"

#ifdef PROFILE_NEW_FORMAT

/* pseudo fonction pour trouver o crire un vnement dans les buffers */

/*
 * Structure du buffer de trace
 *
 * ADDR (a<b<c...)
 * ||
 * \/
 * 
 * a /--------------- 1re zone
 *     struct record
 *        last_event = c
 *        start = a
 *        end = e
 *
 * b   ev1
 *
 *     ev2
 *
 *     ...
 *
 * c   evn
 *
 * d   FREE SPACE
 * 
 * e /--------------- 2ime zone
 *     struct record
 *        last_event = g
 *        start = e
 *        end = i
 *        
 * f   ev1
 *
 *     ...
 *
 * g   evn
 *
 * h   FREE SPACE
 *
 * i /--------------- 3ime zone
 *   ...
 * 
 * */


// Variables globales :
void *start_buffer;
void *pos_buffer;
void *end_buffer;

FXT_PERTHREAD_DEFINE(struct fxt_perthread, fxt_perthread_data)

#define SIZE_BUFF 200 /* au hazard */

int __attribute__((no_instrument_function)) 
fut_header (unsigned long code, ... ) 
{
	long size=code && 0xFF;
  
	th_buff old_th, new_th;
  
  restart:
 	/* lecture atomique des 2 valeurs (8 octets) */
 	read8(th_buff, old_th);

	new_th = old_th;
	new_th.pos += size;

	if (new_th.pos > new_th.infos->end) {
     		/* les infos ne tiennent pas dans la place du buffer 
		 * On cherche un nouveau buffer/record */
		void* old_pos = pos_buffer;
		
		void* new_pos = old_pos + SIZE_BUFF;

		if (new_pos > end_buffer) {
			/* On stoppe tout comme actuellement */
			...

			return -E_NOSPACELEFT;
		}
		if (!lock_cmpxchg(pos_buffer, old_pos, new_pos)) {
			/* Des choses ont changs, peut-tre nous qui avons t
			 * interrompu et avons alors dj rexcut ce code
			 * (donc donn une nouvelle zone  ce thread */
			goto restart;
		}
		/* Ok, on est propritaire de la nouvelle rgion qui va de
		 * old_pos  new_pos */
		
		/* On prvoit de la place pour :
		 * 1) les donnes de controle (struct record)
		 * 2) notre vnement
		 * */
		new_th.pos=old_pos+sizeof(record_t)+size;
		
		*((struct record*)old_pos) = {
			.start=old_pos;
			.end=new_pos;
			.last_event=old_pos;
		};
		
		/* Sur ia32, on a cmpxchg8,
		 * mais sur ia64, on a seulement cmp4xchg8 (en fait cmp8xchg16
		 * vu qu'on est en 64 bits)
		 * J'cris donc l'algo avec le plus contraignant
		 *
		 * cmp4xchg8 : compare 4 octets, mais en cas d'galit on en crit 8
		 * */
		if (!cmp4xchg8(th_buff.pos, old_th.pos, new_th)) {
			/* Arghhh, on a t interrompu par une autre mesure qui
			 * a mis en place un nouveau buffer
			 * */
			if (lock_cmpxchg(pos_buffer, new_pos, old_pos)) {
				/* On redonne la zone qu'on vient d'allouer si
				 * c'est encore possible */
				goto restart;
			}
			/* Bon, ben on a une zone avec une mesure et pas grand
			 * chose d'autre  mettre dedans...
			 * Tant pis
			 *
			 * cas (*) (voir TODO)
			 * */
		}
	}
	/* criture des donnes  l'adresse :
	 * new_th.pos - size
	 * */
	...
  restart_update:
	/* Et mise  jour du pointeur sur la dernire criture de la zone */
	int old_last_ev=new_th.infos->last_event;
	if (new_th.pos > old_last_ev) {
		if (!cmpxchg(new_th.infos->last_event, old_last_ev, new_th.pos)) {
			goto restart_update;
		}
	}
	return 0;
}




#else /* PROFILE_NEW_FORMAT */

#ifndef MARCEL
/* poor man's cmpxchg,  supprimer lorsque tbx implmentera cmpxchg lui-mme */
#define ma_cmpxchg(ptr,o,n) \
	__sync_val_compare_and_swap((ptr), (o), (n))
#endif

static unsigned long trash_buffer[8];

unsigned long* fut_getstampedbuffer(unsigned long code, 
						      int size)
{
	unsigned long *prev_slot, *next_slot;

	do {
		prev_slot=(unsigned long *)fut_next_slot;
		next_slot=(unsigned long*)((unsigned long)prev_slot+size);
	} while (prev_slot != ma_cmpxchg(&fut_next_slot, 
					 prev_slot, next_slot));

	if (tbx_unlikely(next_slot > fut_last_slot)) {
		fut_active=0;
		/* Pourquoi on restaure ici ? Pas de race condition possible ? */
		fut_next_slot=prev_slot;
		return trash_buffer;
	}

	fxt_trace_user_raw_t *rec=(fxt_trace_user_raw_t *)prev_slot;

	unsigned long long tick;
#ifdef HAVE_CLOCK_GETTIME
	struct timespec tp;
#ifdef CLOCK_MONOTONIC_RAW
	/* avoid NTP mess */
	clock_gettime(CLOCK_MONOTONIC_RAW, &tp);
#else
	clock_gettime(CLOCK_MONOTONIC, &tp);
#endif
	tick = 1000000000ULL*tp.tv_sec+ tp.tv_nsec;
#else
	TBX_GET_TICK(tick);
#endif

	rec->tick = tick;
#ifdef MA__FUT_RECORD_TID
	rec->tid=(unsigned long)MARCEL_SELF;
#else
	/* XXX for now, the tid field is not filled */
	rec->tid = 0;
#endif
	rec->code = code;
	return (unsigned long*)(rec->args);
}

#endif /* PROFILE_NEW_FORMAT */
