/*
	Copyright (C) 2005 Brian Gunlogson

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _DICER_H
#define _DICER_H

#include <string>

typedef int (*PROMPT_USER_t)(const char *);

class Dicer
{
public:
	Dicer(PROMPT_USER_t prompt_user);
	~Dicer();
	
  void SetNoPrompt(bool no_prompt) {m_no_prompt = no_prompt;};

	bool SetSize(const long long int size);
	bool SetArchivePath(const char *filename, bool devicefile);

  void PrintSettings();
  
  int ReadData(std::string &buffer, unsigned int length);
  
	off_t GetArchivePosition();
	bool Seek(off_t offset, int method);
	
private:
	off_t m_size, m_slice_offset;
	PROMPT_USER_t m_prompt_user;
	
	std::string m_slice_path, m_slice_base_name;
	bool m_isdevicefile;
	
	unsigned int m_slice_num, m_last_slice_num;
	FILE *m_slice_file_handle;
	
	std::string SliceFileName();
	bool SetFullName(const std::string & full_name);

  bool m_no_prompt;

	bool HandleSlices();
	
	size_t ReadAmmount();
	
	bool InternalSeek(off_t offset, int method);
	
	bool SwitchSlice(unsigned int slice_num, bool lastslice);
};

#endif /* _DICER_H */

