/*
	Copyright (C) 2005 Brian Gunlogson

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _SHA1SUM_H
#define _SHA1SUM_H

#include <sys/types.h>

/* Structure to save state of computation between the single steps.  */
struct sha_ctx
{
  u_int32_t A;
  u_int32_t B;
  u_int32_t C;
  u_int32_t D;
  u_int32_t E;

  u_int32_t total[2];
  u_int32_t buflen;
  char buffer[128];
};

class Sha1Sum {
public:
	Sha1Sum();
	~Sha1Sum();
	
  void Reset();
  
	bool AddBlock(const void *buffer, size_t len);
	void AddBytes(const void *buffer, size_t len);
	
	void * Finish(void *resbuf);
	void * ReadCtx(void *resbuf);
	
private:
	sha_ctx m_ctx;
	static const unsigned char m_fillbuf[64];
};

#endif /* _SHA1SUM_H */

