/*
 * debug.c - Print debug information to stdout.
 *           This file is part of the FreeLCD package.
 *
 * $Id: debug.c,v 1.3 2004/06/20 12:32:31 unicorn Exp $
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 *
 * Copyright (c) 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */


#if HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef USE_DEBUG

#include "debug.h"

#include <stdlib.h>
#include <stdarg.h>

static FILE *_handle = NULL;

void message (const char *format, ...)
{
  va_list ap;
  char    buf[512];
  
  if (_handle == NULL)
    return;

  va_start (ap, format);
  vsnprintf (buf, sizeof (buf), format, ap);
  va_end (ap);

  fprintf (_handle, "%s\n", buf);
  fflush (_handle);
}

void set_debug_output (FILE *handle)
{
  close_debug_output ();
  _handle = handle;
}

void close_debug_output (FILE *handle)
{
  if (_handle != NULL)
    fclose (_handle);
}

#else /* !USE_DEBUG */

void message (const char *format, ...)
{}

#endif /* !USE_DEBUG */
