/*
 * debug.h - Print debug information to stdout.
 *           This file is part of the FreeLCD package.
 *
 * $Id: debug.h,v 1.2 2004/06/20 12:32:57 unicorn Exp $
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 *
 * Copyright (c) 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */

/**
 * \file debug.h
 * Simple logging facility for debugging purposes.
 */

#ifndef _FLCDD_DEBUG_H
#define _FLCDD_DEBUG_H 1

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef USE_DEBUG

#include <stdio.h>

#define debug(arg1) message ( __FILE__ ": " arg1)
#define debug_2(arg1, arg2) message ( __FILE__ ": " arg1, arg2)
#define debug_3(arg1, arg2, arg3) message ( __FILE__ ": " arg1, arg2, arg3)
#define debug_4(arg1, arg2, arg3, arg4) message ( __FILE__ ": " arg1, arg2, \
                                                                arg3, arg4)
/** Print debug information.
 * No information is actually printed until a handle has been assigned with
 * set_debug_output().
 * \param format A format string, works the same as printf.
 */
void message (const char *format, ...);

/** Direct the debug information to a handle.
 * \param handle The handle to send the debug information to. Normally this
 *               is stdout, or a file handle.
 */
void set_debug_output (FILE *handle);

void close_debug_output ();

#else /* not USE_DEBUG */

#define debug(foo)
#define debug_2(foo, bar)
#define debug_3(foo, bar, baz)
#define debug_4(foo, bar, baz, quux)

#define set_debug_output(foo)
#define close_debug_output()

#endif /* not USE_DEBUG */

#endif
