/*
 *  entities.c - Conversion from character entity strings to unicode.
 *               This file is part of the FreeLCD package.
 *  
 *  $Id: entities.c,v 1.1 2004/01/17 00:01:56 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */

#include "dictionary.h"

static dict_pair entities[] = 
{
  { "AElig",    (void*)198 },
  { "Aacute",   (void*)193 },
  { "Acirc",    (void*)194 },
  { "Agrave",   (void*)192 },
  { "Alpha",    (void*)913 },
  { "Aring",    (void*)197 },
  { "Atilde",   (void*)195 },
  { "Auml",     (void*)196 },
  { "Beta",     (void*)914 },
  { "Ccedil",   (void*)199 },
  { "Chi",      (void*)935 },
  { "Dagger",   (void*)8225 },
  { "Delta",    (void*)916 },
  { "ETH",      (void*)208 },
  { "Eacute",   (void*)201 },
  { "Ecirc",    (void*)202 },
  { "Egrave",   (void*)200 },
  { "Epsilon",  (void*)917 },
  { "Eta",      (void*)919 },
  { "Euml",     (void*)203 },
  { "Gamma",    (void*)915 },
  { "Iacute",   (void*)205 },
  { "Icirc",    (void*)206 },
  { "Igrave",   (void*)204 },
  { "Iota",     (void*)921 },
  { "Iuml",     (void*)207 },
  { "Kappa",    (void*)922 },
  { "Lambda",   (void*)923 },
  { "Mu",       (void*)924 },
  { "Ntilde",   (void*)209 },
  { "Nu",       (void*)925 },
  { "OElig",    (void*)338 },
  { "Oacute",   (void*)211 },
  { "Ocirc",    (void*)212 },
  { "Ograve",   (void*)210 },
  { "Omega",    (void*)937 },
  { "Omicron",  (void*)927 },
  { "Oslash",   (void*)216 },
  { "Otilde",   (void*)213 },
  { "Ouml",     (void*)214 },
  { "Phi",      (void*)934 },
  { "Pi",       (void*)928 },
  { "Prime",    (void*)8243 },
  { "Psi",      (void*)936 },
  { "Rho",      (void*)929 },
  { "Scaron",   (void*)352 },
  { "Sigma",    (void*)931 },
  { "THORN",    (void*)222 },
  { "Tau",      (void*)932 },
  { "Theta",    (void*)920 },
  { "Uacute",   (void*)218 },
  { "Ucirc",    (void*)219 },
  { "Ugrave",   (void*)217 },
  { "Upsilon",  (void*)933 },
  { "Uuml",     (void*)220 },
  { "Xi",       (void*)926 },
  { "Yacute",   (void*)221 },
  { "Yuml",     (void*)376 },
  { "Zeta",     (void*)918 },
  { "aacute",   (void*)225 },
  { "acirc",    (void*)226 },
  { "acute",    (void*)180 },
  { "aelig",    (void*)230 },
  { "agrave",   (void*)224 },
  { "alefsym",  (void*)8501 },
  { "alpha",    (void*)945 },
  { "amp",      (void*)38 },
  { "and",      (void*)8743 },
  { "ang",      (void*)8736 },
  { "aring",    (void*)229 },
  { "asymp",    (void*)8776 },
  { "atilde",   (void*)227 },
  { "auml",     (void*)228 },
  { "bdquo",    (void*)8222 },
  { "beta",     (void*)946 },
  { "brvbar",   (void*)166 },
  { "bull",     (void*)8226 },
  { "cap",      (void*)8745 },
  { "ccedil",   (void*)231 },
  { "cedil",    (void*)184 },
  { "cent",     (void*)162 },
  { "chi",      (void*)967 },
  { "circ",     (void*)710 },
  { "clubs",    (void*)9827 },
  { "cong",     (void*)8773 },
  { "copy",     (void*)169 },
  { "crarr",    (void*)8629 },
  { "cup",      (void*)8746 },
  { "curren",   (void*)164 },
  { "dArr",     (void*)8659 },
  { "dagger",   (void*)8224 },
  { "darr",     (void*)8595 },
  { "deg",      (void*)176 },
  { "delta",    (void*)948 },
  { "diams",    (void*)9830 },
  { "divide",   (void*)247 },
  { "eacute",   (void*)233 },
  { "ecirc",    (void*)234 },
  { "egrave",   (void*)232 },
  { "empty",    (void*)8709 },
  { "emsp",     (void*)8195 },
  { "ensp",     (void*)8194 },
  { "epsilon",  (void*)949 },
  { "equiv",    (void*)8801 },
  { "eta",      (void*)951 },
  { "eth",      (void*)240 },
  { "euml",     (void*)235 },
  { "euro",     (void*)8364 },
  { "exist",    (void*)8707 },
  { "fnof",     (void*)402 },
  { "forall",   (void*)8704 },
  { "frac12",   (void*)189 },
  { "frac14",   (void*)188 },
  { "frac34",   (void*)190 },
  { "frasl",    (void*)8260 },
  { "gamma",    (void*)947 },
  { "ge",       (void*)8805 },
  { "gt",       (void*)62 },
  { "hArr",     (void*)8660 },
  { "harr",     (void*)8596 },
  { "hearts",   (void*)9829 },
  { "hellip",   (void*)8230 },
  { "iacute",   (void*)237 },
  { "icirc",    (void*)238 },
  { "iexcl",    (void*)161 },
  { "igrave",   (void*)236 },
  { "image",    (void*)8465 },
  { "infin",    (void*)8734 },
  { "int",      (void*)8747 },
  { "iota",     (void*)953 },
  { "iquest",   (void*)191 },
  { "isin",     (void*)8712 },
  { "iuml",     (void*)239 },
  { "kappa",    (void*)954 },
  { "lArr",     (void*)8656 },
  { "lambda",   (void*)955 },
  { "lang",     (void*)9001 },
  { "laquo",    (void*)171 },
  { "larr",     (void*)8592 },
  { "lceil",    (void*)8968 },
  { "ldquo",    (void*)8220 },
  { "le",       (void*)8804 },
  { "lfloor",   (void*)8970 },
  { "lowast",   (void*)8727 },
  { "loz",      (void*)9674 },
  { "lrm",      (void*)8206 },
  { "lsaquo",   (void*)8249 },
  { "lsquo",    (void*)8216 },
  { "lt",       (void*)60 },
  { "macr",     (void*)175 },
  { "mdash",    (void*)8212 },
  { "micro",    (void*)181 },
  { "middot",   (void*)183 },
  { "minus",    (void*)8722 },
  { "mu",       (void*)956 },
  { "nabla",    (void*)8711 },
  { "nbsp",     (void*)160 },
  { "ndash",    (void*)8211 },
  { "ne",       (void*)8800 },
  { "ni",       (void*)8715 },
  { "not",      (void*)172 },
  { "notin",    (void*)8713 },
  { "nsub",     (void*)8836 },
  { "ntilde",   (void*)241 },
  { "nu",       (void*)957 },
  { "oacute",   (void*)243 },
  { "ocirc",    (void*)244 },
  { "oelig",    (void*)339 },
  { "ograve",   (void*)242 },
  { "oline",    (void*)8254 },
  { "omega",    (void*)969 },
  { "omicron",  (void*)959 },
  { "oplus",    (void*)8853 },
  { "or",       (void*)8744 },
  { "ordf",     (void*)170 },
  { "ordm",     (void*)186 },
  { "oslash",   (void*)248 },
  { "otilde",   (void*)245 },
  { "otimes",   (void*)8855 },
  { "ouml",     (void*)246 },
  { "para",     (void*)182 },
  { "part",     (void*)8706 },
  { "permil",   (void*)8240 },
  { "perp",     (void*)8869 },
  { "phi",      (void*)966 },
  { "pi",       (void*)960 },
  { "piv",      (void*)982 },
  { "plusmn",   (void*)177 },
  { "pound",    (void*)163 },
  { "prime",    (void*)8242 },
  { "prod",     (void*)8719 },
  { "prop",     (void*)8733 },
  { "psi",      (void*)968 },
  { "quot",     (void*)34 },
  { "rArr",     (void*)8658 },
  { "radic",    (void*)8730 },
  { "rang",     (void*)9002 },
  { "raquo",    (void*)187 },
  { "rarr",     (void*)8594 },
  { "rceil",    (void*)8969 },
  { "rdquo",    (void*)8221 },
  { "real",     (void*)8476 },
  { "reg",      (void*)174 },
  { "rfloor",   (void*)8971 },
  { "rho",      (void*)961 },
  { "rlm",      (void*)8207 },
  { "rsaquo",   (void*)8250 },
  { "rsquo",    (void*)8217 },
  { "sbquo",    (void*)8218 },
  { "scaron",   (void*)353 },
  { "sdot",     (void*)8901 },
  { "sect",     (void*)167 },
  { "shy",      (void*)173 },
  { "sigma",    (void*)963 },
  { "sigmaf",   (void*)962 },
  { "sim",      (void*)8764 },
  { "spades",   (void*)9824 },
  { "sub",      (void*)8834 },
  { "sube",     (void*)8838 },
  { "sum",      (void*)8721 },
  { "sup",      (void*)8835 },
  { "sup1",     (void*)185 },
  { "sup2",     (void*)178 },
  { "sup3",     (void*)179 },
  { "supe",     (void*)8839 },
  { "szlig",    (void*)223 },
  { "tau",      (void*)964 },
  { "there4",   (void*)8756 },
  { "theta",    (void*)952 },
  { "thetasym", (void*)977 },
  { "thinsp",   (void*)8201 },
  { "thorn",    (void*)254 },
  { "tilde",    (void*)732 },
  { "times",    (void*)215 },
  { "trade",    (void*)8482 },
  { "uArr",     (void*)8657 },
  { "uacute",   (void*)250 },
  { "uarr",     (void*)8593 },
  { "ucirc",    (void*)251 },
  { "ugrave",   (void*)249 },
  { "uml",      (void*)168 },
  { "upsih",    (void*)978 },
  { "upsilon",  (void*)965 },
  { "uuml",     (void*)252 },
  { "weierp",   (void*)8472 },
  { "xi",       (void*)958 },
  { "yacute",   (void*)253 },
  { "yen",      (void*)165 },
  { "yuml",     (void*)255 },
  { "zeta",     (void*)950 },
  { "zwj",      (void*)8205 },
  { "zwnj",     (void*)8204 }
};

static const dictionary ent_dict = 
    { entities, sizeof (entities) / sizeof (dict_pair) };

unsigned int entity_to_unicode (const char *entity)
{
  if (entity == NULL)
      return 0;
 
  return (unsigned int) dict_lookup (&ent_dict, entity);
}

