/*
 *  entities.h - Conversion from character entity strings to unicode.
 *               This file is part of the FreeLCD package.
 *  
 *  $Id: entities.h,v 1.2 2004/06/20 12:35:35 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */

/** \file entities.h */

#ifndef _ENTITIES_H_
#define _ENTITIES_H_ 1

#if HAVE_CONFIG_H
# include "config.h"
#endif

/** Convert an entity string to unicode. For example, "amp" will translate
 * to 38, which is also the unicode value for the character '&'.
 * \param entity A character entity string, without the leading '&' and the
 *               trailing ';' characters.
 * \return The unicode value of the entity, or zero if the entity could
 *         not be translated.
 */
unsigned int 
entity_to_unicode (const char *entity);

#endif
