/*
 *  field_types.c : Dictionaries for translating a field type name to its
 *                  corresponding enumeration value.
 *                  This file is part of the FreeLCD package.
 *
 *  $Id: field_types.c,v 1.2 2004/06/20 12:36:55 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */

#include "field_types.h"
#include "dictionary.h"

static field_type field_types[] = 
{
  F_NONE, F_LABEL, F_TEXT, F_HEADER, F_TIME, F_TIMESPAN, F_DATE,
  F_SCALAR, F_PERCENTAGE, F_HISTOGRAM, F_PIXMAP
};

static dict_pair field_type_pairs[] =
{
    { "date",       field_types + 6  },
    { "header",     field_types + 3  },
    { "histogram",  field_types + 9  },
    { "label",      field_types + 1  },
    { "percentage", field_types + 8  },
    { "pixmap",     field_types + 10 },
    { "scalar",     field_types + 7  },
    { "text",       field_types + 2  },
    { "time",       field_types + 4  },
    { "timespan",   field_types + 5  }
};

dictionary field_type_dict = 
    { field_type_pairs, sizeof (field_type_pairs) / sizeof (dict_pair) };
