;
;  Time representation : 12-hour time with AM/PM indication
;

(define time-am-pm 
 (lambda (utctime localtime width height)

  (define expand
   (lambda (str)
    (if (< (string-length str) 2) (string-append "0" str) str)))

  (define convert
   (lambda (val div mod)
    (number->string (modulo (inexact->exact (floor (/ val div))) mod))
  ))

  (let* (
         (ampm (if (< localtime 43200) "am" "pm"))
         (dvd ":")
         (hrs (expand (convert localtime 3600 12)))
         (mns (expand (convert localtime 60 60)))
         (scs (expand (convert localtime 1 60)))
        )
   (if (string=? hrs "00") (set! hrs "12"))
   (cond 
    ((> width 10) (string-append hrs dvd mns dvd scs " " ampm))
    ((> width 7)  (string-append hrs dvd mns " " ampm))
    ((> width 6)  (string-append hrs dvd mns ampm))
))))

(flcd:time-format "am-pm" 
 '((11 1 0) (8 1 2) (7 1 3))
)
