;
;  Time representation : Internet beats
;

(define time-beats
 (lambda (utctime localtime width height)
  (define expand_l
   (lambda (str num)
    (cond
     ((< num 10)   (string-append "00" str))
     ((< num 100)  (string-append "0" str))
     ((< num 1000) str)
  )))

  (define expand_r
   (lambda (str)
    (if (< (string-length str) width) (expand_r (string-append str "0")) str))) 

  (define beats
   (/ (modulo (+ 90000 utctime) 86400) 86.4)
  )

  (substring 
   (expand_r (string-append "@" (expand_l (number->string beats) beats)))
   0 (min width 7))
))

(flcd:time-format "beats"
 '((7 1 0) (6 1 1) (4 1 2) (3 1 3) (2 1 5))
)
