/*
 *  connections.h - Manage connected sockets and the incoming data.
 *                  This file is part of the FreeLCD package.
 *
 *  $Id: connections.h,v 1.5 2004/06/20 13:02:09 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2002, 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */

#ifndef _FLCDD_CONNECTIONS_H
#define _FLCDD_CONNECTIONS_H 1

#include <glib.h>
#include <netinet/in.h>

gboolean conn_open (GIOChannel *source, GIOCondition condition, gpointer data);
gboolean conn_data (GIOChannel *source, GIOCondition condition, gpointer data); 
gboolean conn_close (GIOChannel *source, GIOCondition condition, gpointer data);
void conn_close_all ();
int conn_reply (void *originator, const char *data, size_t len);

#endif /* Multiple include guard */
