/*
 *  drivers.h - Loading and managing the driver plugins.
 *              This file is part of the FreeLCD package.
 *
 *  $Id: drivers.h,v 1.6 2004/06/20 14:14:09 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2002, 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */

#ifndef _DRIVERS_H
#define _DRIVERS_H 1

#include "renderers/charcanvas.h"
#include "common/xmlt.h"
#include "drivers/driver.h"

/* Initialize the driver management module. */
int 
drivers_init ();

/* Clean up all resources taken by the driver management module. */
void 
drivers_cleanup ();

/* Open a driver */
void* 
drivers_open_driver (xml_node * config);

/* Create an output path */
void*
drivers_create_output (xml_node *config);

void
drivers_process_canvas (void *info, cc_canvas *canvas);

drv_type
drivers_get_type (void *_info);

drv_dimensions
drivers_get_dimensions (void *_info);

#endif /* Multiple include guard */
