/*
 *  xmlconfig.c - Handle the XML configuration file.
 *                This file is part of the FreeLCD package.
 *  
 *  $Id: xmlconfig.c,v 1.6 2004/06/20 14:19:37 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2002, 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */


#include <stdio.h>

#include "xmlconfig.h"
#include "../common/dictionary.h"
#include "../common/backend.h"
#include "../drivers/driver.h"

static tag_idx tag_array[] = { ROOT, OUTPUT };
static attr_idx attr_array[] = { NAME };

static dict_pair tag_translate[] = {
  {"flcdd-config", &tag_array[0]},
  {"output", &tag_array[1]}
};

static dict_pair attr_translate[] = {
  {"name", &attr_array[0]}
};

static dictionary tag_dict = { tag_translate, 2 };
static dictionary attr_dict = { attr_translate, 1 };

static xml_node *finished_doc;


static void
_finished (void *ignore, xml_node *root_node)
{
  (void)ignore;

  finished_doc = root_node;
}

xml_node *
xc_parse_config_file (const char *filename)
{
  FILE *fp;
  char read_buf[4096];
  size_t read_len;
  void *context;

  finished_doc = NULL;

  /* Attempt to open the file */
  fp = fopen (filename, "r");
  if (!fp)
    return NULL;

  /* Create a context for parsing the file's content */
  context = xmlt_create_context (_finished, 0, &tag_dict, &attr_dict);
  if (!context)
    {
      fclose (fp);
      return NULL;
    }

  /* Parse the file block by block */
  while (!feof (fp) && !ferror (fp))
    {
      read_len = fread (read_buf, 1, 4096, fp);
      if (read_len > 0)
        xmlt_parse (context, read_buf, read_len);
    }

  xmlt_free_context (context);
  fclose (fp);

  return finished_doc;
}
