/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import java.awt.Color;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.base.JRBaseThermometerPlot;
import net.sf.jasperreports.charts.base.JRBaseValueDisplay;
import net.sf.jasperreports.charts.type.ValueLocationEnum;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;

public class JRDesignThermometerPlot
extends JRBaseThermometerPlot {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_DATA_RANGE = "dataRange";
    public static final String PROPERTY_HIGH_RANGE = "highRange";
    public static final String PROPERTY_LOW_RANGE = "lowRange";
    public static final String PROPERTY_MEDIUM_RANGE = "mediumRange";
    public static final String PROPERTY_MERCURY_COLOR = "mercuryColor";
    public static final String PROPERTY_SHOW_VALUE_LINES = "showValueLines";
    public static final String PROPERTY_VALUE_DISPLAY = "valueDisplay";
    public static final String PROPERTY_VALUE_LOCATION = "valueLocation";

    public JRDesignThermometerPlot(JRChartPlot thermoPlot, JRChart chart) {
        super(thermoPlot, chart);
    }

    public void setDataRange(JRDataRange dataRange) {
        JRDataRange old = this.dataRange;
        this.dataRange = dataRange;
        this.getEventSupport().firePropertyChange(PROPERTY_DATA_RANGE, old, this.dataRange);
    }

    public void setValueDisplay(JRValueDisplay valueDisplay) {
        JRValueDisplay old = this.valueDisplay;
        this.valueDisplay = new JRBaseValueDisplay(valueDisplay, this.getChart());
        this.getEventSupport().firePropertyChange(PROPERTY_VALUE_DISPLAY, old, this.valueDisplay);
    }

    public void setShowValueLines(boolean showValueLines) {
        boolean old = this.showValueLines;
        this.showValueLines = showValueLines;
        this.getEventSupport().firePropertyChange(PROPERTY_SHOW_VALUE_LINES, old, this.showValueLines);
    }

    public void setValueLocation(byte valueLocation) {
        this.setValueLocation(ValueLocationEnum.getByValue(valueLocation));
    }

    public void setValueLocation(Byte valueLocation) {
        this.setValueLocation(ValueLocationEnum.getByValue(valueLocation));
    }

    public void setValueLocation(ValueLocationEnum valueLocationObject) {
        ValueLocationEnum old = this.valueLocationObject;
        this.valueLocationObject = valueLocationObject;
        this.getEventSupport().firePropertyChange(PROPERTY_VALUE_LOCATION, old, this.valueLocationObject);
    }

    public void setMercuryColor(Color mercuryColor) {
        Color old = this.mercuryColor;
        this.mercuryColor = mercuryColor;
        this.getEventSupport().firePropertyChange(PROPERTY_MERCURY_COLOR, old, this.mercuryColor);
    }

    public void setLowRange(JRDataRange lowRange) {
        JRDataRange old = this.lowRange;
        this.lowRange = lowRange;
        this.getEventSupport().firePropertyChange(PROPERTY_LOW_RANGE, old, this.lowRange);
    }

    public void setMediumRange(JRDataRange mediumRange) {
        JRDataRange old = this.mediumRange;
        this.mediumRange = mediumRange;
        this.getEventSupport().firePropertyChange(PROPERTY_MEDIUM_RANGE, old, this.mediumRange);
    }

    public void setHighRange(JRDataRange highRange) {
        JRDataRange old = this.highRange;
        this.highRange = highRange;
        this.getEventSupport().firePropertyChange(PROPERTY_HIGH_RANGE, old, this.highRange);
    }
}

