/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.spiderchart;

import java.io.Serializable;
import net.sf.jasperreports.components.spiderchart.ChartSettings;
import net.sf.jasperreports.components.spiderchart.SpiderDataset;
import net.sf.jasperreports.components.spiderchart.SpiderPlot;
import net.sf.jasperreports.components.spiderchart.StandardChartSettings;
import net.sf.jasperreports.components.spiderchart.StandardSpiderDataset;
import net.sf.jasperreports.components.spiderchart.StandardSpiderPlot;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class SpiderChartComponent
implements Component,
JRChangeEventsSupport,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_CHART_SETTINGS = "chartSettings";
    public static final String PROPERTY_DATASET = "dataset";
    public static final String PROPERTY_PLOT = "plot";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    private EvaluationTimeEnum evaluationTime = EvaluationTimeEnum.NOW;
    private String evaluationGroup;
    private ChartSettings chartSettings;
    private SpiderDataset dataset;
    private SpiderPlot plot;
    private transient JRPropertyChangeSupport eventSupport;

    public SpiderChartComponent() {
    }

    protected SpiderChartComponent(SpiderChartComponent chartComponent, JRBaseObjectFactory baseFactory) {
        this.evaluationTime = chartComponent.getEvaluationTime();
        this.evaluationGroup = chartComponent.getEvaluationGroup();
        this.chartSettings = new StandardChartSettings(chartComponent.getChartSettings(), baseFactory);
        this.dataset = new StandardSpiderDataset(chartComponent.getDataset(), baseFactory);
        this.plot = new StandardSpiderPlot(chartComponent.getPlot(), baseFactory);
    }

    public ChartSettings getChartSettings() {
        return this.chartSettings;
    }

    public void setChartSettings(ChartSettings chartSettings) {
        ChartSettings old = this.chartSettings;
        this.chartSettings = chartSettings;
        this.getEventSupport().firePropertyChange(PROPERTY_CHART_SETTINGS, old, this.chartSettings);
    }

    public SpiderDataset getDataset() {
        return this.dataset;
    }

    public SpiderPlot getPlot() {
        return this.plot;
    }

    public void setDataset(SpiderDataset dataset) {
        SpiderDataset old = this.dataset;
        this.dataset = dataset;
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET, old, this.dataset);
    }

    public void setPlot(SpiderPlot plot) {
        SpiderPlot old = this.plot;
        this.plot = plot;
        this.getEventSupport().firePropertyChange(PROPERTY_PLOT, old, this.plot);
    }

    public EvaluationTimeEnum getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(EvaluationTimeEnum evaluationTime) {
        EvaluationTimeEnum old = this.evaluationTime;
        this.evaluationTime = evaluationTime;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTime);
    }

    public String getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(String evaluationGroup) {
        String old = this.evaluationGroup;
        this.evaluationGroup = evaluationGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, old, this.evaluationGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        SpiderChartComponent spiderChartComponent = this;
        synchronized (spiderChartComponent) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

