/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill.calculation;

import java.util.Comparator;
import net.sf.jasperreports.crosstabs.fill.calculation.ArbitraryRankComparator;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BucketDefinition {
    private static final Log log = LogFactory.getLog(BucketDefinition.class);
    public static final byte ORDER_ASCENDING = 1;
    public static final byte ORDER_DESCENDING = 2;
    public static final byte TOTAL_POSITION_NONE = 0;
    public static final byte TOTAL_POSITION_START = 1;
    public static final byte TOTAL_POSITION_END = 2;
    protected static final byte VALUE_TYPE_VALUE = 0;
    protected static final byte VALUE_TYPE_NULL = 1;
    protected static final byte VALUE_TYPE_TOTAL = 2;
    protected final Bucket VALUE_TOTAL = new Bucket(2);
    protected final Bucket VALUE_NULL = new Bucket(1);
    protected final Comparator bucketValueComparator;
    protected final JRExpression orderByExpression;
    protected final Comparator orderValueComparator;
    private final CrosstabTotalPositionEnum totalPosition;
    private boolean computeTotal;

    public BucketDefinition(Class valueClass, JRExpression orderByExpression, Comparator comparator, SortOrderEnum order, CrosstabTotalPositionEnum totalPosition) throws JRException {
        if (comparator == null && orderByExpression == null && !Comparable.class.isAssignableFrom(valueClass)) {
            throw new JRException("The bucket expression values are not comparable and no comparator specified.");
        }
        this.orderByExpression = orderByExpression;
        if (orderByExpression == null) {
            this.bucketValueComparator = BucketDefinition.createOrderComparator(comparator, order);
            this.orderValueComparator = null;
        } else {
            if (Comparable.class.isAssignableFrom(valueClass)) {
                this.bucketValueComparator = ComparableComparator.getInstance();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Using arbitrary rank comparator for bucket");
                }
                this.bucketValueComparator = new ArbitraryRankComparator();
            }
            this.orderValueComparator = BucketDefinition.createOrderComparator(comparator, order);
        }
        this.totalPosition = totalPosition;
        this.computeTotal = totalPosition != CrosstabTotalPositionEnum.NONE;
    }

    protected static Comparator createOrderComparator(Comparator comparator, SortOrderEnum order) {
        Object orderComparator;
        switch (order) {
            case DESCENDING: {
                if (comparator == null) {
                    orderComparator = new ReverseComparator();
                    break;
                }
                orderComparator = new ReverseComparator(comparator);
                break;
            }
            default: {
                orderComparator = comparator == null ? ComparableComparator.getInstance() : comparator;
            }
        }
        return orderComparator;
    }

    public boolean computeTotal() {
        return this.computeTotal;
    }

    public void setComputeTotal() {
        this.computeTotal = true;
    }

    public CrosstabTotalPositionEnum getTotalPosition() {
        return this.totalPosition;
    }

    public JRExpression getOrderByExpression() {
        return this.orderByExpression;
    }

    public boolean hasOrderValues() {
        return this.orderByExpression != null;
    }

    public int compareOrderValues(Object v1, Object v2) {
        return this.orderValueComparator.compare(v1, v2);
    }

    public Bucket create(Object value) {
        if (value == null) {
            return this.VALUE_NULL;
        }
        return new Bucket(value);
    }

    public class Bucket
    implements Comparable {
        private final Object value;
        private final byte type;

        protected Bucket(byte type) {
            this.value = null;
            this.type = type;
        }

        protected Bucket(Object value) {
            this.value = value;
            this.type = 0;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Bucket)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Bucket v = (Bucket)o;
            if (this.type != 0) {
                return this.type == v.type;
            }
            return v.type == 0 && this.value.equals(v.value);
        }

        public int hashCode() {
            int hash = this.type;
            if (this.type == 0) {
                hash = 37 * hash + this.value.hashCode();
            }
            return hash;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "NULL";
                }
                case 2: {
                    return "TOTAL";
                }
            }
            return String.valueOf(this.value);
        }

        public int compareTo(Object o) {
            Bucket val = (Bucket)o;
            if (this.type != val.type) {
                return this.type - val.type;
            }
            if (this.type != 0) {
                return 0;
            }
            return BucketDefinition.this.bucketValueComparator.compare(this.value, val.value);
        }

        public boolean isTotal() {
            return this.type == 2;
        }
    }
}

