/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRShortIncrementerFactory;

final class JRShortVarianceIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRShortVarianceIncrementer mainInstance = new JRShortVarianceIncrementer();

    private JRShortVarianceIncrementer() {
    }

    public static JRShortVarianceIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        Number newValue = (Number)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            return JRShortIncrementerFactory.ZERO;
        }
        Number countValue = (Number)valueProvider.getValue(variable.getHelperVariable((byte)0));
        Number sumValue = (Number)valueProvider.getValue(variable.getHelperVariable((byte)1));
        return new Short((short)((countValue.shortValue() - 1) * value.shortValue() / countValue.shortValue() + (sumValue.shortValue() / countValue.shortValue() - newValue.shortValue()) * (sumValue.shortValue() / countValue.shortValue() - newValue.shortValue()) / (countValue.shortValue() - 1)));
    }

    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) {
        Number value = (Number)calculable.getIncrementedValue();
        if (calculableValue.getValue() == null) {
            if (calculable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || calculable.isInitialized()) {
            return new Short(((Number)calculableValue.getIncrementedValue()).shortValue());
        }
        float v1 = value.floatValue();
        float c1 = ((Number)valueProvider.getValue(calculable.getHelperVariable((byte)0))).floatValue();
        float s1 = ((Number)valueProvider.getValue(calculable.getHelperVariable((byte)1))).floatValue();
        float v2 = ((Number)calculableValue.getIncrementedValue()).floatValue();
        float c2 = ((Number)valueProvider.getValue(calculableValue.getHelperVariable((byte)0))).floatValue();
        float s2 = ((Number)valueProvider.getValue(calculableValue.getHelperVariable((byte)1))).floatValue();
        float c = (c1 -= c2) + c2;
        return new Short((short)(c1 / c * v1 + c2 / c * v2 + c2 / c1 * (s1 -= s2) / c * s1 / c + c1 / c2 * s2 / c * s2 / c - 2.0f * s1 / c * s2 / c));
    }

    public Object initialValue() {
        return JRShortIncrementerFactory.ZERO;
    }
}

