/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.ooxml.GenericElementPptxHandler;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporterContext;
import net.sf.jasperreports.engine.export.ooxml.PptxContentTypesHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxPresentationHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxPresentationRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxRunHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxSlideHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxSlideRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxZip;
import net.sf.jasperreports.engine.export.ooxml.Utility;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZipEntry;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRPptxExporter
extends JRAbstractExporter {
    private static final Log log = LogFactory.getLog(JRPptxExporter.class);
    public static final String PPTX_EXPORTER_KEY = "net.sf.jasperreports.pptx";
    protected static final String PPTX_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.pptx.";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected PptxZip pptxZip;
    protected PptxPresentationHelper presentationHelper;
    protected PptxPresentationRelsHelper presentationRelsHelper;
    protected PptxContentTypesHelper ctHelper;
    protected PptxSlideHelper slideHelper;
    protected PptxSlideRelsHelper slideRelsHelper;
    protected Writer presentationWriter;
    protected JRExportProgressMonitor progressMonitor;
    protected Map rendererToImagePathMap;
    protected Map imageMaps;
    protected List imagesToProcess;
    protected int reportIndex;
    protected int pageIndex;
    protected List frameIndexStack;
    protected int elementIndex;
    protected boolean startPage;
    protected int slideIndex;
    protected Map fontMap;
    private PptxRunHelper runHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block21: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(this.getExporterPropertiesPrefix());
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.rendererToImagePathMap = new HashMap();
                this.imageMaps = new HashMap();
                this.imagesToProcess = new ArrayList();
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.setHyperlinkProducerFactory();
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.exportReportToStream(os);
                        break block21;
                    }
                    catch (IOException e) {
                        throw new JRException("Error trying to export to output stream : " + this.jasperPrint.getName(), e);
                    }
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.exportReportToStream(os);
                }
                catch (IOException e) {
                    throw new JRException("Error trying to export to file : " + destFile, e);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    public static JRPrintImage getImage(List jasperPrintList, String imageName) {
        return JRPptxExporter.getImage(jasperPrintList, JRPptxExporter.getPrintElementIndex(imageName));
    }

    public static JRPrintImage getImage(List jasperPrintList, JRPrintElementIndex imageIndex) {
        JasperPrint report = (JasperPrint)jasperPrintList.get(imageIndex.getReportIndex());
        JRPrintPage page = (JRPrintPage)report.getPages().get(imageIndex.getPageIndex());
        Integer[] elementIndexes = imageIndex.getAddressArray();
        Object element = page.getElements().get(elementIndexes[0]);
        for (int i = 1; i < elementIndexes.length; ++i) {
            JRPrintFrame frame = (JRPrintFrame)element;
            element = frame.getElements().get(elementIndexes[i]);
        }
        return (JRPrintImage)element;
    }

    protected void exportReportToStream(OutputStream os) throws JRException, IOException {
        this.pptxZip = new PptxZip();
        this.presentationWriter = this.pptxZip.getPresentationEntry().getWriter();
        this.presentationHelper = new PptxPresentationHelper(this.presentationWriter);
        this.presentationHelper.exportHeader();
        this.presentationRelsHelper = new PptxPresentationRelsHelper(this.pptxZip.getRelsEntry().getWriter());
        this.presentationRelsHelper.exportHeader();
        this.ctHelper = new PptxContentTypesHelper(this.pptxZip.getContentTypesEntry().getWriter());
        this.ctHelper.exportHeader();
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.setJasperPrint((JasperPrint)this.jasperPrintList.get(this.reportIndex));
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                JRPrintPage page = null;
                this.pageIndex = this.startPageIndex;
                while (this.pageIndex <= this.endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    page = (JRPrintPage)pages.get(this.pageIndex);
                    this.createSlide(null);
                    ++this.slideIndex;
                    this.exportPage(page);
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        this.closeSlide();
        this.presentationHelper.exportFooter(this.jasperPrint);
        this.presentationHelper.close();
        if (this.imagesToProcess != null && this.imagesToProcess.size() > 0) {
            for (JRPrintElementIndex imageIndex : this.imagesToProcess) {
                String mimeType;
                JRPrintImage image = JRPptxExporter.getImage(this.jasperPrintList, imageIndex);
                JRRenderable renderer = image.getRenderer();
                if (renderer.getType() == 1) {
                    renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
                }
                if ((mimeType = JRTypeSniffer.getImageMimeType(renderer.getImageType())) == null) {
                    mimeType = "image/jpeg";
                }
                String extension = mimeType.substring(mimeType.lastIndexOf(47) + 1);
                String imageName = IMAGE_NAME_PREFIX + imageIndex.toString() + "." + extension;
                this.pptxZip.addEntry(new FileBufferedZipEntry("ppt/media/" + imageName, renderer.getImageData()));
            }
        }
        this.presentationRelsHelper.exportFooter();
        this.presentationRelsHelper.close();
        this.ctHelper.exportFooter();
        this.ctHelper.close();
        this.pptxZip.zipEntries(os);
        this.pptxZip.dispose();
    }

    protected void exportPage(JRPrintPage page) throws JRException {
        this.frameIndexStack = new ArrayList();
        this.exportElements(page.getElements());
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void createSlide(String name) {
        this.closeSlide();
        this.presentationHelper.exportSlide(this.slideIndex + 1);
        this.ctHelper.exportSlide(this.slideIndex + 1);
        this.presentationRelsHelper.exportSlide(this.slideIndex + 1);
        ExportZipEntry slideRelsEntry = this.pptxZip.addSlideRels(this.slideIndex + 1);
        Writer slideRelsWriter = slideRelsEntry.getWriter();
        this.slideRelsHelper = new PptxSlideRelsHelper(slideRelsWriter);
        ExportZipEntry slideEntry = this.pptxZip.addSlide(this.slideIndex + 1);
        Writer slideWriter = slideEntry.getWriter();
        this.slideHelper = new PptxSlideHelper(slideWriter, this.slideRelsHelper);
        this.runHelper = new PptxRunHelper(slideWriter, this.fontMap, null);
        this.slideHelper.exportHeader();
        this.slideRelsHelper.exportHeader();
    }

    protected void closeSlide() {
        if (this.slideHelper != null) {
            this.slideHelper.exportFooter();
            this.slideHelper.close();
            this.slideRelsHelper.exportFooter();
            this.slideRelsHelper.close();
        }
    }

    protected void exportElements(List elements) throws JRException {
        if (elements != null && elements.size() > 0) {
            for (int i = 0; i < elements.size(); ++i) {
                this.elementIndex = i;
                JRPrintElement element = (JRPrintElement)elements.get(i);
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (element instanceof JRPrintText) {
                    this.exportText((JRPrintText)element);
                    continue;
                }
                if (element instanceof JRPrintFrame) {
                    this.exportFrame((JRPrintFrame)element);
                    continue;
                }
                if (!(element instanceof JRGenericPrintElement)) continue;
                this.exportGenericElement((JRGenericPrintElement)element);
            }
        }
    }

    protected void exportLine(JRPrintLine line) {
        int x = line.getX() + this.getOffsetX();
        int y = line.getY() + this.getOffsetY();
        int height = line.getHeight();
        int width = line.getWidth();
        if (width <= 1 || height <= 1) {
            if (width > 1) {
                height = 0;
            } else {
                width = 0;
            }
        }
        this.slideHelper.write("<p:sp>\n");
        this.slideHelper.write("  <p:nvSpPr>\n");
        this.slideHelper.write("    <p:cNvPr id=\"" + line.hashCode() + "\" name=\"Line\"/>\n");
        this.slideHelper.write("    <p:cNvSpPr>\n");
        this.slideHelper.write("      <a:spLocks noGrp=\"1\"/>\n");
        this.slideHelper.write("    </p:cNvSpPr>\n");
        this.slideHelper.write("    <p:nvPr/>\n");
        this.slideHelper.write("  </p:nvSpPr>\n");
        this.slideHelper.write("  <p:spPr>\n");
        this.slideHelper.write("    <a:xfrm" + (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? " flipV=\"1\"" : "") + ">\n");
        this.slideHelper.write("      <a:off x=\"" + Utility.emu(x) + "\" y=\"" + Utility.emu(y) + "\"/>\n");
        this.slideHelper.write("      <a:ext cx=\"" + Utility.emu(width) + "\" cy=\"" + Utility.emu(height) + "\"/>\n");
        this.slideHelper.write("    </a:xfrm><a:prstGeom prst=\"line\"><a:avLst/></a:prstGeom>\n");
        if (line.getModeValue() == ModeEnum.OPAQUE && line.getBackcolor() != null) {
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(line.getBackcolor()) + "\"/></a:solidFill>\n");
        }
        if (line.getLinePen().getLineWidth().floatValue() > 0.0f) {
            this.slideHelper.write("  <a:ln w=\"" + Utility.emu(line.getLinePen().getLineWidth().floatValue()) + "\">\n");
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(line.getLinePen().getLineColor()) + "\"/></a:solidFill>\n");
            this.slideHelper.write("<a:prstDash val=\"");
            switch (line.getLinePen().getLineStyleValue()) {
                case DASHED: {
                    this.slideHelper.write("dash");
                    break;
                }
                case DOTTED: {
                    this.slideHelper.write("dot");
                    break;
                }
                default: {
                    this.slideHelper.write("solid");
                }
            }
            this.slideHelper.write("\"/>\n");
            this.slideHelper.write("  </a:ln>\n");
        }
        this.slideHelper.write("  </p:spPr>\n");
        this.slideHelper.write("  <p:txBody>\n");
        this.slideHelper.write("    <a:bodyPr rtlCol=\"0\" anchor=\"ctr\"/>\n");
        this.slideHelper.write("    <a:lstStyle/>\n");
        this.slideHelper.write("    <a:p>\n");
        this.slideHelper.write("<a:pPr algn=\"ctr\"/>\n");
        this.slideHelper.write("    </a:p>\n");
        this.slideHelper.write("  </p:txBody>\n");
        this.slideHelper.write("</p:sp>\n");
    }

    protected void exportRectangle(JRPrintRectangle rectangle) {
        this.slideHelper.write("<p:sp>\n");
        this.slideHelper.write("  <p:nvSpPr>\n");
        this.slideHelper.write("    <p:cNvPr id=\"" + rectangle.hashCode() + "\" name=\"Rectangle\"/>\n");
        this.slideHelper.write("    <p:cNvSpPr>\n");
        this.slideHelper.write("      <a:spLocks noGrp=\"1\"/>\n");
        this.slideHelper.write("    </p:cNvSpPr>\n");
        this.slideHelper.write("    <p:nvPr/>\n");
        this.slideHelper.write("  </p:nvSpPr>\n");
        this.slideHelper.write("  <p:spPr>\n");
        this.slideHelper.write("    <a:xfrm>\n");
        this.slideHelper.write("      <a:off x=\"" + Utility.emu(rectangle.getX() + this.getOffsetX()) + "\" y=\"" + Utility.emu(rectangle.getY() + this.getOffsetY()) + "\"/>\n");
        this.slideHelper.write("      <a:ext cx=\"" + Utility.emu(rectangle.getWidth()) + "\" cy=\"" + Utility.emu(rectangle.getHeight()) + "\"/>\n");
        this.slideHelper.write("    </a:xfrm><a:prstGeom prst=\"" + (rectangle.getRadius() == 0 ? "rect" : "roundRect") + "\"><a:avLst/></a:prstGeom>\n");
        if (rectangle.getModeValue() == ModeEnum.OPAQUE && rectangle.getBackcolor() != null) {
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(rectangle.getBackcolor()) + "\"/></a:solidFill>\n");
        }
        if (rectangle.getLinePen().getLineWidth().floatValue() > 0.0f) {
            this.slideHelper.write("  <a:ln w=\"" + Utility.emu(rectangle.getLinePen().getLineWidth().floatValue()) + "\">\n");
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(rectangle.getLinePen().getLineColor()) + "\"/></a:solidFill>\n");
            this.slideHelper.write("<a:prstDash val=\"");
            switch (rectangle.getLinePen().getLineStyleValue()) {
                case DASHED: {
                    this.slideHelper.write("dash");
                    break;
                }
                case DOTTED: {
                    this.slideHelper.write("dot");
                    break;
                }
                default: {
                    this.slideHelper.write("solid");
                }
            }
            this.slideHelper.write("\"/>\n");
            this.slideHelper.write("  </a:ln>\n");
        }
        this.slideHelper.write("  </p:spPr>\n");
        this.slideHelper.write("  <p:txBody>\n");
        this.slideHelper.write("    <a:bodyPr rtlCol=\"0\" anchor=\"ctr\"/>\n");
        this.slideHelper.write("    <a:lstStyle/>\n");
        this.slideHelper.write("    <a:p>\n");
        this.slideHelper.write("<a:pPr algn=\"ctr\"/>\n");
        this.slideHelper.write("    </a:p>\n");
        this.slideHelper.write("  </p:txBody>\n");
        this.slideHelper.write("</p:sp>\n");
    }

    protected void exportEllipse(JRPrintEllipse ellipse) {
        this.slideHelper.write("<p:sp>\n");
        this.slideHelper.write("  <p:nvSpPr>\n");
        this.slideHelper.write("    <p:cNvPr id=\"" + ellipse.hashCode() + "\" name=\"Ellipse\"/>\n");
        this.slideHelper.write("    <p:cNvSpPr>\n");
        this.slideHelper.write("      <a:spLocks noGrp=\"1\"/>\n");
        this.slideHelper.write("    </p:cNvSpPr>\n");
        this.slideHelper.write("    <p:nvPr/>\n");
        this.slideHelper.write("  </p:nvSpPr>\n");
        this.slideHelper.write("  <p:spPr>\n");
        this.slideHelper.write("    <a:xfrm>\n");
        this.slideHelper.write("      <a:off x=\"" + Utility.emu(ellipse.getX() + this.getOffsetX()) + "\" y=\"" + Utility.emu(ellipse.getY() + this.getOffsetY()) + "\"/>\n");
        this.slideHelper.write("      <a:ext cx=\"" + Utility.emu(ellipse.getWidth()) + "\" cy=\"" + Utility.emu(ellipse.getHeight()) + "\"/>\n");
        this.slideHelper.write("    </a:xfrm><a:prstGeom prst=\"ellipse\"><a:avLst/></a:prstGeom>\n");
        if (ellipse.getModeValue() == ModeEnum.OPAQUE && ellipse.getBackcolor() != null) {
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(ellipse.getBackcolor()) + "\"/></a:solidFill>\n");
        }
        if (ellipse.getLinePen().getLineWidth().floatValue() > 0.0f) {
            this.slideHelper.write("  <a:ln w=\"" + Utility.emu(ellipse.getLinePen().getLineWidth().floatValue()) + "\">\n");
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(ellipse.getLinePen().getLineColor()) + "\"/></a:solidFill>\n");
            this.slideHelper.write("<a:prstDash val=\"");
            switch (ellipse.getLinePen().getLineStyleValue()) {
                case DASHED: {
                    this.slideHelper.write("dash");
                    break;
                }
                case DOTTED: {
                    this.slideHelper.write("dot");
                    break;
                }
                default: {
                    this.slideHelper.write("solid");
                }
            }
            this.slideHelper.write("\"/>\n");
            this.slideHelper.write("  </a:ln>\n");
        }
        this.slideHelper.write("  </p:spPr>\n");
        this.slideHelper.write("  <p:txBody>\n");
        this.slideHelper.write("    <a:bodyPr rtlCol=\"0\" anchor=\"ctr\"/>\n");
        this.slideHelper.write("    <a:lstStyle/>\n");
        this.slideHelper.write("    <a:p>\n");
        this.slideHelper.write("<a:pPr algn=\"ctr\"/>\n");
        this.slideHelper.write("    </a:p>\n");
        this.slideHelper.write("  </p:txBody>\n");
        this.slideHelper.write("</p:sp>\n");
    }

    public void exportText(JRPrintText text) {
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        int rotation = 0;
        int leftPadding = text.getLineBox().getLeftPadding();
        int topPadding = text.getLineBox().getTopPadding();
        int rightPadding = text.getLineBox().getRightPadding();
        int bottomPadding = text.getLineBox().getBottomPadding();
        switch (text.getRotationValue()) {
            case LEFT: {
                rotation = -5400000;
                x = text.getX() + this.getOffsetX() - (text.getHeight() - text.getWidth()) / 2;
                y = text.getY() + this.getOffsetY() + (text.getHeight() - text.getWidth()) / 2;
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = leftPadding;
                leftPadding = bottomPadding;
                bottomPadding = rightPadding;
                rightPadding = tmpPadding;
                break;
            }
            case RIGHT: {
                rotation = 5400000;
                x = text.getX() + this.getOffsetX() - (text.getHeight() - text.getWidth()) / 2;
                y = text.getY() + this.getOffsetY() + (text.getHeight() - text.getWidth()) / 2;
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = rightPadding;
                rightPadding = bottomPadding;
                bottomPadding = leftPadding;
                leftPadding = tmpPadding;
                break;
            }
            case UPSIDE_DOWN: {
                rotation = 10800000;
                x = text.getX() + this.getOffsetX();
                y = text.getY() + this.getOffsetY();
                width = text.getWidth();
                height = text.getHeight();
                int tmpPadding = topPadding;
                topPadding = bottomPadding;
                bottomPadding = tmpPadding;
                tmpPadding = leftPadding;
                leftPadding = rightPadding;
                rightPadding = tmpPadding;
                break;
            }
            default: {
                rotation = 0;
                x = text.getX() + this.getOffsetX();
                y = text.getY() + this.getOffsetY();
                width = text.getWidth();
                height = text.getHeight();
            }
        }
        this.slideHelper.write("<p:sp>\n");
        this.slideHelper.write("  <p:nvSpPr>\n");
        this.slideHelper.write("    <p:cNvPr id=\"" + text.hashCode() + "\" name=\"Text\">\n");
        String href = this.getHyperlinkURL(text);
        if (href != null) {
            this.slideHelper.exportHyperlink(href);
        }
        this.slideHelper.write("    </p:cNvPr>\n");
        this.slideHelper.write("    <p:cNvSpPr>\n");
        this.slideHelper.write("      <a:spLocks noGrp=\"1\"/>\n");
        this.slideHelper.write("    </p:cNvSpPr>\n");
        this.slideHelper.write("    <p:nvPr/>\n");
        this.slideHelper.write("  </p:nvSpPr>\n");
        this.slideHelper.write("  <p:spPr>\n");
        this.slideHelper.write("    <a:xfrm rot=\"" + rotation + "\">\n");
        this.slideHelper.write("      <a:off x=\"" + Utility.emu(x) + "\" y=\"" + Utility.emu(y) + "\"/>\n");
        this.slideHelper.write("      <a:ext cx=\"" + Utility.emu(width) + "\" cy=\"" + Utility.emu(height) + "\"/>\n");
        this.slideHelper.write("    </a:xfrm><a:prstGeom prst=\"rect\"><a:avLst/></a:prstGeom>\n");
        if (text.getModeValue() == ModeEnum.OPAQUE && text.getBackcolor() != null) {
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(text.getBackcolor()) + "\"/></a:solidFill>\n");
        }
        if (text.getLineBox().getPen().getLineWidth().floatValue() > 0.0f) {
            this.slideHelper.write("  <a:ln w=\"" + Utility.emu(text.getLineBox().getPen().getLineWidth().floatValue()) + "\">\n");
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(text.getLineBox().getPen().getLineColor()) + "\"/></a:solidFill>\n");
            this.slideHelper.write("<a:prstDash val=\"");
            switch (text.getLineBox().getPen().getLineStyleValue()) {
                case DASHED: {
                    this.slideHelper.write("dash");
                    break;
                }
                case DOTTED: {
                    this.slideHelper.write("dot");
                    break;
                }
                default: {
                    this.slideHelper.write("solid");
                }
            }
            this.slideHelper.write("\"/>\n");
            this.slideHelper.write("  </a:ln>\n");
        }
        this.slideHelper.write("  </p:spPr>\n");
        this.slideHelper.write("  <p:txBody>\n");
        this.slideHelper.write("    <a:bodyPr wrap=\"square\" lIns=\"" + Utility.emu(leftPadding) + "\" tIns=\"" + Utility.emu(topPadding) + "\" rIns=\"" + Utility.emu(rightPadding) + "\" bIns=\"" + Utility.emu(bottomPadding) + "\" rtlCol=\"0\" anchor=\"");
        switch (text.getVerticalAlignmentValue()) {
            case TOP: {
                this.slideHelper.write("t");
                break;
            }
            case MIDDLE: {
                this.slideHelper.write("ctr");
                break;
            }
            case BOTTOM: {
                this.slideHelper.write("b");
                break;
            }
            default: {
                this.slideHelper.write("t");
            }
        }
        this.slideHelper.write("\"/>\n");
        this.slideHelper.write("    <a:lstStyle/>\n");
        this.slideHelper.write("    <a:p>\n");
        this.slideHelper.write("<a:pPr");
        this.slideHelper.write(" algn=\"");
        switch (text.getHorizontalAlignmentValue()) {
            case LEFT: {
                this.slideHelper.write("l");
                break;
            }
            case CENTER: {
                this.slideHelper.write("ctr");
                break;
            }
            case RIGHT: {
                this.slideHelper.write("r");
                break;
            }
            case JUSTIFIED: {
                this.slideHelper.write("just");
                break;
            }
            default: {
                this.slideHelper.write("l");
            }
        }
        this.slideHelper.write("\">\n");
        this.slideHelper.write("<a:lnSpc><a:spcPct");
        this.slideHelper.write(" val=\"");
        switch (text.getLineSpacingValue()) {
            case DOUBLE: {
                this.slideHelper.write("200");
                break;
            }
            case ONE_AND_HALF: {
                this.slideHelper.write("150");
                break;
            }
            default: {
                this.slideHelper.write("100");
            }
        }
        this.slideHelper.write("%\"/></a:lnSpc>\n");
        this.runHelper.exportProps(text, this.getTextLocale(text));
        this.slideHelper.write("</a:pPr>\n");
        if (textLength > 0) {
            this.exportStyledText(text.getStyle(), styledText, this.getTextLocale(text));
        }
        this.slideHelper.write("    </a:p>\n");
        this.slideHelper.write("  </p:txBody>\n");
        this.slideHelper.write("</p:sp>\n");
    }

    protected void exportStyledText(JRStyle style, JRStyledText styledText, Locale locale) {
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            this.runHelper.export(style, iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit), locale);
            iterator.setIndex(runLimit);
        }
    }

    protected void exportImage(JRPrintImage image) throws JRException {
        int leftPadding = image.getLineBox().getLeftPadding();
        int topPadding = image.getLineBox().getTopPadding();
        int rightPadding = image.getLineBox().getRightPadding();
        int bottomPadding = image.getLineBox().getBottomPadding();
        int availableImageWidth = image.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = image.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        JRRenderable renderer = image.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getType() == 0) {
                renderer = JRImageRenderer.getOnErrorRendererForImageData(renderer, image.getOnErrorTypeValue());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            Dimension2D dimension;
            int width = availableImageWidth;
            int height = availableImageHeight;
            double normalWidth = availableImageWidth;
            double normalHeight = availableImageHeight;
            JRRenderable tmpRenderer = JRImageRenderer.getOnErrorRendererForDimension(renderer, image.getOnErrorTypeValue());
            Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension();
            if (tmpRenderer == renderer && dimension != null) {
                normalWidth = dimension.getWidth();
                normalHeight = dimension.getHeight();
            }
            double cropTop = 0.0;
            double cropLeft = 0.0;
            double cropBottom = 0.0;
            double cropRight = 0.0;
            block0 : switch (image.getScaleImageValue()) {
                case FILL_FRAME: {
                    width = availableImageWidth;
                    height = availableImageHeight;
                    break;
                }
                case CLIP: {
                    switch (image.getHorizontalAlignmentValue()) {
                        case RIGHT: {
                            cropLeft = 100000.0 * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                            cropRight = 0.0;
                            break;
                        }
                        case CENTER: {
                            cropRight = cropLeft = 100000.0 * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth / 2.0;
                            break;
                        }
                        default: {
                            cropLeft = 0.0;
                            cropRight = 100000.0 * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                        }
                    }
                    switch (image.getVerticalAlignmentValue()) {
                        case TOP: {
                            cropTop = 0.0;
                            cropBottom = 100000.0 * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                            break block0;
                        }
                        case MIDDLE: {
                            cropBottom = cropTop = 100000.0 * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight / 2.0;
                            break block0;
                        }
                    }
                    cropTop = 100000.0 * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                    cropBottom = 0.0;
                    break;
                }
                default: {
                    if (availableImageHeight <= 0) break;
                    double ratio = normalWidth / normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        width = availableImageWidth;
                        height = (int)((double)width / ratio);
                        switch (image.getVerticalAlignmentValue()) {
                            case TOP: {
                                cropTop = 0.0;
                                cropBottom = 100000 * (availableImageHeight - height) / availableImageHeight;
                                break block0;
                            }
                            case MIDDLE: {
                                cropBottom = cropTop = (double)(100000 * (availableImageHeight - height) / availableImageHeight / 2);
                                break block0;
                            }
                        }
                        cropTop = 100000 * (availableImageHeight - height) / availableImageHeight;
                        cropBottom = 0.0;
                        break;
                    }
                    height = availableImageHeight;
                    width = (int)(ratio * (double)height);
                    switch (image.getHorizontalAlignmentValue()) {
                        case RIGHT: {
                            cropLeft = 100000 * (availableImageWidth - width) / availableImageWidth;
                            cropRight = 0.0;
                            break block0;
                        }
                        case CENTER: {
                            cropRight = cropLeft = (double)(100000 * (availableImageWidth - width) / availableImageWidth / 2);
                            break block0;
                        }
                    }
                    cropLeft = 0.0;
                    cropRight = 100000 * (availableImageWidth - width) / availableImageWidth;
                }
            }
            String imageName = this.getImagePath(renderer, image.isLazy());
            this.slideRelsHelper.exportImage(imageName);
            this.slideHelper.write("<p:pic>\n");
            this.slideHelper.write("  <p:nvPicPr>\n");
            this.slideHelper.write("    <p:cNvPr id=\"" + (image.hashCode() > 0 ? image.hashCode() : -image.hashCode()) + "\" name=\"Picture\">\n");
            String href = this.getHyperlinkURL(image);
            if (href != null) {
                this.slideHelper.exportHyperlink(href);
            }
            this.slideHelper.write("    </p:cNvPr>\n");
            this.slideHelper.write("    <p:cNvPicPr>\n");
            this.slideHelper.write("      <a:picLocks noChangeAspect=\"1\"/>\n");
            this.slideHelper.write("    </p:cNvPicPr>\n");
            this.slideHelper.write("    <p:nvPr/>\n");
            this.slideHelper.write("  </p:nvPicPr>\n");
            this.slideHelper.write("<p:blipFill>\n");
            this.slideHelper.write("<a:blip r:embed=\"" + imageName + "\"/>");
            this.slideHelper.write("<a:srcRect");
            this.slideHelper.write("/>");
            this.slideHelper.write("<a:stretch><a:fillRect");
            this.slideHelper.write(" l=\"" + (int)cropLeft + "\"");
            this.slideHelper.write(" t=\"" + (int)cropTop + "\"");
            this.slideHelper.write(" r=\"" + (int)cropRight + "\"");
            this.slideHelper.write(" b=\"" + (int)cropBottom + "\"");
            this.slideHelper.write("/></a:stretch>\n");
            this.slideHelper.write("</p:blipFill>\n");
            this.slideHelper.write("  <p:spPr>\n");
            this.slideHelper.write("    <a:xfrm>\n");
            this.slideHelper.write("      <a:off x=\"" + Utility.emu(image.getX() + this.getOffsetX()) + "\" y=\"" + Utility.emu(image.getY() + this.getOffsetY()) + "\"/>\n");
            this.slideHelper.write("      <a:ext cx=\"" + Utility.emu(image.getWidth()) + "\" cy=\"" + Utility.emu(image.getHeight()) + "\"/>\n");
            this.slideHelper.write("    </a:xfrm><a:prstGeom prst=\"rect\"><a:avLst/></a:prstGeom>\n");
            if (image.getModeValue() == ModeEnum.OPAQUE && image.getBackcolor() != null) {
                this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(image.getBackcolor()) + "\"/></a:solidFill>\n");
            }
            if (image.getLineBox().getPen().getLineWidth().floatValue() > 0.0f) {
                this.slideHelper.write("  <a:ln w=\"" + Utility.emu(image.getLineBox().getPen().getLineWidth().floatValue()) + "\">\n");
                this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(image.getLineBox().getPen().getLineColor()) + "\"/></a:solidFill>\n");
                this.slideHelper.write("<a:prstDash val=\"");
                switch (image.getLineBox().getPen().getLineStyleValue()) {
                    case DASHED: {
                        this.slideHelper.write("dash");
                        break;
                    }
                    case DOTTED: {
                        this.slideHelper.write("dot");
                        break;
                    }
                    default: {
                        this.slideHelper.write("solid");
                    }
                }
                this.slideHelper.write("\"/>\n");
                this.slideHelper.write("  </a:ln>\n");
            }
            this.slideHelper.write("  </p:spPr>\n");
            this.slideHelper.write("  </p:pic>\n");
        }
    }

    protected String getImagePath(JRRenderable renderer, boolean isLazy) {
        String imagePath = null;
        if (renderer != null) {
            if (renderer.getType() == 0 && this.rendererToImagePathMap.containsKey(renderer.getId())) {
                imagePath = (String)this.rendererToImagePathMap.get(renderer.getId());
            } else {
                String imageName;
                JRPrintElementIndex imageIndex = this.getElementIndex();
                this.imagesToProcess.add(imageIndex);
                String mimeType = JRTypeSniffer.getImageMimeType(renderer.getImageType());
                if (mimeType == null) {
                    mimeType = "image/jpeg";
                }
                String extension = mimeType.substring(mimeType.lastIndexOf(47) + 1);
                imagePath = imageName = IMAGE_NAME_PREFIX + imageIndex.toString() + "." + extension;
                this.rendererToImagePathMap.put(renderer.getId(), imagePath);
            }
        }
        return imagePath;
    }

    protected JRPrintElementIndex getElementIndex() {
        StringBuffer sbuffer = new StringBuffer();
        for (int i = 0; i < this.frameIndexStack.size(); ++i) {
            Integer frameIndex = (Integer)this.frameIndexStack.get(i);
            sbuffer.append(frameIndex).append("_");
        }
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, sbuffer.append(this.elementIndex).toString());
        return imageIndex;
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("Invalid image name: " + imageName);
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    protected void exportFrame(JRPrintFrame frame) throws JRException {
        this.slideHelper.write("<p:sp>\n");
        this.slideHelper.write("  <p:nvSpPr>\n");
        this.slideHelper.write("    <p:cNvPr id=\"" + frame.hashCode() + "\" name=\"Frame\"/>\n");
        this.slideHelper.write("    <p:cNvSpPr>\n");
        this.slideHelper.write("      <a:spLocks noGrp=\"1\"/>\n");
        this.slideHelper.write("    </p:cNvSpPr>\n");
        this.slideHelper.write("    <p:nvPr/>\n");
        this.slideHelper.write("  </p:nvSpPr>\n");
        this.slideHelper.write("  <p:spPr>\n");
        this.slideHelper.write("    <a:xfrm>\n");
        this.slideHelper.write("      <a:off x=\"" + Utility.emu(frame.getX() + this.getOffsetX()) + "\" y=\"" + Utility.emu(frame.getY() + this.getOffsetY()) + "\"/>\n");
        this.slideHelper.write("      <a:ext cx=\"" + Utility.emu(frame.getWidth()) + "\" cy=\"" + Utility.emu(frame.getHeight()) + "\"/>\n");
        this.slideHelper.write("    </a:xfrm><a:prstGeom prst=\"rect\"><a:avLst/></a:prstGeom>\n");
        if (frame.getModeValue() == ModeEnum.OPAQUE && frame.getBackcolor() != null) {
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(frame.getBackcolor()) + "\"/></a:solidFill>\n");
        }
        if (frame.getLineBox().getPen().getLineWidth().floatValue() > 0.0f) {
            this.slideHelper.write("  <a:ln w=\"" + Utility.emu(frame.getLineBox().getPen().getLineWidth().floatValue()) + "\">\n");
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(frame.getLineBox().getPen().getLineColor()) + "\"/></a:solidFill>\n");
            this.slideHelper.write("<a:prstDash val=\"");
            switch (frame.getLineBox().getPen().getLineStyleValue()) {
                case DASHED: {
                    this.slideHelper.write("dash");
                    break;
                }
                case DOTTED: {
                    this.slideHelper.write("dot");
                    break;
                }
                default: {
                    this.slideHelper.write("solid");
                }
            }
            this.slideHelper.write("\"/>\n");
            this.slideHelper.write("  </a:ln>\n");
        }
        this.slideHelper.write("  </p:spPr>\n");
        this.slideHelper.write("  <p:txBody>\n");
        this.slideHelper.write("    <a:bodyPr rtlCol=\"0\" anchor=\"ctr\"/>\n");
        this.slideHelper.write("    <a:lstStyle/>\n");
        this.slideHelper.write("    <a:p>\n");
        this.slideHelper.write("<a:pPr algn=\"ctr\"/>\n");
        this.slideHelper.write("    </a:p>\n");
        this.slideHelper.write("  </p:txBody>\n");
        this.slideHelper.write("</p:sp>\n");
        this.setFrameElementsOffset(frame, false);
        this.frameIndexStack.add(this.elementIndex);
        this.exportElements(frame.getElements());
        this.frameIndexStack.remove(this.frameIndexStack.size() - 1);
        this.restoreElementOffsets();
    }

    protected void exportGenericElement(JRGenericPrintElement element) {
        GenericElementPptxHandler handler = (GenericElementPptxHandler)GenericElementHandlerEnviroment.getHandler(element.getGenericType(), PPTX_EXPORTER_KEY);
        if (handler != null) {
            ExporterContext exporterContext = new ExporterContext();
            handler.exportElement(exporterContext, element);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No PPTX generic element handler for " + element.getGenericType()));
        }
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target = null;
        switch (link.getHyperlinkTargetValue()) {
            case SELF: {
                target = "_self";
                break;
            }
            default: {
                target = "_blank";
            }
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block10: {
            JRHyperlinkProducer customHandler;
            block9: {
                href = null;
                customHandler = this.getCustomHandler(link);
                if (customHandler != null) break block9;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block10;
                    }
                    case LOCAL_ANCHOR: {
                        break;
                    }
                    case LOCAL_PAGE: {
                        break;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block10;
                    }
                    case REMOTE_PAGE: {
                        break;
                    }
                }
                break block10;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected String getExporterPropertiesPrefix() {
        return PPTX_EXPORTER_PROPERTIES_PREFIX;
    }

    protected String getExporterKey() {
        return PPTX_EXPORTER_KEY;
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRPptxExporterContext {
        public PptxSlideHelper getSlideHelper() {
            return JRPptxExporter.this.slideHelper;
        }

        public String getExportPropertiesPrefix() {
            return JRPptxExporter.PPTX_EXPORTER_PROPERTIES_PREFIX;
        }
    }
}

