/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table.fill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.ColumnVisitor;
import net.sf.jasperreports.components.table.fill.BuiltinExpressionEvaluator;
import net.sf.jasperreports.components.table.fill.FillColumn;
import net.sf.jasperreports.components.table.fill.TableReportDataset;
import net.sf.jasperreports.components.table.fill.TableReportGroup;
import net.sf.jasperreports.components.table.fill.TableReportScriptlet;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.component.FillContext;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.SplitTypeEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import net.sf.jasperreports.engine.type.WhenNoDataTypeEnum;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableReport
implements JRReport {
    protected static final String SUMMARY_GROUP_NAME = "__SummaryGroup";
    private final FillContext fillContext;
    private final JasperReport parentReport;
    private final TableReportDataset mainDataset;
    private final JRSection detail;
    private final JRDesignBand title;
    private final JRDesignBand summary;
    private final JRDesignBand columnHeader;
    private final JRDesignBand pageFooter;
    private final JRDesignBand lastPageFooter;
    protected static final String TABLE_SCRIPTLET_NAME = "__Table";

    public TableReport(FillContext fillContext, TableReportDataset mainDataset, List<FillColumn> fillColumns, Map<JRExpression, BuiltinExpressionEvaluator> builtinEvaluators) {
        this.fillContext = fillContext;
        this.parentReport = fillContext.getFiller().getJasperReport();
        this.mainDataset = mainDataset;
        this.detail = this.wrapBand(this.createDetailBand(fillColumns), new JROrigin(BandTypeEnum.DETAIL));
        this.title = this.createTitle(fillColumns);
        this.summary = this.createSummary(fillColumns);
        this.columnHeader = this.createColumnHeader(fillColumns);
        this.pageFooter = this.createPageFooter(fillColumns);
        this.setGroupBands(fillColumns);
        if (this.pageFooter != null && this.summary != null) {
            this.addSummaryGroup(fillColumns, builtinEvaluators);
            this.lastPageFooter = new JRDesignBand();
            this.lastPageFooter.setHeight(0);
        } else {
            this.lastPageFooter = null;
        }
    }

    protected JRBand createDetailBand(List<FillColumn> fillColumns) {
        JRDesignBand detailBand = new JRDesignBand();
        detailBand.setSplitType(SplitTypeEnum.PREVENT);
        ReportBandInfo bandInfo = new ReportBandInfo(detailBand);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            DetailBandCreator subVisitor = new DetailBandCreator(bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        return detailBand;
    }

    protected JRDesignBand createColumnHeader(List<FillColumn> fillColumns) {
        JRDesignBand columnHeader = new JRDesignBand();
        columnHeader.setSplitType(SplitTypeEnum.PREVENT);
        ReportBandInfo bandInfo = new ReportBandInfo(columnHeader);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            ColumnHeaderCreator subVisitor = new ColumnHeaderCreator(bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        if (columnHeader.getHeight() == 0) {
            columnHeader = null;
        }
        return columnHeader;
    }

    protected JRDesignBand createPageFooter(List<FillColumn> fillColumns) {
        JRDesignBand pageFooter = new JRDesignBand();
        pageFooter.setSplitType(SplitTypeEnum.PREVENT);
        ReportBandInfo bandInfo = new ReportBandInfo(pageFooter);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            PageFooterCreator subVisitor = new PageFooterCreator(bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        if (pageFooter.getHeight() == 0) {
            pageFooter = null;
        }
        return pageFooter;
    }

    protected JRDesignBand createTitle(List<FillColumn> fillColumns) {
        JRDesignBand title = new JRDesignBand();
        title.setSplitType(SplitTypeEnum.PREVENT);
        ReportBandInfo bandInfo = new ReportBandInfo(title);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            TitleCreator subVisitor = new TitleCreator(bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        if (title.getHeight() == 0) {
            title = null;
        }
        return title;
    }

    protected JRDesignBand createSummary(List<FillColumn> fillColumns) {
        JRDesignBand summary = new JRDesignBand();
        summary.setSplitType(SplitTypeEnum.PREVENT);
        ReportBandInfo bandInfo = new ReportBandInfo(summary);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            SummaryCreator subVisitor = new SummaryCreator(bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        if (summary.getHeight() == 0) {
            summary = null;
        }
        return summary;
    }

    protected JRBand createGroupHeader(String groupName, List<FillColumn> fillColumns) {
        JRDesignBand header = new JRDesignBand();
        header.setSplitType(SplitTypeEnum.PREVENT);
        ReportBandInfo bandInfo = new ReportBandInfo(header);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            GroupHeaderCreator subVisitor = new GroupHeaderCreator(groupName, bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        if (header.getHeight() == 0) {
            header = null;
        }
        return header;
    }

    protected JRBand createGroupFooter(String groupName, List<FillColumn> fillColumns) {
        JRDesignBand footer = new JRDesignBand();
        footer.setSplitType(SplitTypeEnum.PREVENT);
        ReportBandInfo bandInfo = new ReportBandInfo(footer);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            GroupFooterCreator subVisitor = new GroupFooterCreator(groupName, bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        if (footer.getHeight() == 0) {
            footer = null;
        }
        return footer;
    }

    private void setGroupBands(List<FillColumn> fillColumns) {
        TableReportGroup[] groups = this.mainDataset.getTableGroups();
        if (groups != null) {
            for (TableReportGroup group : groups) {
                JRBand footer;
                JRBand header = this.createGroupHeader(group.getName(), fillColumns);
                if (header != null) {
                    group.setGroupHeader(header);
                }
                if ((footer = this.createGroupFooter(group.getName(), fillColumns)) == null) continue;
                group.setGroupFooter(footer);
            }
        }
    }

    protected int computeTableWidth(List<FillColumn> fillColumns) {
        int width = 0;
        for (FillColumn column : fillColumns) {
            width += column.getWidth();
        }
        return width;
    }

    protected void addSummaryGroup(List<FillColumn> fillColumns, Map<JRExpression, BuiltinExpressionEvaluator> builtinEvaluators) {
        JRDesignGroup summaryGroup = new JRDesignGroup();
        summaryGroup.setName(SUMMARY_GROUP_NAME);
        JRDesignBand groupFooter = new JRDesignBand();
        groupFooter.setSplitType(SplitTypeEnum.PREVENT);
        groupFooter.setHeight(this.pageFooter.getHeight());
        JRDesignFrame footerFrame = new JRDesignFrame();
        footerFrame.setX(0);
        footerFrame.setY(0);
        footerFrame.setWidth(this.computeTableWidth(fillColumns));
        footerFrame.setHeight(this.pageFooter.getHeight());
        footerFrame.getLineBox().setPadding(0);
        footerFrame.getLineBox().getPen().setLineWidth(0.0f);
        footerFrame.setRemoveLineWhenBlank(true);
        JRDesignExpression footerPrintWhen = new JRDesignExpression();
        builtinEvaluators.put(footerPrintWhen, new SummaryGroupFooterPrintWhenEvaluator());
        footerFrame.setPrintWhenExpression(footerPrintWhen);
        List footerElements = this.pageFooter.getChildren();
        for (JRChild child : footerElements) {
            JRChild childClone = (JRChild)child.clone(footerFrame);
            if (childClone instanceof JRElement) {
                footerFrame.addElement((JRElement)childClone);
                continue;
            }
            if (childClone instanceof JRElementGroup) {
                footerFrame.addElementGroup((JRElementGroup)childClone);
                continue;
            }
            throw new JRRuntimeException("Uknown child type " + childClone.getClass().getName());
        }
        groupFooter.addElement(footerFrame);
        ((JRDesignSection)summaryGroup.getGroupFooterSection()).addBand(groupFooter);
        this.mainDataset.addScriptlet(TABLE_SCRIPTLET_NAME, TableReportScriptlet.class);
        this.mainDataset.addFirstGroup(summaryGroup);
    }

    protected JRDesignFrame createCellFrame(Cell cell, int originalWidth, int width, int x, int y) {
        JRDesignFrame frame = new JRDesignFrame(this);
        frame.setX(x);
        frame.setY(y);
        frame.setWidth(width);
        frame.setHeight(cell.getHeight());
        frame.setStretchType(StretchTypeEnum.RELATIVE_TO_TALLEST_OBJECT);
        frame.setStyle(cell.getStyle());
        frame.setStyleNameReference(cell.getStyleNameReference());
        frame.copyBox(cell.getLineBox());
        for (JRChild child : cell.getChildren()) {
            if (child instanceof JRElement) {
                JRElement element = (JRElement)child;
                element = (JRElement)element.clone(frame);
                if (width != originalWidth) {
                    this.scaleCellElement(element, originalWidth, width);
                    if (element instanceof JRElementGroup) {
                        JRElementGroup elementGroup = (JRElementGroup)((Object)element);
                        for (JRElement subelement : elementGroup.getElements()) {
                            this.scaleCellElement(subelement, originalWidth, width);
                        }
                    }
                }
                frame.addElement(element);
                continue;
            }
            if (child instanceof JRElementGroup) {
                JRElementGroup elementGroup = (JRElementGroup)child;
                elementGroup = (JRElementGroup)elementGroup.clone(frame);
                frame.addElementGroup(elementGroup);
                if (width == originalWidth) continue;
                for (JRElement element : elementGroup.getElements()) {
                    this.scaleCellElement(element, originalWidth, width);
                }
                continue;
            }
            throw new JRRuntimeException("Unknown JRChild type " + child.getClass().getName());
        }
        return frame;
    }

    protected void scaleCellElement(JRElement element, Integer cellWidth, int scaledCellWidth) {
        int scaledWidth = Math.round((float)element.getWidth() * (float)scaledCellWidth / (float)cellWidth.intValue());
        element.setWidth(scaledWidth);
    }

    protected JRSection wrapBand(JRBand band, JROrigin origin) {
        JRDesignSection section = new JRDesignSection(origin);
        section.addBand(band);
        return section;
    }

    @Override
    public JRBand getBackground() {
        return null;
    }

    @Override
    public int getBottomMargin() {
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public JRBand getColumnFooter() {
        return null;
    }

    @Override
    public JRBand getColumnHeader() {
        return this.columnHeader;
    }

    @Override
    public int getColumnSpacing() {
        return 0;
    }

    @Override
    public int getColumnWidth() {
        return this.fillContext.getComponentElement().getWidth();
    }

    @Override
    public JRDataset[] getDatasets() {
        return this.parentReport.getDatasets();
    }

    @Override
    @Deprecated
    public JRBand getDetail() {
        return null;
    }

    @Override
    public JRSection getDetailSection() {
        return this.detail;
    }

    @Override
    public JRField[] getFields() {
        return this.mainDataset.getFields();
    }

    @Override
    public JRReportFont[] getFonts() {
        return this.parentReport.getFonts();
    }

    @Override
    public String getFormatFactoryClass() {
        return this.parentReport.getFormatFactoryClass();
    }

    @Override
    public JRGroup[] getGroups() {
        return this.mainDataset.getGroups();
    }

    @Override
    public String[] getImports() {
        return this.parentReport.getImports();
    }

    @Override
    public String getLanguage() {
        return this.parentReport.getLanguage();
    }

    @Override
    public JRBand getLastPageFooter() {
        return this.lastPageFooter;
    }

    @Override
    public int getLeftMargin() {
        return 0;
    }

    @Override
    public JRDataset getMainDataset() {
        return this.mainDataset;
    }

    @Override
    public String getName() {
        return this.mainDataset.getName();
    }

    @Override
    public JRBand getNoData() {
        return null;
    }

    @Override
    @Deprecated
    public byte getOrientation() {
        return OrientationEnum.PORTRAIT.getValue();
    }

    @Override
    public OrientationEnum getOrientationValue() {
        return OrientationEnum.PORTRAIT;
    }

    @Override
    public JRBand getPageFooter() {
        return this.pageFooter;
    }

    @Override
    public JRBand getPageHeader() {
        return null;
    }

    @Override
    public int getPageHeight() {
        return this.parentReport.getPageHeight();
    }

    @Override
    public int getPageWidth() {
        return this.fillContext.getComponentElement().getWidth();
    }

    @Override
    public JRParameter[] getParameters() {
        return this.mainDataset.getParameters();
    }

    @Override
    @Deprecated
    public byte getPrintOrder() {
        return PrintOrderEnum.VERTICAL.getValue();
    }

    @Override
    public PrintOrderEnum getPrintOrderValue() {
        return PrintOrderEnum.VERTICAL;
    }

    @Override
    public RunDirectionEnum getColumnDirection() {
        return RunDirectionEnum.LTR;
    }

    @Override
    public String getProperty(String name) {
        return this.mainDataset.getPropertiesMap().getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.mainDataset.getPropertiesMap().getPropertyNames();
    }

    @Override
    public JRQuery getQuery() {
        return this.mainDataset.getQuery();
    }

    @Override
    public String getResourceBundle() {
        return this.mainDataset.getResourceBundle();
    }

    @Override
    public int getRightMargin() {
        return 0;
    }

    @Override
    public String getScriptletClass() {
        return this.mainDataset.getScriptletClass();
    }

    @Override
    public JRScriptlet[] getScriptlets() {
        return this.mainDataset.getScriptlets();
    }

    @Override
    public JRSortField[] getSortFields() {
        return this.mainDataset.getSortFields();
    }

    @Override
    public JRStyle[] getStyles() {
        return this.parentReport.getStyles();
    }

    @Override
    public JRBand getSummary() {
        return this.summary;
    }

    @Override
    public JRReportTemplate[] getTemplates() {
        return null;
    }

    @Override
    public JRBand getTitle() {
        return this.title;
    }

    @Override
    public int getTopMargin() {
        return 0;
    }

    @Override
    public JRVariable[] getVariables() {
        return this.mainDataset.getVariables();
    }

    @Override
    @Deprecated
    public byte getWhenNoDataType() {
        return WhenNoDataTypeEnum.NO_PAGES.getValue();
    }

    @Override
    public WhenNoDataTypeEnum getWhenNoDataTypeValue() {
        return WhenNoDataTypeEnum.NO_PAGES;
    }

    @Override
    @Deprecated
    public byte getWhenResourceMissingType() {
        return this.mainDataset.getWhenResourceMissingType();
    }

    @Override
    public WhenResourceMissingTypeEnum getWhenResourceMissingTypeValue() {
        return this.mainDataset.getWhenResourceMissingTypeValue();
    }

    @Override
    public boolean isFloatColumnFooter() {
        return true;
    }

    @Override
    public boolean isIgnorePagination() {
        return false;
    }

    @Override
    public boolean isSummaryNewPage() {
        return false;
    }

    @Override
    public boolean isSummaryWithPageHeaderAndFooter() {
        return false;
    }

    @Override
    public boolean isTitleNewPage() {
        return false;
    }

    @Override
    public void removeProperty(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(String name, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setWhenNoDataType(byte whenNoDataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWhenNoDataType(WhenNoDataTypeEnum whenNoDataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setWhenResourceMissingType(byte whenResourceMissingType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWhenResourceMissingType(WhenResourceMissingTypeEnum whenResourceMissingType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JRReportFont getDefaultFont() {
        return this.parentReport.getDefaultFont();
    }

    @Override
    public JRStyle getDefaultStyle() {
        return this.parentReport.getDefaultStyle();
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.mainDataset.getPropertiesMap();
    }

    @Override
    public boolean hasProperties() {
        return this.mainDataset.hasProperties();
    }

    protected class SummaryGroupFooterPrintWhenEvaluator
    implements BuiltinExpressionEvaluator {
        private JRValueParameter tableScriptletParam;
        private TableReportScriptlet tableScriptlet;

        protected SummaryGroupFooterPrintWhenEvaluator() {
        }

        public void init(Map parametersMap, Map fieldsMap, Map variablesMap, WhenResourceMissingTypeEnum resourceMissingType) throws JRException {
            this.tableScriptletParam = (JRValueParameter)parametersMap.get("__Table_SCRIPTLET");
        }

        protected void ensureValue() {
            if (this.tableScriptlet == null) {
                this.tableScriptlet = (TableReportScriptlet)this.tableScriptletParam.getValue();
            }
        }

        public Object evaluate() throws JRExpressionEvalException {
            this.ensureValue();
            return this.tableScriptlet.hasDetailOnPage();
        }

        public Object evaluateEstimated() throws JRExpressionEvalException {
            this.ensureValue();
            return this.tableScriptlet.hasDetailOnPage();
        }

        public Object evaluateOld() throws JRExpressionEvalException {
            this.ensureValue();
            return this.tableScriptlet.hasDetailOnPage();
        }
    }

    protected class GroupFooterCreator
    extends ReverseReportBandCreator {
        private final String groupName;

        public GroupFooterCreator(String groupName, ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
            this.groupName = groupName;
        }

        protected Cell columnCell(Column column) {
            return column.getGroupFooter(this.groupName);
        }

        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getGroupFooter(this.groupName);
        }

        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new GroupFooterCreator(this.groupName, this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class GroupHeaderCreator
    extends ReportBandCreator {
        private final String groupName;

        public GroupHeaderCreator(String groupName, ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
            this.groupName = groupName;
        }

        protected Cell columnCell(Column column) {
            return column.getGroupHeader(this.groupName);
        }

        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getGroupHeader(this.groupName);
        }

        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new GroupHeaderCreator(this.groupName, this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class SummaryCreator
    extends ReverseReportBandCreator {
        public SummaryCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        protected Cell columnCell(Column column) {
            return column.getTableFooter();
        }

        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getTableFooter();
        }

        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new SummaryCreator(this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class TitleCreator
    extends ReportBandCreator {
        public TitleCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        protected Cell columnCell(Column column) {
            return column.getTableHeader();
        }

        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getTableHeader();
        }

        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new TitleCreator(this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class PageFooterCreator
    extends ReverseReportBandCreator {
        public PageFooterCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        protected Cell columnCell(Column column) {
            return column.getColumnFooter();
        }

        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getColumnFooter();
        }

        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new PageFooterCreator(this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class ColumnHeaderCreator
    extends ReportBandCreator {
        public ColumnHeaderCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        protected Cell columnCell(Column column) {
            return column.getColumnHeader();
        }

        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getColumnHeader();
        }

        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new ColumnHeaderCreator(this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class DetailBandCreator
    extends ReportBandCreator {
        public DetailBandCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        protected Cell columnCell(Column column) {
            return column.getDetailCell();
        }

        protected Cell columnGroupCell(ColumnGroup group) {
            return null;
        }

        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new DetailBandCreator(this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected abstract class ReverseReportBandCreator
    extends ReportBandCreator {
        public ReverseReportBandCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        public Void visitColumnGroup(ColumnGroup columnGroup) {
            Cell cell = this.columnGroupCell(columnGroup);
            int rowSpan = cell == null ? 0 : (cell.getRowSpan() == null ? 1 : cell.getRowSpan());
            int origXOffset = this.xOffset;
            int origYOffset = this.yOffset;
            for (FillColumn subcolumn : this.fillColumn.getSubcolumns()) {
                ReportBandCreator subVisitor = this.createSubVisitor(subcolumn, this.xOffset, origYOffset, this.level + rowSpan);
                subVisitor.visit();
                this.xOffset = subVisitor.xOffset;
                if (subVisitor.yOffset <= this.yOffset) continue;
                this.yOffset = subVisitor.yOffset;
            }
            if (cell != null) {
                JRDesignFrame cellFrame = TableReport.this.createCellFrame(cell, columnGroup.getWidth(), this.fillColumn.getWidth(), origXOffset, this.yOffset);
                this.bandInfo.addElement(this.level + rowSpan - 1, cellFrame);
                this.yOffset += cell.getHeight().intValue();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ReportBandCreator
    implements ColumnVisitor<Void> {
        final ReportBandInfo bandInfo;
        final FillColumn fillColumn;
        int xOffset;
        int yOffset;
        int level;

        public ReportBandCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            this.bandInfo = bandInfo;
            this.fillColumn = fillColumn;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.level = level;
        }

        @Override
        public Void visitColumn(Column column) {
            Cell cell = this.columnCell(column);
            if (cell != null) {
                JRDesignFrame cellFrame = TableReport.this.createCellFrame(cell, column.getWidth(), this.fillColumn.getWidth(), this.xOffset, this.yOffset);
                int rowSpan = cell.getRowSpan() == null ? 1 : cell.getRowSpan();
                this.bandInfo.addElement(this.level + rowSpan - 1, cellFrame);
                this.yOffset += cell.getHeight().intValue();
            }
            this.xOffset += column.getWidth().intValue();
            return null;
        }

        protected abstract Cell columnCell(Column var1);

        @Override
        public Void visitColumnGroup(ColumnGroup columnGroup) {
            Cell cell = this.columnGroupCell(columnGroup);
            int cellHeight = 0;
            int sublevel = this.level;
            if (cell != null) {
                int rowSpan = cell.getRowSpan() == null ? 1 : cell.getRowSpan();
                JRDesignFrame cellFrame = TableReport.this.createCellFrame(cell, columnGroup.getWidth(), this.fillColumn.getWidth(), this.xOffset, this.yOffset);
                this.bandInfo.addElement(this.level + rowSpan - 1, cellFrame);
                cellHeight = cell.getHeight();
                sublevel += rowSpan;
            }
            for (FillColumn subcolumn : this.fillColumn.getSubcolumns()) {
                ReportBandCreator subVisitor = this.createSubVisitor(subcolumn, this.xOffset, this.yOffset + cellHeight, sublevel);
                subVisitor.visit();
                this.xOffset = subVisitor.xOffset;
            }
            return null;
        }

        protected abstract Cell columnGroupCell(ColumnGroup var1);

        protected abstract ReportBandCreator createSubVisitor(FillColumn var1, int var2, int var3, int var4);

        public void visit() {
            this.fillColumn.getTableColumn().visitColumn(this);
        }
    }

    protected class ReportBandInfo {
        final JRDesignBand band;
        final List<JRDesignElementGroup> rowGroups = new ArrayList<JRDesignElementGroup>();

        ReportBandInfo(JRDesignBand band) {
            this.band = band;
        }

        void addElement(int rowLevel, JRDesignElement element) {
            if (this.band.getHeight() < element.getHeight() + element.getY()) {
                this.band.setHeight(element.getHeight() + element.getY());
            }
            JRDesignElementGroup rowGroup = this.getRowElementGroup(rowLevel);
            rowGroup.addElement(element);
        }

        JRDesignElementGroup getRowElementGroup(int rowLevel) {
            int rowCount = this.rowGroups.size();
            if (rowLevel >= rowCount) {
                for (int level = rowCount; level <= rowLevel; ++level) {
                    JRDesignElementGroup group = new JRDesignElementGroup();
                    this.band.addElementGroup(group);
                    this.rowGroups.add(group);
                }
            }
            return this.rowGroups.get(rowLevel);
        }
    }
}

