/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import net.sf.jasperreports.charts.JRCategoryAxisFormat;
import net.sf.jasperreports.charts.JRTimeAxisFormat;
import net.sf.jasperreports.charts.JRValueAxisFormat;
import net.sf.jasperreports.charts.JRXAxisFormat;
import net.sf.jasperreports.charts.JRYAxisFormat;
import net.sf.jasperreports.engine.JRAlignment;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRCommonImage;
import net.sf.jasperreports.engine.JRCommonRectangle;
import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRProperties;

public final class JRStyleResolver {
    private static final Integer INTEGER_ZERO = 0;

    private static JRFont getBaseFont(JRFont font) {
        JRReportFont reportFont = font.getReportFont();
        if (reportFont != null) {
            return reportFont;
        }
        JRDefaultStyleProvider defaultStyleProvider = font.getDefaultStyleProvider();
        if (defaultStyleProvider != null) {
            return defaultStyleProvider.getDefaultFont();
        }
        return null;
    }

    public static JRStyle getBaseStyle(JRStyleContainer styleContainer) {
        if (styleContainer != null) {
            JRStyle style = styleContainer.getStyle();
            if (style != null) {
                return style;
            }
            JRDefaultStyleProvider defaultStyleProvider = styleContainer.getDefaultStyleProvider();
            if (defaultStyleProvider != null) {
                return defaultStyleProvider.getDefaultStyle();
            }
        }
        return null;
    }

    public static byte getMode(JRCommonElement element, byte defaultMode) {
        return JRStyleResolver.getMode(element, ModeEnum.getByValue(defaultMode)).getValue();
    }

    public static Byte getMode(JRStyle style) {
        ModeEnum mode = JRStyleResolver.getModeValue(style);
        return mode == null ? null : mode.getValueByte();
    }

    public static ModeEnum getMode(JRCommonElement element, ModeEnum defaultMode) {
        ModeEnum mode;
        ModeEnum ownMode = element.getOwnModeValue();
        if (ownMode != null) {
            return ownMode;
        }
        JRStyle style = JRStyleResolver.getBaseStyle(element);
        if (style != null && (mode = style.getModeValue()) != null) {
            return mode;
        }
        return defaultMode;
    }

    public static ModeEnum getModeValue(JRStyle style) {
        ModeEnum ownMode = style.getOwnModeValue();
        if (ownMode != null) {
            return ownMode;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getModeValue();
        }
        return null;
    }

    public static Color getForecolor(JRCommonElement element) {
        Color forecolor;
        Color ownForecolor = element.getOwnForecolor();
        if (ownForecolor != null) {
            return ownForecolor;
        }
        JRStyle style = JRStyleResolver.getBaseStyle(element);
        if (style != null && (forecolor = style.getForecolor()) != null) {
            return forecolor;
        }
        return Color.black;
    }

    public static Color getForecolor(JRChartPlot plot) {
        JRChart chart = plot.getChart();
        if (chart != null) {
            return JRStyleResolver.getForecolor(chart);
        }
        return Color.black;
    }

    public static Color getForecolor(JRStyle style) {
        Color ownForecolor = style.getOwnForecolor();
        if (ownForecolor != null) {
            return ownForecolor;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getForecolor();
        }
        return null;
    }

    public static Color getBackcolor(JRCommonElement element) {
        Color backcolor;
        Color ownBackcolor = element.getOwnBackcolor();
        if (ownBackcolor != null) {
            return ownBackcolor;
        }
        JRStyle style = JRStyleResolver.getBaseStyle(element);
        if (style != null && (backcolor = style.getBackcolor()) != null) {
            return backcolor;
        }
        return Color.white;
    }

    public static Color getBackcolor(JRChartPlot plot) {
        Color ownBackcolor = plot.getOwnBackcolor();
        if (ownBackcolor != null) {
            return ownBackcolor;
        }
        JRChart chart = plot.getChart();
        if (chart != null) {
            return JRStyleResolver.getBackcolor(chart);
        }
        return Color.white;
    }

    public static Color getBackcolor(JRStyle style) {
        Color ownBackcolor = style.getOwnBackcolor();
        if (ownBackcolor != null) {
            return ownBackcolor;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getBackcolor();
        }
        return null;
    }

    public static Float getLineWidth(JRPen pen, Float defaultLineWidth) {
        Float lineWidth;
        Float ownLineWidth = pen.getOwnLineWidth();
        if (ownLineWidth != null) {
            return ownLineWidth;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(pen.getStyleContainer());
        if (baseStyle != null && (lineWidth = baseStyle.getLinePen().getLineWidth()) != null) {
            return lineWidth;
        }
        return defaultLineWidth;
    }

    public static Float getLineWidth(JRBoxPen boxPen, Float defaultLineWidth) {
        Float lineWidth;
        Float ownLineWidth = boxPen.getOwnLineWidth();
        if (ownLineWidth != null) {
            return ownLineWidth;
        }
        Float penLineWidth = boxPen.getBox().getPen().getOwnLineWidth();
        if (penLineWidth != null) {
            return penLineWidth;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(boxPen.getStyleContainer());
        if (baseStyle != null && (lineWidth = boxPen.getPen(baseStyle.getLineBox()).getLineWidth()) != null) {
            return lineWidth;
        }
        return defaultLineWidth;
    }

    public static Byte getLineStyle(JRPen pen) {
        return JRStyleResolver.getLineStyleValue(pen).getValueByte();
    }

    public static LineStyleEnum getLineStyleValue(JRPen pen) {
        LineStyleEnum lineStyle;
        LineStyleEnum ownLineStyle = pen.getOwnLineStyleValue();
        if (ownLineStyle != null) {
            return ownLineStyle;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(pen.getStyleContainer());
        if (baseStyle != null && (lineStyle = baseStyle.getLinePen().getLineStyleValue()) != null) {
            return lineStyle;
        }
        return LineStyleEnum.SOLID;
    }

    public static Byte getLineStyle(JRBoxPen boxPen) {
        return JRStyleResolver.getLineStyleValue(boxPen).getValueByte();
    }

    public static LineStyleEnum getLineStyleValue(JRBoxPen boxPen) {
        LineStyleEnum lineStyle;
        LineStyleEnum ownLineStyle = boxPen.getOwnLineStyleValue();
        if (ownLineStyle != null) {
            return ownLineStyle;
        }
        LineStyleEnum penLineStyle = boxPen.getBox().getPen().getOwnLineStyleValue();
        if (penLineStyle != null) {
            return penLineStyle;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(boxPen.getStyleContainer());
        if (baseStyle != null && (lineStyle = boxPen.getPen(baseStyle.getLineBox()).getLineStyleValue()) != null) {
            return lineStyle;
        }
        return LineStyleEnum.SOLID;
    }

    public static Color getLineColor(JRPen pen, Color defaultColor) {
        Color lineColor;
        Color ownLineColor = pen.getOwnLineColor();
        if (ownLineColor != null) {
            return ownLineColor;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(pen.getStyleContainer());
        if (baseStyle != null && (lineColor = baseStyle.getLinePen().getLineColor()) != null) {
            return lineColor;
        }
        return defaultColor;
    }

    public static Color getLineColor(JRBoxPen boxPen, Color defaultColor) {
        Color lineColor;
        Color ownLineColor = boxPen.getOwnLineColor();
        if (ownLineColor != null) {
            return ownLineColor;
        }
        Color penLineColor = boxPen.getBox().getPen().getOwnLineColor();
        if (penLineColor != null) {
            return penLineColor;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(boxPen.getStyleContainer());
        if (baseStyle != null && (lineColor = boxPen.getPen(baseStyle.getLineBox()).getLineColor()) != null) {
            return lineColor;
        }
        return defaultColor;
    }

    public static byte getFill(JRCommonGraphicElement element) {
        return JRStyleResolver.getFillValue(element).getValue();
    }

    public static Byte getFill(JRStyle style) {
        return JRStyleResolver.getFillValue(style).getValueByte();
    }

    public static FillEnum getFillValue(JRCommonGraphicElement element) {
        FillEnum fill;
        FillEnum ownFill = element.getOwnFillValue();
        if (ownFill != null) {
            return ownFill;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(element);
        if (baseStyle != null && (fill = baseStyle.getFillValue()) != null) {
            return fill;
        }
        return FillEnum.SOLID;
    }

    public static FillEnum getFillValue(JRStyle style) {
        FillEnum ownFill = style.getOwnFillValue();
        if (ownFill != null) {
            return ownFill;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getFillValue();
        }
        return null;
    }

    public static int getRadius(JRCommonRectangle rectangle) {
        Integer radius;
        Integer ownRadius = rectangle.getOwnRadius();
        if (ownRadius != null) {
            return ownRadius;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(rectangle);
        if (baseStyle != null && (radius = baseStyle.getRadius()) != null) {
            return radius;
        }
        return 0;
    }

    public static Integer getRadius(JRStyle style) {
        Integer ownRadius = style.getOwnRadius();
        if (ownRadius != null) {
            return ownRadius;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getRadius();
        }
        return null;
    }

    public static byte getScaleImage(JRCommonImage image) {
        Byte scaleImage;
        Byte ownScaleImage = image.getOwnScaleImage();
        if (ownScaleImage != null) {
            return ownScaleImage;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(image);
        if (baseStyle != null && (scaleImage = baseStyle.getScaleImage()) != null) {
            return scaleImage;
        }
        return 3;
    }

    public static Byte getScaleImage(JRStyle style) {
        Byte ownScaleImage = style.getOwnScaleImage();
        if (ownScaleImage != null) {
            return ownScaleImage;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getScaleImage();
        }
        return null;
    }

    public static ScaleImageEnum getScaleImageValue(JRCommonImage image) {
        ScaleImageEnum scaleImage;
        ScaleImageEnum ownScaleImage = image.getOwnScaleImageValue();
        if (ownScaleImage != null) {
            return ownScaleImage;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(image);
        if (baseStyle != null && (scaleImage = baseStyle.getScaleImageValue()) != null) {
            return scaleImage;
        }
        return ScaleImageEnum.RETAIN_SHAPE;
    }

    public static ScaleImageEnum getScaleImageValue(JRStyle style) {
        ScaleImageEnum ownScaleImage = style.getOwnScaleImageValue();
        if (ownScaleImage != null) {
            return ownScaleImage;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getScaleImageValue();
        }
        return null;
    }

    public static byte getHorizontalAlignment(JRAlignment alignment) {
        return JRStyleResolver.getHorizontalAlignmentValue(alignment).getValue();
    }

    public static HorizontalAlignEnum getHorizontalAlignmentValue(JRAlignment alignment) {
        HorizontalAlignEnum horizontalAlignment;
        HorizontalAlignEnum ownHorizontalAlignment = alignment.getOwnHorizontalAlignmentValue();
        if (ownHorizontalAlignment != null) {
            return ownHorizontalAlignment;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(alignment);
        if (baseStyle != null && (horizontalAlignment = baseStyle.getHorizontalAlignmentValue()) != null) {
            return horizontalAlignment;
        }
        return HorizontalAlignEnum.LEFT;
    }

    public static Byte getHorizontalAlignment(JRStyle style) {
        HorizontalAlignEnum horizontalAlign = JRStyleResolver.getHorizontalAlignmentValue(style);
        return horizontalAlign == null ? null : horizontalAlign.getValueByte();
    }

    public static HorizontalAlignEnum getHorizontalAlignmentValue(JRStyle style) {
        HorizontalAlignEnum ownHorizontalAlignment = style.getOwnHorizontalAlignmentValue();
        if (ownHorizontalAlignment != null) {
            return ownHorizontalAlignment;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getHorizontalAlignmentValue();
        }
        return null;
    }

    public static byte getVerticalAlignment(JRAlignment alignment) {
        return JRStyleResolver.getVerticalAlignmentValue(alignment).getValue();
    }

    public static VerticalAlignEnum getVerticalAlignmentValue(JRAlignment alignment) {
        VerticalAlignEnum verticalAlignment;
        VerticalAlignEnum ownVerticalAlignment = alignment.getOwnVerticalAlignmentValue();
        if (ownVerticalAlignment != null) {
            return ownVerticalAlignment;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(alignment);
        if (baseStyle != null && (verticalAlignment = baseStyle.getVerticalAlignmentValue()) != null) {
            return verticalAlignment;
        }
        return VerticalAlignEnum.TOP;
    }

    public static Byte getVerticalAlignment(JRStyle style) {
        VerticalAlignEnum verticalAlignment = JRStyleResolver.getVerticalAlignmentValue(style);
        return verticalAlignment == null ? null : verticalAlignment.getValueByte();
    }

    public static VerticalAlignEnum getVerticalAlignmentValue(JRStyle style) {
        VerticalAlignEnum ownVerticalAlignment = style.getOwnVerticalAlignmentValue();
        if (ownVerticalAlignment != null) {
            return ownVerticalAlignment;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getVerticalAlignmentValue();
        }
        return null;
    }

    public static byte getRotation(JRCommonText element) {
        return JRStyleResolver.getRotationValue(element).getValue();
    }

    public static Byte getRotation(JRStyle style) {
        RotationEnum rotation = JRStyleResolver.getRotationValue(style);
        return rotation == null ? null : rotation.getValueByte();
    }

    public static RotationEnum getRotationValue(JRCommonText element) {
        RotationEnum rotation;
        RotationEnum ownRotation = element.getOwnRotationValue();
        if (ownRotation != null) {
            return ownRotation;
        }
        JRStyle style = JRStyleResolver.getBaseStyle(element);
        if (style != null && (rotation = style.getRotationValue()) != null) {
            return rotation;
        }
        return RotationEnum.NONE;
    }

    public static RotationEnum getRotationValue(JRStyle style) {
        RotationEnum ownRotation = style.getOwnRotationValue();
        if (ownRotation != null) {
            return ownRotation;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getRotationValue();
        }
        return null;
    }

    public static byte getLineSpacing(JRCommonText element) {
        return JRStyleResolver.getLineSpacingValue(element).getValue();
    }

    public static Byte getLineSpacing(JRStyle style) {
        LineSpacingEnum lineSpacing = JRStyleResolver.getLineSpacingValue(style);
        return lineSpacing == null ? null : lineSpacing.getValueByte();
    }

    public static LineSpacingEnum getLineSpacingValue(JRCommonText element) {
        LineSpacingEnum lineSpacing;
        LineSpacingEnum ownLineSpacing = element.getOwnLineSpacingValue();
        if (ownLineSpacing != null) {
            return ownLineSpacing;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(element);
        if (baseStyle != null && (lineSpacing = baseStyle.getLineSpacingValue()) != null) {
            return lineSpacing;
        }
        return LineSpacingEnum.SINGLE;
    }

    public static LineSpacingEnum getLineSpacingValue(JRStyle style) {
        LineSpacingEnum ownLineSpacing = style.getOwnLineSpacingValue();
        if (ownLineSpacing != null) {
            return ownLineSpacing;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getLineSpacingValue();
        }
        return null;
    }

    public static String getMarkup(JRCommonText element) {
        String markup;
        String ownMarkup = element.getOwnMarkup();
        if (ownMarkup != null) {
            return ownMarkup;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(element);
        if (baseStyle != null && (markup = baseStyle.getMarkup()) != null) {
            return markup;
        }
        return "none";
    }

    public static String getMarkup(JRStyle style) {
        String ownMarkup = style.getOwnMarkup();
        if (ownMarkup != null) {
            return ownMarkup;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getMarkup();
        }
        return "none";
    }

    public static String getPattern(JRTextField element) {
        String ownPattern = element.getOwnPattern();
        if (ownPattern != null) {
            return ownPattern;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(element);
        if (baseStyle != null) {
            return baseStyle.getPattern();
        }
        return null;
    }

    public static String getPattern(JRStyle style) {
        String ownPattern = style.getOwnPattern();
        if (ownPattern != null) {
            return ownPattern;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getPattern();
        }
        return null;
    }

    public static boolean isBlankWhenNull(JRTextField element) {
        Boolean blankWhenNull;
        Boolean ownBlankWhenNull = element.isOwnBlankWhenNull();
        if (ownBlankWhenNull != null) {
            return ownBlankWhenNull;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(element);
        if (baseStyle != null && (blankWhenNull = baseStyle.isBlankWhenNull()) != null) {
            return blankWhenNull;
        }
        return false;
    }

    public static Boolean isBlankWhenNull(JRStyle style) {
        Boolean ownBlankWhenNull = style.isOwnBlankWhenNull();
        if (ownBlankWhenNull != null) {
            return ownBlankWhenNull;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.isBlankWhenNull();
        }
        return null;
    }

    public static String getFontName(JRFont font) {
        String fontName;
        String fontName2;
        String ownFontName = font.getOwnFontName();
        if (ownFontName != null) {
            return ownFontName;
        }
        JRFont baseFont = JRStyleResolver.getBaseFont(font);
        if (baseFont != null && (fontName2 = baseFont.getFontName()) != null) {
            return fontName2;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(font);
        if (baseStyle != null && (fontName = baseStyle.getFontName()) != null) {
            return fontName;
        }
        return JRProperties.getProperty("net.sf.jasperreports.default.font.name");
    }

    public static String getFontName(JRStyle style) {
        String fontName;
        String ownFontName = style.getOwnFontName();
        if (ownFontName != null) {
            return ownFontName;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null && (fontName = baseStyle.getFontName()) != null) {
            return fontName;
        }
        return JRProperties.getProperty("net.sf.jasperreports.default.font.name");
    }

    public static boolean isBold(JRFont font) {
        Boolean bold;
        Boolean ownBold = font.isOwnBold();
        if (ownBold != null) {
            return ownBold;
        }
        JRFont baseFont = JRStyleResolver.getBaseFont(font);
        if (baseFont != null) {
            return baseFont.isBold();
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(font);
        if (baseStyle != null && (bold = baseStyle.isBold()) != null) {
            return bold;
        }
        return false;
    }

    public static Boolean isBold(JRStyle style) {
        Boolean ownBold = style.isOwnBold();
        if (ownBold != null) {
            return ownBold;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.isBold();
        }
        return null;
    }

    public static boolean isItalic(JRFont font) {
        Boolean italic;
        Boolean ownItalic = font.isOwnItalic();
        if (ownItalic != null) {
            return ownItalic;
        }
        JRFont baseFont = JRStyleResolver.getBaseFont(font);
        if (baseFont != null) {
            return baseFont.isItalic();
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(font);
        if (baseStyle != null && (italic = baseStyle.isItalic()) != null) {
            return italic;
        }
        return false;
    }

    public static Boolean isItalic(JRStyle style) {
        Boolean ownItalic = style.isOwnItalic();
        if (ownItalic != null) {
            return ownItalic;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.isItalic();
        }
        return null;
    }

    public static boolean isUnderline(JRFont font) {
        Boolean underline;
        Boolean ownUnderline = font.isOwnUnderline();
        if (ownUnderline != null) {
            return ownUnderline;
        }
        JRFont baseFont = JRStyleResolver.getBaseFont(font);
        if (baseFont != null) {
            return baseFont.isUnderline();
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(font);
        if (baseStyle != null && (underline = baseStyle.isUnderline()) != null) {
            return underline;
        }
        return false;
    }

    public static Boolean isUnderline(JRStyle style) {
        Boolean ownUnderline = style.isOwnUnderline();
        if (ownUnderline != null) {
            return ownUnderline;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.isUnderline();
        }
        return null;
    }

    public static boolean isStrikeThrough(JRFont font) {
        Boolean strikeThrough;
        Boolean ownStrikeThrough = font.isOwnStrikeThrough();
        if (ownStrikeThrough != null) {
            return ownStrikeThrough;
        }
        JRFont baseFont = JRStyleResolver.getBaseFont(font);
        if (baseFont != null) {
            return baseFont.isStrikeThrough();
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(font);
        if (baseStyle != null && (strikeThrough = baseStyle.isStrikeThrough()) != null) {
            return strikeThrough;
        }
        return false;
    }

    public static Boolean isStrikeThrough(JRStyle style) {
        if (style.isOwnStrikeThrough() != null) {
            return style.isOwnStrikeThrough();
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.isStrikeThrough();
        }
        return null;
    }

    public static int getFontSize(JRFont font) {
        Integer fontSize;
        Integer ownFontSize = font.getOwnFontSize();
        if (ownFontSize != null) {
            return ownFontSize;
        }
        JRFont baseFont = JRStyleResolver.getBaseFont(font);
        if (baseFont != null) {
            return baseFont.getFontSize();
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(font);
        if (baseStyle != null && (fontSize = baseStyle.getFontSize()) != null) {
            return fontSize;
        }
        return JRProperties.getIntegerProperty("net.sf.jasperreports.default.font.size");
    }

    public static Integer getFontSize(JRStyle style) {
        Integer ownFontSize = style.getOwnFontSize();
        if (ownFontSize != null) {
            return ownFontSize;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getFontSize();
        }
        return null;
    }

    public static String getPdfFontName(JRFont font) {
        String pdfFontName;
        String pdfFontName2;
        String ownPdfFontName = font.getOwnPdfFontName();
        if (ownPdfFontName != null) {
            return ownPdfFontName;
        }
        JRFont baseFont = JRStyleResolver.getBaseFont(font);
        if (baseFont != null && (pdfFontName2 = baseFont.getPdfFontName()) != null) {
            return pdfFontName2;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(font);
        if (baseStyle != null && (pdfFontName = baseStyle.getPdfFontName()) != null) {
            return pdfFontName;
        }
        return JRProperties.getProperty("net.sf.jasperreports.default.pdf.font.name");
    }

    public static String getPdfFontName(JRStyle style) {
        String pdfFontName;
        String ownPdfFontName = style.getOwnPdfFontName();
        if (ownPdfFontName != null) {
            return ownPdfFontName;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null && (pdfFontName = baseStyle.getPdfFontName()) != null) {
            return pdfFontName;
        }
        return JRProperties.getProperty("net.sf.jasperreports.default.pdf.font.name");
    }

    public static String getPdfEncoding(JRFont font) {
        String pdfEncoding;
        String pdfEncoding2;
        String ownPdfEncoding = font.getOwnPdfEncoding();
        if (ownPdfEncoding != null) {
            return ownPdfEncoding;
        }
        JRFont baseFont = JRStyleResolver.getBaseFont(font);
        if (baseFont != null && (pdfEncoding2 = baseFont.getPdfEncoding()) != null) {
            return pdfEncoding2;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(font);
        if (baseStyle != null && (pdfEncoding = baseStyle.getPdfEncoding()) != null) {
            return pdfEncoding;
        }
        return JRProperties.getProperty("net.sf.jasperreports.default.pdf.encoding");
    }

    public static String getPdfEncoding(JRStyle style) {
        String pdfEncoding;
        String ownPdfEncoding = style.getOwnPdfEncoding();
        if (ownPdfEncoding != null) {
            return ownPdfEncoding;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null && (pdfEncoding = baseStyle.getPdfEncoding()) != null) {
            return pdfEncoding;
        }
        return JRProperties.getProperty("net.sf.jasperreports.default.pdf.encoding");
    }

    public static boolean isPdfEmbedded(JRFont font) {
        Boolean pdfEmbedded;
        Boolean ownPdfEmbedded = font.isOwnPdfEmbedded();
        if (ownPdfEmbedded != null) {
            return ownPdfEmbedded;
        }
        JRFont baseFont = JRStyleResolver.getBaseFont(font);
        if (baseFont != null) {
            return baseFont.isPdfEmbedded();
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(font);
        if (baseStyle != null && (pdfEmbedded = baseStyle.isPdfEmbedded()) != null) {
            return pdfEmbedded;
        }
        return JRProperties.getBooleanProperty("net.sf.jasperreports.default.pdf.embedded");
    }

    public static Boolean isPdfEmbedded(JRStyle style) {
        Boolean ownPdfEmbedded = style.isOwnPdfEmbedded();
        if (ownPdfEmbedded != null) {
            return ownPdfEmbedded;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.isPdfEmbedded();
        }
        return null;
    }

    public static Integer getPadding(JRLineBox box) {
        Integer padding;
        Integer ownPadding = box.getOwnPadding();
        if (ownPadding != null) {
            return ownPadding;
        }
        JRStyle baseStyle = JRStyleResolver.getBaseStyle(box);
        if (baseStyle != null && (padding = baseStyle.getLineBox().getPadding()) != null) {
            return padding;
        }
        return INTEGER_ZERO;
    }

    public static Integer getTopPadding(JRLineBox box) {
        Integer topPadding;
        Integer ownTopPadding = box.getOwnTopPadding();
        if (ownTopPadding != null) {
            return ownTopPadding;
        }
        Integer ownPadding = box.getOwnPadding();
        if (ownPadding != null) {
            return ownPadding;
        }
        JRStyle style = JRStyleResolver.getBaseStyle(box);
        if (style != null && (topPadding = style.getLineBox().getTopPadding()) != null) {
            return topPadding;
        }
        return INTEGER_ZERO;
    }

    public static Integer getLeftPadding(JRLineBox box) {
        Integer leftPadding;
        Integer ownLeftPadding = box.getOwnLeftPadding();
        if (ownLeftPadding != null) {
            return ownLeftPadding;
        }
        Integer ownPadding = box.getOwnPadding();
        if (ownPadding != null) {
            return ownPadding;
        }
        JRStyle style = JRStyleResolver.getBaseStyle(box);
        if (style != null && (leftPadding = style.getLineBox().getLeftPadding()) != null) {
            return leftPadding;
        }
        return INTEGER_ZERO;
    }

    public static Integer getBottomPadding(JRLineBox box) {
        Integer bottomPadding;
        Integer ownBottomPadding = box.getOwnBottomPadding();
        if (ownBottomPadding != null) {
            return ownBottomPadding;
        }
        Integer ownPadding = box.getOwnPadding();
        if (ownPadding != null) {
            return ownPadding;
        }
        JRStyle style = JRStyleResolver.getBaseStyle(box);
        if (style != null && (bottomPadding = style.getLineBox().getBottomPadding()) != null) {
            return bottomPadding;
        }
        return INTEGER_ZERO;
    }

    public static Integer getRightPadding(JRLineBox box) {
        Integer rightPadding;
        Integer ownRightPadding = box.getOwnRightPadding();
        if (ownRightPadding != null) {
            return ownRightPadding;
        }
        Integer ownPadding = box.getOwnPadding();
        if (ownPadding != null) {
            return ownPadding;
        }
        JRStyle style = JRStyleResolver.getBaseStyle(box);
        if (style != null && (rightPadding = style.getLineBox().getRightPadding()) != null) {
            return rightPadding;
        }
        return INTEGER_ZERO;
    }

    public static void appendStyle(JRStyle destStyle, JRStyle srcStyle) {
        if (srcStyle.getOwnModeValue() != null) {
            destStyle.setMode(srcStyle.getOwnModeValue());
        }
        if (srcStyle.getOwnForecolor() != null) {
            destStyle.setForecolor(srcStyle.getOwnForecolor());
        }
        if (srcStyle.getOwnBackcolor() != null) {
            destStyle.setBackcolor(srcStyle.getOwnBackcolor());
        }
        JRStyleResolver.appendPen(destStyle.getLinePen(), srcStyle.getLinePen());
        if (srcStyle.getOwnFillValue() != null) {
            destStyle.setFill(srcStyle.getOwnFillValue());
        }
        if (srcStyle.getOwnRadius() != null) {
            destStyle.setRadius(srcStyle.getOwnRadius());
        }
        if (srcStyle.getOwnScaleImageValue() != null) {
            destStyle.setScaleImage(srcStyle.getOwnScaleImageValue());
        }
        if (srcStyle.getOwnHorizontalAlignmentValue() != null) {
            destStyle.setHorizontalAlignment(srcStyle.getOwnHorizontalAlignmentValue());
        }
        if (srcStyle.getOwnVerticalAlignmentValue() != null) {
            destStyle.setVerticalAlignment(srcStyle.getOwnVerticalAlignmentValue());
        }
        JRStyleResolver.appendBox(destStyle.getLineBox(), srcStyle.getLineBox());
        if (srcStyle.getOwnRotationValue() != null) {
            destStyle.setRotation(srcStyle.getOwnRotationValue());
        }
        if (srcStyle.getOwnLineSpacingValue() != null) {
            destStyle.setLineSpacing(srcStyle.getOwnLineSpacingValue());
        }
        if (srcStyle.getOwnMarkup() != null) {
            destStyle.setMarkup(srcStyle.getOwnMarkup());
        }
        if (srcStyle.getOwnPattern() != null) {
            destStyle.setPattern(srcStyle.getOwnPattern());
        }
        if (srcStyle.getOwnFontName() != null) {
            destStyle.setFontName(srcStyle.getOwnFontName());
        }
        if (srcStyle.isOwnBold() != null) {
            destStyle.setBold(srcStyle.isOwnBold());
        }
        if (srcStyle.isOwnItalic() != null) {
            destStyle.setItalic(srcStyle.isOwnItalic());
        }
        if (srcStyle.isOwnUnderline() != null) {
            destStyle.setUnderline(srcStyle.isOwnUnderline());
        }
        if (srcStyle.isOwnStrikeThrough() != null) {
            destStyle.setStrikeThrough(srcStyle.isOwnStrikeThrough());
        }
        if (srcStyle.getOwnFontSize() != null) {
            destStyle.setFontSize(srcStyle.getOwnFontSize());
        }
        if (srcStyle.getOwnPdfFontName() != null) {
            destStyle.setPdfFontName(srcStyle.getOwnPdfFontName());
        }
        if (srcStyle.getOwnPdfEncoding() != null) {
            destStyle.setPdfEncoding(srcStyle.getOwnPdfEncoding());
        }
        if (srcStyle.isOwnPdfEmbedded() != null) {
            destStyle.setPdfEmbedded(srcStyle.isOwnPdfEmbedded());
        }
    }

    private static void appendPen(JRPen destPen, JRPen srcPen) {
        if (srcPen.getOwnLineWidth() != null) {
            destPen.setLineWidth(srcPen.getOwnLineWidth());
        }
        if (srcPen.getOwnLineStyleValue() != null) {
            destPen.setLineStyle(srcPen.getOwnLineStyleValue());
        }
        if (srcPen.getOwnLineColor() != null) {
            destPen.setLineColor(srcPen.getOwnLineColor());
        }
    }

    private static void appendBox(JRLineBox destBox, JRLineBox srcBox) {
        JRStyleResolver.appendPen(destBox.getPen(), srcBox.getPen());
        JRStyleResolver.appendPen(destBox.getTopPen(), srcBox.getTopPen());
        JRStyleResolver.appendPen(destBox.getLeftPen(), srcBox.getLeftPen());
        JRStyleResolver.appendPen(destBox.getBottomPen(), srcBox.getBottomPen());
        JRStyleResolver.appendPen(destBox.getRightPen(), srcBox.getRightPen());
        if (srcBox.getOwnPadding() != null) {
            destBox.setPadding(srcBox.getOwnPadding());
        }
        if (srcBox.getOwnTopPadding() != null) {
            destBox.setTopPadding(srcBox.getOwnTopPadding());
        }
        if (srcBox.getOwnLeftPadding() != null) {
            destBox.setLeftPadding(srcBox.getOwnLeftPadding());
        }
        if (srcBox.getOwnBottomPadding() != null) {
            destBox.setBottomPadding(srcBox.getOwnBottomPadding());
        }
        if (srcBox.getOwnRightPadding() != null) {
            destBox.setRightPadding(srcBox.getOwnRightPadding());
        }
    }

    public static Color getTitleColor(JRChart chart) {
        Color ownTitleColor = chart.getOwnTitleColor();
        if (ownTitleColor != null) {
            return ownTitleColor;
        }
        return JRStyleResolver.getForecolor(chart);
    }

    public static Color getSubtitleColor(JRChart chart) {
        Color ownSubtitleColor = chart.getOwnSubtitleColor();
        if (ownSubtitleColor != null) {
            return ownSubtitleColor;
        }
        return JRStyleResolver.getForecolor(chart);
    }

    public static Color getLegendColor(JRChart chart) {
        Color ownLegendColor = chart.getOwnLegendColor();
        if (ownLegendColor != null) {
            return ownLegendColor;
        }
        return JRStyleResolver.getForecolor(chart);
    }

    public static Color getLegendBackgroundColor(JRChart chart) {
        Color ownLegendBackgroundColor = chart.getOwnLegendBackgroundColor();
        if (ownLegendBackgroundColor != null) {
            return ownLegendBackgroundColor;
        }
        return JRStyleResolver.getBackcolor(chart);
    }

    public static Color getCategoryAxisLabelColor(JRCategoryAxisFormat axisFormat, JRChartPlot plot) {
        Color ownCategoryAxisLabelColor = axisFormat.getOwnCategoryAxisLabelColor();
        if (ownCategoryAxisLabelColor != null) {
            return ownCategoryAxisLabelColor;
        }
        return JRStyleResolver.getForecolor(plot);
    }

    public static Color getCategoryAxisTickLabelColor(JRCategoryAxisFormat axisFormat, JRChartPlot plot) {
        Color ownCategoryAxisTickLabelColor = axisFormat.getOwnCategoryAxisTickLabelColor();
        if (ownCategoryAxisTickLabelColor != null) {
            return ownCategoryAxisTickLabelColor;
        }
        return JRStyleResolver.getForecolor(plot);
    }

    public static Color getCategoryAxisLineColor(JRCategoryAxisFormat axisFormat, JRChartPlot plot) {
        Color ownCategoryAxisLineColor = axisFormat.getOwnCategoryAxisLineColor();
        if (ownCategoryAxisLineColor != null) {
            return ownCategoryAxisLineColor;
        }
        return JRStyleResolver.getForecolor(plot);
    }

    public static Color getValueAxisLabelColor(JRValueAxisFormat axisFormat, JRChartPlot plot) {
        Color ownValueAxisLabelColor = axisFormat.getOwnValueAxisLabelColor();
        if (ownValueAxisLabelColor != null) {
            return ownValueAxisLabelColor;
        }
        return JRStyleResolver.getForecolor(plot);
    }

    public static Color getValueAxisTickLabelColor(JRValueAxisFormat axisFormat, JRChartPlot plot) {
        Color ownValueAxisTickLabelColor = axisFormat.getOwnValueAxisTickLabelColor();
        if (ownValueAxisTickLabelColor != null) {
            return ownValueAxisTickLabelColor;
        }
        return JRStyleResolver.getForecolor(plot);
    }

    public static Color getValueAxisLineColor(JRValueAxisFormat axisFormat, JRChartPlot plot) {
        Color ownValueAxisLineColor = axisFormat.getOwnValueAxisLineColor();
        if (ownValueAxisLineColor != null) {
            return ownValueAxisLineColor;
        }
        return JRStyleResolver.getForecolor(plot);
    }

    public static Color getXAxisLabelColor(JRXAxisFormat axisFormat, JRChartPlot plot) {
        Color ownXAxisLabelColor = axisFormat.getOwnXAxisLabelColor();
        if (ownXAxisLabelColor != null) {
            return ownXAxisLabelColor;
        }
        return JRStyleResolver.getForecolor(plot);
    }

    public static Color getXAxisTickLabelColor(JRXAxisFormat axisFormat, JRChartPlot plot) {
        Color ownXAxisTickLabelColor = axisFormat.getOwnXAxisTickLabelColor();
        if (ownXAxisTickLabelColor != null) {
            return ownXAxisTickLabelColor;
        }
        return JRStyleResolver.getForecolor(plot);
    }

    public static Color getXAxisLineColor(JRXAxisFormat axisFormat, JRChartPlot plot) {
        Color ownXAxisLineColor = axisFormat.getOwnXAxisLineColor();
        if (ownXAxisLineColor != null) {
            return ownXAxisLineColor;
        }
        return JRStyleResolver.getForecolor(plot);
    }

    public static Color getYAxisLabelColor(JRYAxisFormat axisFormat, JRChartPlot plot) {
        Color ownYAxisLabelColor = axisFormat.getOwnYAxisLabelColor();
        if (ownYAxisLabelColor != null) {
            return ownYAxisLabelColor;
        }
        return JRStyleResolver.getForecolor(plot);
    }

    public static Color getYAxisTickLabelColor(JRYAxisFormat axisFormat, JRChartPlot plot) {
        Color ownYAxisTickLabelColor = axisFormat.getOwnYAxisTickLabelColor();
        if (ownYAxisTickLabelColor != null) {
            return ownYAxisTickLabelColor;
        }
        return JRStyleResolver.getForecolor(plot);
    }

    public static Color getYAxisLineColor(JRYAxisFormat axisFormat, JRChartPlot plot) {
        Color ownYAxisLineColor = axisFormat.getOwnYAxisLineColor();
        if (ownYAxisLineColor != null) {
            return ownYAxisLineColor;
        }
        return JRStyleResolver.getForecolor(plot);
    }

    public static Color getTimeAxisLabelColor(JRTimeAxisFormat axisFormat, JRChartPlot plot) {
        Color ownTimeAxisLabelColor = axisFormat.getOwnTimeAxisLabelColor();
        if (ownTimeAxisLabelColor != null) {
            return ownTimeAxisLabelColor;
        }
        return JRStyleResolver.getForecolor(plot);
    }

    public static Color getTimeAxisTickLabelColor(JRTimeAxisFormat axisFormat, JRChartPlot plot) {
        Color ownTimeAxisTickLabelColor = axisFormat.getOwnTimeAxisTickLabelColor();
        if (ownTimeAxisTickLabelColor != null) {
            return ownTimeAxisTickLabelColor;
        }
        return JRStyleResolver.getForecolor(plot);
    }

    public static Color getTimeAxisLineColor(JRTimeAxisFormat axisFormat, JRChartPlot plot) {
        Color ownTimeAxisLineColor = axisFormat.getOwnTimeAxisLineColor();
        if (ownTimeAxisLineColor != null) {
            return ownTimeAxisLineColor;
        }
        return JRStyleResolver.getForecolor(plot);
    }

    private JRStyleResolver() {
    }
}

