<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * PHP Version 4
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Testing
 * @package    PHPUnit
 * @author     Sebastian Bergmann <sb@sebastian-bergmann.de>
 * @copyright  2002-2005 Sebastian Bergmann <sb@sebastian-bergmann.de>
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id: TestListener.php 4237 2009-11-27 23:17:21Z sigurd $
 * @link       http://pear.php.net/package/PHPUnit
 * @since      File available since Release 1.0.0
 */

/**
 * A Listener for test progress.
 *
 * Here is an example:
 *
 * <code>
 * <?php
 * require_once 'PHPUnit.php';
 * require_once 'PHPUnit/TestListener.php';
 *
 * class MathTest extends PHPUnit_TestCase {
 *     var $fValue1;
 *     var $fValue2;
 *
 *     function MathTest($name) {
 *         $this->PHPUnit_TestCase($name);
 *     }
 *
 *     function setUp() {
 *         $this->fValue1 = 2;
 *         $this->fValue2 = 3;
 *     }
 *
 *     function testAdd() {
 *         $this->assertTrue($this->fValue1 + $this->fValue2 == 4);
 *     }
 * }
 *
 * class MyListener extends PHPUnit_TestListener {
 *     function addError(&$test, &$t) {
 *         print "MyListener::addError() called.\n";
 *     }
 *
 *     function addFailure(&$test, &$t) {
 *         print "MyListener::addFailure() called.\n";
 *     }
 *
 *     function endTest(&$test) {
 *         print "MyListener::endTest() called.\n";
 *     }
 *
 *     function startTest(&$test) {
 *         print "MyListener::startTest() called.\n";
 *     }
 * }
 *
 * $suite = new PHPUnit_TestSuite;
 * $suite->addTest(new MathTest('testAdd'));
 *
 * $result = new PHPUnit_TestResult;
 * $result->addListener(new MyListener);
 *
 * $suite->run($result);
 * print $result->toString();
 * ?>
 * </code>
 *
 * @category   Testing
 * @package    PHPUnit
 * @author     Sebastian Bergmann <sb@sebastian-bergmann.de>
 * @copyright  2002-2005 Sebastian Bergmann <sb@sebastian-bergmann.de>
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    Release: @package_version@
 * @link       http://pear.php.net/package/PHPUnit
 * @since      Class available since Release 1.0.0
 */
class PHPUnit_TestListener {
    /**
     * An error occurred.
     *
     * @param  object
     * @param  object
     * @access public
     * @abstract
     */
    function addError(&$test, &$t) { /*abstract */ }

    /**
     * A failure occurred.
     *
     * @param  object
     * @param  object
     * @access public
     * @abstract
     */
    function addFailure(&$test, &$t) { /*abstract */ }

    /**
     * A test ended.
     *
     * @param  object
     * @access public
     * @abstract
     */
    function endTest(&$test) { /*abstract */ }

    /**
     * A test started.
     *
     * @param  object
     * @access public
     * @abstract
     */
    function startTest(&$test) { /*abstract */ }
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>
