<!-- $Id: unit_select.xsl 6718 2011-01-03 09:29:44Z sigurdne $ -->

	<xsl:template name="unit_select">
		<xsl:variable name="lang_unit_statustext"><xsl:value-of select="lang_unit_statustext"/></xsl:variable>
		<xsl:variable name="select_name"><xsl:value-of select="select_unit"/></xsl:variable>
		<select name="{$select_name}" class="forms" onMouseover="window.status='{$lang_unit_statustext}'; return true;" onMouseout="window.status='';return true;">
			<option value=""><xsl:value-of select="lang_no_unit"/></option>
			<xsl:apply-templates select="unit_list"/>
		</select>
	</xsl:template>

	<xsl:template match="unit_list">
		<xsl:variable name="id"><xsl:value-of select="id"/></xsl:variable>
		<xsl:choose>
			<xsl:when test="selected">
				<option value="{$id}" selected="selected"><xsl:value-of disable-output-escaping="yes" select="name"/></option>
			</xsl:when>
			<xsl:otherwise>
				<option value="{$id}"><xsl:value-of disable-output-escaping="yes" select="name"/></option>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
