/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.Formula;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Property;
import mondrian.olap.Util;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberCacheHelper;
import mondrian.rolap.MemberNoCacheHelper;
import mondrian.rolap.MemberReader;
import mondrian.rolap.NoCacheMemberReader;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SmartMemberReader;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlMemberSource;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.util.UnsupportedList;

public class RolapCubeHierarchy
extends RolapHierarchy {
    private final RolapCubeDimension parentDimension;
    private final RolapHierarchy rolapHierarchy;
    private final RolapCubeLevel currentNullLevel;
    private RolapHierarchy.RolapNullMember currentNullMember;
    private RolapCubeMember currentAllMember;
    private final MondrianDef.RelationOrJoin currentRelation;
    private final RolapCubeHierarchyMemberReader reader;
    private HierarchyUsage usage;
    private final Map<String, String> aliases = new HashMap<String, String>();
    private RolapCubeMember currentDefaultMember;
    protected final boolean usingCubeFact;

    public RolapCubeHierarchy(RolapCubeDimension dimension, MondrianDef.CubeDimension cubeDim, RolapHierarchy rolapHierarchy, String subName) {
        super((RolapDimension)dimension, subName, rolapHierarchy.hasAll());
        if (!dimension.getCube().isVirtual()) {
            this.usage = new HierarchyUsage(dimension.getCube(), rolapHierarchy, cubeDim);
        }
        this.rolapHierarchy = rolapHierarchy;
        this.parentDimension = dimension;
        this.xmlHierarchy = rolapHierarchy.getXmlHierarchy();
        this.currentNullLevel = new RolapCubeLevel(this.nullLevel, this);
        boolean bl = this.usingCubeFact = dimension.getCube().getFact() == null || dimension.getCube().getFact().equals((Object)rolapHierarchy.getRelation());
        if (!this.usingCubeFact) {
            assert (this.usage.getJoinExp() instanceof MondrianDef.Column);
            this.currentRelation = this.parentDimension.getCube().getStar().getUniqueRelation(rolapHierarchy.getRelation(), this.usage.getForeignKey(), ((MondrianDef.Column)this.usage.getJoinExp()).getColumnName(), this.usage.getJoinTable().getAlias());
        } else {
            this.currentRelation = rolapHierarchy.getRelation();
        }
        this.extractNewAliases(rolapHierarchy.getRelation(), this.currentRelation);
        this.relation = this.currentRelation;
        this.levels = new RolapCubeLevel[rolapHierarchy.getLevels().length];
        for (int i = 0; i < rolapHierarchy.getLevels().length; ++i) {
            RolapCubeLevel allLevel;
            this.levels[i] = new RolapCubeLevel((RolapLevel)rolapHierarchy.getLevels()[i], this);
            if (i != 0 || rolapHierarchy.getAllMember() == null) continue;
            if (this.hasAll()) {
                allLevel = (RolapCubeLevel)this.levels[0];
            } else {
                allLevel = new RolapCubeLevel(rolapHierarchy.getAllMember().getLevel(), this);
                allLevel.init(dimension.xmlDimension);
            }
            this.currentAllMember = new RolapCubeMember(null, rolapHierarchy.getAllMember(), allLevel, dimension.getCube());
        }
        this.reader = dimension.isHighCardinality() ? new NoCacheRolapCubeHierarchyMemberReader() : new CacheRolapCubeHierarchyMemberReader();
    }

    public String getAllMemberName() {
        return this.rolapHierarchy.getAllMemberName();
    }

    public String getSharedHierarchyName() {
        return this.rolapHierarchy.getSharedHierarchyName();
    }

    public String getAllLevelName() {
        return this.rolapHierarchy.getAllLevelName();
    }

    public boolean isUsingCubeFact() {
        return this.usingCubeFact;
    }

    public String lookupAlias(String origTable) {
        return this.aliases.get(origTable);
    }

    public RolapCubeDimension getDimension() {
        return (RolapCubeDimension)super.getDimension();
    }

    public RolapHierarchy getRolapHierarchy() {
        return this.rolapHierarchy;
    }

    protected void extractNewAliases(MondrianDef.RelationOrJoin oldrel, MondrianDef.RelationOrJoin newrel) {
        if (oldrel == null && newrel == null) {
            return;
        }
        if (oldrel instanceof MondrianDef.Relation && newrel instanceof MondrianDef.Relation) {
            this.aliases.put(((MondrianDef.Relation)oldrel).getAlias(), ((MondrianDef.Relation)newrel).getAlias());
        } else if (oldrel instanceof MondrianDef.Join && newrel instanceof MondrianDef.Join) {
            MondrianDef.Join oldjoin = (MondrianDef.Join)oldrel;
            MondrianDef.Join newjoin = (MondrianDef.Join)newrel;
            this.extractNewAliases(oldjoin.left, newjoin.left);
            this.extractNewAliases(oldjoin.right, newjoin.right);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RolapCubeHierarchy)) {
            return false;
        }
        RolapCubeHierarchy that = (RolapCubeHierarchy)o;
        return this.parentDimension.equals(that.parentDimension) && this.getUniqueName().equals(that.getUniqueName());
    }

    protected int computeHashCode() {
        return Util.hash(super.computeHashCode(), this.parentDimension.parent);
    }

    public Member createMember(Member parent, Level level, String name, Formula formula) {
        RolapLevel rolapLevel = ((RolapCubeLevel)level).getRolapLevel();
        if (formula == null) {
            RolapMember rolapParent = null;
            if (parent != null) {
                rolapParent = ((RolapCubeMember)parent).getRolapMember();
            }
            RolapMember member = new RolapMember(rolapParent, rolapLevel, name);
            return new RolapCubeMember((RolapCubeMember)parent, member, (RolapCubeLevel)level, this.parentDimension.getCube());
        }
        if (level.getDimension().isMeasures()) {
            RolapHierarchy.RolapCalculatedMeasure member = new RolapHierarchy.RolapCalculatedMeasure((RolapMember)parent, rolapLevel, name, formula);
            return new RolapCubeMember((RolapCubeMember)parent, member, (RolapCubeLevel)level, this.parentDimension.getCube());
        }
        RolapCalculatedMember member = new RolapCalculatedMember((RolapMember)parent, rolapLevel, name, formula);
        return new RolapCubeMember((RolapCubeMember)parent, member, (RolapCubeLevel)level, this.parentDimension.getCube());
    }

    boolean tableExists(String tableName) {
        return this.rolapHierarchy.tableExists(tableName);
    }

    public MondrianDef.RelationOrJoin getRelation() {
        return this.currentRelation;
    }

    public Member getDefaultMember() {
        if (this.currentDefaultMember == null) {
            this.reader.getRootMembers();
            RolapCubeLevel level = (RolapCubeLevel)this.levels[this.rolapHierarchy.getDefaultMember().getDepth()];
            RolapMember rolapDefaultMember = (RolapMember)this.rolapHierarchy.getDefaultMember();
            this.currentDefaultMember = this.reader.lookupCubeMember(this.hasAll() ? this.currentAllMember : null, rolapDefaultMember, level);
        }
        return this.currentDefaultMember;
    }

    public Member getNullMember() {
        if (this.currentNullMember == null) {
            this.currentNullMember = new RolapHierarchy.RolapNullMember(this.currentNullLevel);
        }
        return this.currentNullMember;
    }

    public RolapCubeMember getAllMember() {
        return this.currentAllMember;
    }

    public String getCaption() {
        return this.rolapHierarchy.getCaption();
    }

    public void setCaption(String caption) {
        this.rolapHierarchy.setCaption(caption);
    }

    void setMemberReader(MemberReader memberReader) {
        this.rolapHierarchy.setMemberReader(memberReader);
    }

    MemberReader getMemberReader() {
        return this.reader;
    }

    public void setDefaultMember(Member defaultMeasure) {
        this.rolapHierarchy.setDefaultMember(defaultMeasure);
        RolapCubeLevel level = new RolapCubeLevel((RolapLevel)this.rolapHierarchy.getDefaultMember().getLevel(), this);
        this.currentDefaultMember = new RolapCubeMember(null, (RolapMember)this.rolapHierarchy.getDefaultMember(), level, this.parentDimension.getCube());
    }

    void init(MondrianDef.CubeDimension xmlDimension) {
        this.rolapHierarchy.init(xmlDimension);
        super.init(xmlDimension);
    }

    public static class RolapCubeSqlMemberSource
    extends SqlMemberSource {
        private final RolapCubeHierarchyMemberReader memberReader;
        private final MemberCacheHelper memberSourceCacheHelper;
        private final Object memberCacheLock;

        public RolapCubeSqlMemberSource(RolapCubeHierarchyMemberReader memberReader, RolapCubeHierarchy hierarchy, MemberCacheHelper memberSourceCacheHelper, Object memberCacheLock) {
            super(hierarchy);
            this.memberReader = memberReader;
            this.memberSourceCacheHelper = memberSourceCacheHelper;
            this.memberCacheLock = memberCacheLock;
        }

        public RolapMember makeMember(RolapMember parentMember, RolapLevel childLevel, Object value, Object captionValue, boolean parentChild, ResultSet resultSet, Object key, int columnOffset) throws SQLException {
            RolapMember parent = null;
            if (parentMember != null) {
                parent = ((RolapCubeMember)parentMember).getRolapMember();
            }
            RolapMember member = super.makeMember(parent, ((RolapCubeLevel)childLevel).getRolapLevel(), value, captionValue, parentChild, resultSet, key, columnOffset);
            return this.memberReader.lookupCubeMember((RolapCubeMember)parentMember, member, (RolapCubeLevel)childLevel);
        }

        public MemberCache getMemberCache() {
            return this.memberSourceCacheHelper;
        }

        public Object getMemberCacheLock() {
            return this.memberCacheLock;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NoCacheRolapCubeHierarchyMemberReader
    extends NoCacheMemberReader
    implements RolapCubeHierarchyMemberReader {
        protected final RolapCubeSqlMemberSource cubeSource;
        protected MemberCacheHelper rolapCubeCacheHelper;

        public NoCacheRolapCubeHierarchyMemberReader() {
            super(new SqlMemberSource(RolapCubeHierarchy.this));
            this.rolapCubeCacheHelper = new MemberNoCacheHelper();
            this.cubeSource = new RolapCubeSqlMemberSource(this, RolapCubeHierarchy.this, this.rolapCubeCacheHelper, new MemberNoCacheHelper());
            this.cubeSource.setCache(this.rolapCubeCacheHelper);
        }

        @Override
        public TupleReader.MemberBuilder getMemberBuilder() {
            return this.cubeSource;
        }

        @Override
        public MemberCacheHelper getRolapCubeMemberCacheHelper() {
            return this.rolapCubeCacheHelper;
        }

        @Override
        public List<RolapMember> getRootMembers() {
            return this.getMembersInLevel((RolapCubeLevel)RolapCubeHierarchy.this.getLevels()[0], 0, Integer.MAX_VALUE);
        }

        private String getUniqueNameForMemberWithoutHierarchy(RolapMember member) {
            String name = (String)member.getPropertyValue(Property.UNIQUE_NAME_WITHOUT_HIERARCHY.getName());
            if (name == null) {
                StringBuilder fullName = new StringBuilder();
                for (RolapMember parent = member; parent != null; parent = parent.getParentMember()) {
                    fullName.append("[").append(parent.getName()).append("]");
                }
                name = fullName.toString();
                member.setProperty(Property.UNIQUE_NAME_WITHOUT_HIERARCHY.getName(), name);
            }
            return name;
        }

        @Override
        protected void readMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
            ArrayList<RolapMember> rolapChildren = new ArrayList<RolapMember>();
            ArrayList<RolapMember> rolapParents = new ArrayList<RolapMember>();
            HashMap<String, RolapCubeMember> lookup = new HashMap<String, RolapCubeMember>();
            List<RolapCubeMember> parentRolapCubeMemberList = Util.cast(parentMembers);
            for (RolapCubeMember member : parentRolapCubeMemberList) {
                lookup.put(this.getUniqueNameForMemberWithoutHierarchy(member.getRolapMember()), member);
                rolapParents.add(member.getRolapMember());
            }
            boolean joinReq = constraint instanceof SqlContextConstraint;
            if (joinReq) {
                super.readMemberChildren(parentMembers, rolapChildren, constraint);
            } else {
                RolapCubeHierarchy.this.rolapHierarchy.getMemberReader().getMemberChildren(rolapParents, rolapChildren, constraint);
            }
            for (RolapMember currMember : rolapChildren) {
                RolapCubeMember parent = (RolapCubeMember)lookup.get(this.getUniqueNameForMemberWithoutHierarchy(currMember.getParentMember()));
                RolapCubeLevel level = parent.getLevel().getChildLevel();
                if (level == null) {
                    level = parent.getLevel();
                }
                RolapCubeMember newmember = this.lookupCubeMember(parent, currMember, level);
                children.add(newmember);
            }
            HashMap tempMap = new HashMap();
            for (RolapMember member1 : parentMembers) {
                tempMap.put(member1, Collections.emptyList());
            }
            for (RolapMember child : children) {
                assert (child != null) : "child";
                RolapMember parentMember = child.getParentMember();
            }
        }

        @Override
        public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
            ArrayList<RolapMember> missed = new ArrayList<RolapMember>();
            for (RolapMember parentMember : parentMembers) {
                Collection list = null;
                if (list == null) {
                    if (parentMember.isNull()) continue;
                    missed.add(parentMember);
                    continue;
                }
                children.addAll(list);
            }
            if (missed.size() > 0) {
                this.readMemberChildren(missed, children, constraint);
            }
        }

        @Override
        public List<RolapMember> getMembersInLevel(final RolapLevel level, int startOrdinal, int endOrdinal, TupleConstraint constraint) {
            Object members = null;
            boolean joinReq = constraint instanceof SqlContextConstraint;
            final List<RolapMember> list = !joinReq ? RolapCubeHierarchy.this.rolapHierarchy.getMemberReader().getMembersInLevel(((RolapCubeLevel)level).getRolapLevel(), startOrdinal, endOrdinal, constraint) : super.getMembersInLevel(level, startOrdinal, endOrdinal, constraint);
            return new UnsupportedList<RolapMember>(){

                @Override
                public RolapMember get(int index) {
                    return this.mutate((RolapMember)list.get(index));
                }

                @Override
                public int size() {
                    return list.size();
                }

                @Override
                public Iterator<RolapMember> iterator() {
                    final Iterator it = list.iterator();
                    return new Iterator<RolapMember>(){

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        @Override
                        public RolapMember next() {
                            return this.mutate((RolapMember)it.next());
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                private RolapMember mutate(RolapMember member) {
                    RolapCubeMember parent = null;
                    if (member.getParentMember() != null) {
                        parent = NoCacheRolapCubeHierarchyMemberReader.this.createAncestorMembers((RolapCubeLevel)level.getParentLevel(), member.getParentMember());
                    }
                    return NoCacheRolapCubeHierarchyMemberReader.this.lookupCubeMember(parent, member, (RolapCubeLevel)level);
                }
            };
        }

        private RolapCubeMember createAncestorMembers(RolapCubeLevel level, RolapMember member) {
            RolapCubeMember parent = null;
            if (member.getParentMember() != null) {
                parent = this.createAncestorMembers(level.getParentLevel(), member.getParentMember());
            }
            return this.lookupCubeMember(parent, member, level);
        }

        @Override
        public RolapCubeMember lookupCubeMember(RolapCubeMember parent, RolapMember member, RolapCubeLevel level) {
            if (member.getKey() == null) {
                if (member.isAll()) {
                    return RolapCubeHierarchy.this.getAllMember();
                }
                throw new NullPointerException();
            }
            RolapCubeMember cubeMember = new RolapCubeMember(parent, member, level, RolapCubeHierarchy.this.parentDimension.getCube());
            return cubeMember;
        }

        @Override
        public int getMemberCount() {
            return RolapCubeHierarchy.this.rolapHierarchy.getMemberReader().getMemberCount();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CacheRolapCubeHierarchyMemberReader
    extends SmartMemberReader
    implements RolapCubeHierarchyMemberReader {
        protected final RolapCubeSqlMemberSource cubeSource;
        protected MemberCacheHelper rolapCubeCacheHelper;
        private final boolean enableCache;

        public CacheRolapCubeHierarchyMemberReader() {
            super(new SqlMemberSource(RolapCubeHierarchy.this));
            this.enableCache = MondrianProperties.instance().EnableRolapCubeMemberCache.get();
            this.rolapCubeCacheHelper = new MemberCacheHelper(RolapCubeHierarchy.this);
            this.cubeSource = new RolapCubeSqlMemberSource(this, RolapCubeHierarchy.this, this.rolapCubeCacheHelper, this.cacheHelper);
            this.cubeSource.setCache(this.getMemberCache());
        }

        @Override
        public TupleReader.MemberBuilder getMemberBuilder() {
            return this.cubeSource;
        }

        @Override
        public MemberCacheHelper getRolapCubeMemberCacheHelper() {
            return this.rolapCubeCacheHelper;
        }

        @Override
        public List<RolapMember> getRootMembers() {
            if (this.rootMembers == null) {
                this.rootMembers = this.getMembersInLevel((RolapCubeLevel)RolapCubeHierarchy.this.getLevels()[0], 0, Integer.MAX_VALUE);
            }
            return this.rootMembers;
        }

        private String getUniqueNameForMemberWithoutHierarchy(RolapMember member) {
            String name = (String)member.getPropertyValue(Property.UNIQUE_NAME_WITHOUT_HIERARCHY.getName());
            if (name == null) {
                StringBuilder fullName = new StringBuilder();
                for (RolapMember parent = member; parent != null; parent = parent.getParentMember()) {
                    fullName.append("[").append(parent.getName()).append("]");
                }
                name = fullName.toString();
                member.setProperty(Property.UNIQUE_NAME_WITHOUT_HIERARCHY.getName(), name);
            }
            return name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
            ArrayList<RolapMember> rolapChildren = new ArrayList<RolapMember>();
            ArrayList<RolapMember> rolapParents = new ArrayList<RolapMember>();
            HashMap<String, RolapCubeMember> lookup = new HashMap<String, RolapCubeMember>();
            List<RolapCubeMember> parentRolapCubeMemberList = Util.cast(parentMembers);
            for (RolapCubeMember member : parentRolapCubeMemberList) {
                lookup.put(this.getUniqueNameForMemberWithoutHierarchy(member.getRolapMember()), member);
                rolapParents.add(member.getRolapMember());
            }
            boolean joinReq = constraint instanceof SqlContextConstraint;
            if (joinReq) {
                super.readMemberChildren(parentMembers, rolapChildren, constraint);
            } else {
                RolapCubeHierarchy.this.rolapHierarchy.getMemberReader().getMemberChildren(rolapParents, rolapChildren, constraint);
            }
            for (RolapMember currMember : rolapChildren) {
                RolapCubeMember parent = (RolapCubeMember)lookup.get(this.getUniqueNameForMemberWithoutHierarchy(currMember.getParentMember()));
                RolapCubeLevel level = parent.getLevel().getChildLevel();
                if (level == null) {
                    level = parent.getLevel();
                }
                RolapCubeMember newmember = this.lookupCubeMember(parent, currMember, level);
                children.add(newmember);
            }
            HashMap<RolapMember, List<Object>> tempMap = new HashMap<RolapMember, List<Object>>();
            for (RolapMember member1 : parentMembers) {
                tempMap.put(member1, Collections.emptyList());
            }
            for (RolapMember child : children) {
                assert (child != null) : "child";
                RolapMember parentMember = child.getParentMember();
                ArrayList<RolapMember> cacheList = (ArrayList<RolapMember>)tempMap.get(parentMember);
                if (cacheList == null) continue;
                if (cacheList == Collections.EMPTY_LIST) {
                    cacheList = new ArrayList<RolapMember>();
                    tempMap.put(parentMember, cacheList);
                }
                cacheList.add(child);
            }
            MemberCacheHelper memberCacheHelper = this.cacheHelper;
            synchronized (memberCacheHelper) {
                for (Map.Entry entry : tempMap.entrySet()) {
                    RolapMember member = (RolapMember)entry.getKey();
                    if (this.rolapCubeCacheHelper.getChildrenFromCache(member, constraint) != null) continue;
                    List cacheList = (List)entry.getValue();
                    if (!this.enableCache) continue;
                    this.rolapCubeCacheHelper.putChildren(member, constraint, cacheList);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
            MemberCacheHelper memberCacheHelper = this.cacheHelper;
            synchronized (memberCacheHelper) {
                this.checkCacheStatus();
                ArrayList<RolapMember> missed = new ArrayList<RolapMember>();
                for (RolapMember parentMember : parentMembers) {
                    List<RolapMember> list = this.rolapCubeCacheHelper.getChildrenFromCache(parentMember, constraint);
                    if (list == null) {
                        if (parentMember.isNull()) continue;
                        missed.add(parentMember);
                        continue;
                    }
                    children.addAll(list);
                }
                if (missed.size() > 0) {
                    this.readMemberChildren(missed, children, constraint);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<RolapMember> getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal, TupleConstraint constraint) {
            MemberCacheHelper memberCacheHelper = this.cacheHelper;
            synchronized (memberCacheHelper) {
                this.checkCacheStatus();
                List<RolapMember> members = this.rolapCubeCacheHelper.getLevelMembersFromCache(level, constraint);
                if (members != null) {
                    return members;
                }
                boolean joinReq = constraint instanceof SqlContextConstraint;
                RolapCubeLevel cubeLevel = (RolapCubeLevel)level;
                List<RolapMember> list = !joinReq ? RolapCubeHierarchy.this.rolapHierarchy.getMemberReader().getMembersInLevel(cubeLevel.getRolapLevel(), startOrdinal, endOrdinal, constraint) : super.getMembersInLevel(level, startOrdinal, endOrdinal, constraint);
                ArrayList<RolapMember> newlist = new ArrayList<RolapMember>();
                for (RolapMember member : list) {
                    RolapCubeMember parent = null;
                    if (member.getParentMember() != null) {
                        parent = this.createAncestorMembers(cubeLevel.getParentLevel(), member.getParentMember());
                    }
                    RolapCubeMember newmember = this.lookupCubeMember(parent, member, cubeLevel);
                    newlist.add(newmember);
                }
                this.rolapCubeCacheHelper.putLevelMembersInCache(level, constraint, newlist);
                return newlist;
            }
        }

        private RolapCubeMember createAncestorMembers(RolapCubeLevel level, RolapMember member) {
            RolapCubeMember parent = null;
            RolapMember parentMember = member.getParentMember();
            if (parentMember != null) {
                RolapCubeLevel parentLevel = parentMember.getLevel() == member.getLevel() ? level : level.getParentLevel();
                parent = this.createAncestorMembers(parentLevel, parentMember);
            }
            return this.lookupCubeMember(parent, member, level);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RolapCubeMember lookupCubeMember(RolapCubeMember parent, RolapMember member, RolapCubeLevel level) {
            MemberCacheHelper memberCacheHelper = this.cacheHelper;
            synchronized (memberCacheHelper) {
                RolapCubeMember cubeMember;
                if (member.getKey() == null) {
                    if (member.isAll()) {
                        return RolapCubeHierarchy.this.getAllMember();
                    }
                    throw new NullPointerException();
                }
                if (this.enableCache) {
                    Object key = this.rolapCubeCacheHelper.makeKey(parent, member.getKey());
                    cubeMember = (RolapCubeMember)this.rolapCubeCacheHelper.getMember(key, false);
                    if (cubeMember == null) {
                        cubeMember = new RolapCubeMember(parent, member, level, RolapCubeHierarchy.this.parentDimension.getCube());
                        this.rolapCubeCacheHelper.putMember(key, cubeMember);
                    }
                } else {
                    cubeMember = new RolapCubeMember(parent, member, level, RolapCubeHierarchy.this.parentDimension.getCube());
                }
                return cubeMember;
            }
        }

        @Override
        public int getMemberCount() {
            return RolapCubeHierarchy.this.rolapHierarchy.getMemberReader().getMemberCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void checkCacheStatus() {
            MemberCacheHelper memberCacheHelper = this.cacheHelper;
            synchronized (memberCacheHelper) {
                if (this.cacheHelper.getChangeListener() != null && this.cacheHelper.getChangeListener().isHierarchyChanged(this.getHierarchy())) {
                    SmartMemberReader smartMemberReader;
                    this.cacheHelper.flushCache();
                    this.rolapCubeCacheHelper.flushCache();
                    if (RolapCubeHierarchy.this.rolapHierarchy.getMemberReader() instanceof SmartMemberReader && (smartMemberReader = (SmartMemberReader)RolapCubeHierarchy.this.rolapHierarchy.getMemberReader()).getMemberCache() instanceof MemberCacheHelper) {
                        MemberCacheHelper helper = (MemberCacheHelper)smartMemberReader.getMemberCache();
                        helper.flushCache();
                    }
                }
            }
        }
    }

    public static interface RolapCubeHierarchyMemberReader
    extends MemberReader {
        public RolapCubeMember lookupCubeMember(RolapCubeMember var1, RolapMember var2, RolapCubeLevel var3);

        public MemberCacheHelper getRolapCubeMemberCacheHelper();
    }
}

