/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRAlignment;
import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBaseParagraph;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.TextFormat;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.ObjectUtils;

public class JRTemplateText
extends JRTemplateElement
implements JRAlignment,
JRFont,
JRCommonText,
TextFormat {
    private static final long serialVersionUID = 10200L;
    private HorizontalAlignEnum horizontalAlignmentValue;
    private VerticalAlignEnum verticalAlignmentValue;
    private RotationEnum rotationValue;
    private String markup;
    private String linkType;
    private String linkTarget;
    protected JRLineBox lineBox;
    protected JRParagraph paragraph;
    protected String fontName;
    protected Boolean isBold;
    protected Boolean isItalic;
    protected Boolean isUnderline;
    protected Boolean isStrikeThrough;
    protected Integer fontSize;
    protected String pdfFontName;
    protected String pdfEncoding;
    protected Boolean isPdfEmbedded;
    protected String valueClassName;
    protected String pattern;
    protected String formatFactoryClass;
    protected String localeCode;
    protected String timeZoneId;
    private int PSEUDO_SERIAL_VERSION_UID = 50004;
    private Byte horizontalAlignment;
    private Byte verticalAlignment;
    private Byte rotation;
    private Byte lineSpacing;
    private LineSpacingEnum lineSpacingValue;
    private Byte border;
    private Byte topBorder;
    private Byte leftBorder;
    private Byte bottomBorder;
    private Byte rightBorder;
    private Color borderColor;
    private Color topBorderColor;
    private Color leftBorderColor;
    private Color bottomBorderColor;
    private Color rightBorderColor;
    private Integer padding;
    private Integer topPadding;
    private Integer leftPadding;
    private Integer bottomPadding;
    private Integer rightPadding;
    private Boolean isStyledText;
    private byte hyperlinkType;
    private byte hyperlinkTarget;

    protected JRTemplateText(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRStaticText staticText) {
        super(origin, defaultStyleProvider);
        this.setStaticText(staticText);
    }

    protected JRTemplateText(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRTextField textField) {
        super(origin, defaultStyleProvider);
        this.setTextField(textField);
    }

    public JRTemplateText(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider) {
        super(origin, defaultStyleProvider);
        this.lineBox = new JRBaseLineBox(this);
        this.paragraph = new JRBaseParagraph(this);
    }

    protected void setStaticText(JRStaticText staticText) {
        this.setTextElement(staticText);
    }

    protected void setTextField(JRTextField textField) {
        this.setTextElement(textField);
        this.setLinkType(textField.getLinkType());
        this.setLinkTarget(textField.getLinkTarget());
    }

    protected void setTextElement(JRTextElement textElement) {
        super.setElement(textElement);
        this.fontName = textElement.getOwnFontName();
        this.isBold = textElement.isOwnBold();
        this.isItalic = textElement.isOwnItalic();
        this.isUnderline = textElement.isOwnUnderline();
        this.isStrikeThrough = textElement.isOwnStrikeThrough();
        this.fontSize = textElement.getOwnFontSize();
        this.pdfFontName = textElement.getOwnPdfFontName();
        this.pdfEncoding = textElement.getOwnPdfEncoding();
        this.isPdfEmbedded = textElement.isOwnPdfEmbedded();
        this.horizontalAlignmentValue = textElement.getOwnHorizontalAlignmentValue();
        this.verticalAlignmentValue = textElement.getOwnVerticalAlignmentValue();
        this.rotationValue = textElement.getOwnRotationValue();
        this.markup = textElement.getOwnMarkup();
    }

    public void setTextFormat(TextFormat textFormat) {
        if (textFormat != null) {
            this.setValueClassName(textFormat.getValueClassName());
            this.setPattern(textFormat.getPattern());
            this.setFormatFactoryClass(textFormat.getFormatFactoryClass());
            this.setLocaleCode(textFormat.getLocaleCode());
            this.setTimeZoneId(textFormat.getTimeZoneId());
        }
    }

    public void copyLineBox(JRLineBox box) {
        this.lineBox = box.clone(this);
    }

    public void copyParagraph(JRParagraph prg) {
        this.paragraph = prg.clone(this);
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public HorizontalAlignEnum getHorizontalAlignmentValue() {
        return JRStyleResolver.getHorizontalAlignmentValue(this);
    }

    @Override
    public HorizontalAlignEnum getOwnHorizontalAlignmentValue() {
        return this.horizontalAlignmentValue;
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignEnum horizontalAlignmentValue) {
        this.horizontalAlignmentValue = horizontalAlignmentValue;
    }

    @Override
    public VerticalAlignEnum getVerticalAlignmentValue() {
        return JRStyleResolver.getVerticalAlignmentValue(this);
    }

    @Override
    public VerticalAlignEnum getOwnVerticalAlignmentValue() {
        return this.verticalAlignmentValue;
    }

    @Override
    public void setVerticalAlignment(VerticalAlignEnum verticalAlignmentValue) {
        this.verticalAlignmentValue = verticalAlignmentValue;
    }

    @Override
    public RotationEnum getRotationValue() {
        return JRStyleResolver.getRotationValue(this);
    }

    @Override
    public RotationEnum getOwnRotationValue() {
        return this.rotationValue;
    }

    @Override
    public void setRotation(RotationEnum rotationValue) {
        this.rotationValue = rotationValue;
    }

    @Override
    public LineSpacingEnum getLineSpacingValue() {
        return this.getParagraph().getLineSpacing();
    }

    @Override
    public LineSpacingEnum getOwnLineSpacingValue() {
        return this.getParagraph().getOwnLineSpacing();
    }

    @Override
    public void setLineSpacing(LineSpacingEnum lineSpacing) {
        this.getParagraph().setLineSpacing(lineSpacing);
    }

    @Override
    public String getMarkup() {
        return JRStyleResolver.getMarkup(this);
    }

    @Override
    public String getOwnMarkup() {
        return this.markup;
    }

    @Override
    public void setMarkup(String markup) {
        this.markup = markup;
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public JRParagraph getParagraph() {
        return this.paragraph;
    }

    public JRFont getFont() {
        return this;
    }

    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this.getLinkType());
    }

    public byte getHyperlinkTarget() {
        return this.getHyperlinkTargetValue().getValue();
    }

    public HyperlinkTargetEnum getHyperlinkTargetValue() {
        return JRHyperlinkHelper.getHyperlinkTargetValue(this.getLinkTarget());
    }

    @Override
    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    @Override
    public String getOwnFontName() {
        return this.fontName;
    }

    @Override
    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    @Override
    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    @Override
    public Boolean isOwnBold() {
        return this.isBold;
    }

    @Override
    public void setBold(boolean isBold) {
        this.setBold(isBold ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setBold(Boolean isBold) {
        this.isBold = isBold;
    }

    @Override
    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    @Override
    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    @Override
    public void setItalic(boolean isItalic) {
        this.setItalic(isItalic ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setItalic(Boolean isItalic) {
        this.isItalic = isItalic;
    }

    @Override
    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    @Override
    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    @Override
    public void setUnderline(boolean isUnderline) {
        this.setUnderline(isUnderline ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setUnderline(Boolean isUnderline) {
        this.isUnderline = isUnderline;
    }

    @Override
    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    @Override
    public void setStrikeThrough(boolean isStrikeThrough) {
        this.setStrikeThrough(isStrikeThrough ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setStrikeThrough(Boolean isStrikeThrough) {
        this.isStrikeThrough = isStrikeThrough;
    }

    @Override
    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    @Override
    public Integer getOwnFontSize() {
        return this.fontSize;
    }

    @Override
    public void setFontSize(int fontSize) {
        this.setFontSize((Integer)fontSize);
    }

    @Override
    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    @Override
    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    @Override
    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    @Override
    public void setPdfFontName(String pdfFontName) {
        this.pdfFontName = pdfFontName;
    }

    @Override
    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    @Override
    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    @Override
    public void setPdfEncoding(String pdfEncoding) {
        this.pdfEncoding = pdfEncoding;
    }

    @Override
    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    @Override
    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        this.isPdfEmbedded = isPdfEmbedded;
    }

    @Override
    public JRStyle getStyle() {
        return this.parentStyle;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String getValueClassName() {
        return this.valueClassName;
    }

    public void setValueClassName(String valueClassName) {
        this.valueClassName = valueClassName;
    }

    @Override
    public String getFormatFactoryClass() {
        return this.formatFactoryClass;
    }

    public void setFormatFactoryClass(String formatFactoryClass) {
        this.formatFactoryClass = formatFactoryClass;
    }

    @Override
    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String localeCode) {
        this.localeCode = localeCode;
    }

    @Override
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    protected void setLinkTarget(String linkTarget) {
        this.linkTarget = linkTarget;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.horizontalAlignmentValue = HorizontalAlignEnum.getByValue(this.horizontalAlignment);
            this.verticalAlignmentValue = VerticalAlignEnum.getByValue(this.verticalAlignment);
            this.rotationValue = RotationEnum.getByValue(this.rotation);
            this.lineSpacingValue = LineSpacingEnum.getByValue(this.lineSpacing);
            this.horizontalAlignment = null;
            this.verticalAlignment = null;
            this.rotation = null;
            this.lineSpacing = null;
        }
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox((Byte)this.border, (Byte)this.topBorder, (Byte)this.leftBorder, (Byte)this.bottomBorder, (Byte)this.rightBorder, (Color)this.borderColor, (Color)this.topBorderColor, (Color)this.leftBorderColor, (Color)this.bottomBorderColor, (Color)this.rightBorderColor, (Integer)this.padding, (Integer)this.topPadding, (Integer)this.leftPadding, (Integer)this.bottomPadding, (Integer)this.rightPadding, (JRLineBox)this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        if (this.isStyledText != null) {
            this.markup = this.isStyledText != false ? "styled" : "none";
            this.isStyledText = null;
        }
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(HyperlinkTypeEnum.getByValue(this.hyperlinkType));
        }
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
        if (this.paragraph == null) {
            this.paragraph = new JRBaseParagraph(this);
            this.paragraph.setLineSpacing(this.lineSpacingValue);
            this.lineSpacingValue = null;
        }
    }

    @Override
    public int getHashCode() {
        ObjectUtils.HashCode hash = ObjectUtils.hash();
        this.addTemplateHash(hash);
        hash.add(this.horizontalAlignmentValue);
        hash.add(this.verticalAlignmentValue);
        hash.add(this.rotationValue);
        hash.add(this.markup);
        hash.add(this.linkType);
        hash.add(this.linkTarget);
        hash.addIdentical(this.lineBox);
        hash.addIdentical(this.paragraph);
        hash.add(this.fontName);
        hash.add(this.isBold);
        hash.add(this.isItalic);
        hash.add(this.isUnderline);
        hash.add(this.isStrikeThrough);
        hash.add(this.fontSize);
        hash.add(this.pdfFontName);
        hash.add(this.pdfEncoding);
        hash.add(this.isPdfEmbedded);
        hash.add(this.valueClassName);
        hash.add(this.pattern);
        hash.add(this.formatFactoryClass);
        hash.add(this.localeCode);
        hash.add(this.timeZoneId);
        return hash.getHashCode();
    }

    @Override
    public boolean isIdentical(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JRTemplateText)) {
            return false;
        }
        JRTemplateText template = (JRTemplateText)object;
        return this.templateIdentical(template) && ObjectUtils.equals(this.horizontalAlignmentValue, template.horizontalAlignmentValue) && ObjectUtils.equals(this.verticalAlignmentValue, template.verticalAlignmentValue) && ObjectUtils.equals(this.rotationValue, template.rotationValue) && ObjectUtils.equals(this.markup, template.markup) && ObjectUtils.equals(this.linkType, template.linkType) && ObjectUtils.equals(this.linkTarget, template.linkTarget) && ObjectUtils.identical(this.lineBox, template.lineBox) && ObjectUtils.identical(this.paragraph, template.paragraph) && ObjectUtils.equals(this.fontName, template.fontName) && ObjectUtils.equals(this.isBold, template.isBold) && ObjectUtils.equals(this.isItalic, template.isItalic) && ObjectUtils.equals(this.isUnderline, template.isUnderline) && ObjectUtils.equals(this.isStrikeThrough, template.isStrikeThrough) && ObjectUtils.equals(this.fontSize, template.fontSize) && ObjectUtils.equals(this.pdfFontName, template.pdfFontName) && ObjectUtils.equals(this.pdfEncoding, template.pdfEncoding) && ObjectUtils.equals(this.isPdfEmbedded, template.isPdfEmbedded) && ObjectUtils.equals(this.valueClassName, template.valueClassName) && ObjectUtils.equals(this.pattern, template.pattern) && ObjectUtils.equals(this.formatFactoryClass, template.formatFactoryClass) && ObjectUtils.equals(this.localeCode, template.localeCode) && ObjectUtils.equals(this.timeZoneId, template.timeZoneId);
    }
}

