/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.repo.InputStreamResource;
import net.sf.jasperreports.repo.ObjectResource;
import net.sf.jasperreports.repo.OutputStreamResource;
import net.sf.jasperreports.repo.PersistenceService;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;

public class SerializedObjectPersistenceService
implements PersistenceService {
    @Override
    public Resource load(String uri, RepositoryService repositoryService) {
        InputStream is;
        ObjectResource resource = null;
        InputStreamResource isResource = repositoryService.getResource(uri, InputStreamResource.class);
        InputStream inputStream = is = isResource == null ? null : isResource.getInputStream();
        if (is != null) {
            resource = new ObjectResource();
            try {
                resource.setValue(JRLoader.loadObject(is));
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return resource;
    }

    @Override
    public void save(Resource resource, String uri, RepositoryService repositoryService) {
        OutputStream os;
        ObjectResource objectResource = (ObjectResource)resource;
        OutputStreamResource osResource = repositoryService.getResource(uri, OutputStreamResource.class);
        OutputStream outputStream = os = osResource == null ? null : osResource.getOutputStream();
        if (os != null) {
            try {
                JRSaver.saveObject(objectResource.getValue(), os);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

