/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.legacy.BorderOffset;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.util.JRPenUtil;

public abstract class ElementDrawer<T extends JRPrintElement> {
    private final JasperReportsContext jasperReportsContext;

    public ElementDrawer() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public ElementDrawer(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    public abstract void draw(Graphics2D var1, T var2, int var3, int var4) throws JRException;

    protected void drawBox(Graphics2D grx, JRLineBox box, JRPrintElement element, int offsetX, int offsetY) {
        this.drawTopPen(grx, box.getTopPen(), box.getLeftPen(), box.getRightPen(), element, offsetX, offsetY);
        this.drawLeftPen(grx, box.getTopPen(), box.getLeftPen(), box.getBottomPen(), element, offsetX, offsetY);
        this.drawBottomPen(grx, box.getLeftPen(), box.getBottomPen(), box.getRightPen(), element, offsetX, offsetY);
        this.drawRightPen(grx, box.getTopPen(), box.getBottomPen(), box.getRightPen(), element, offsetX, offsetY);
    }

    protected void drawPen(Graphics2D grx, JRPen pen, JRPrintElement element, int offsetX, int offsetY) {
        this.drawTopPen(grx, pen, pen, pen, element, offsetX, offsetY);
        this.drawLeftPen(grx, pen, pen, pen, element, offsetX, offsetY);
        this.drawBottomPen(grx, pen, pen, pen, element, offsetX, offsetY);
        this.drawRightPen(grx, pen, pen, pen, element, offsetX, offsetY);
    }

    protected void drawTopPen(Graphics2D grx, JRPen topPen, JRPen leftPen, JRPen rightPen, JRPrintElement element, int offsetX, int offsetY) {
        Stroke topStroke = JRPenUtil.getStroke(topPen, 0);
        int width = element.getWidth();
        float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(leftPen);
        float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(rightPen);
        if (topStroke != null && width > 0) {
            grx.setStroke(topStroke);
            grx.setColor(topPen.getLineColor());
            AffineTransform oldTx = grx.getTransform();
            if (topPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float topPenWidth = topPen.getLineWidth().floatValue();
                grx.translate((float)(element.getX() + offsetX) - leftOffset, (float)(element.getY() + offsetY) - topPenWidth / 3.0f);
                grx.scale(((float)width + leftOffset + rightOffset) / (float)width, 1.0);
                grx.drawLine(0, 0, width, 0);
                grx.setTransform(oldTx);
                grx.translate((float)(element.getX() + offsetX) + leftOffset / 3.0f, (float)(element.getY() + offsetY) + topPenWidth / 3.0f);
                if ((float)width > (leftOffset + rightOffset) / 3.0f) {
                    grx.scale(((float)width - (leftOffset + rightOffset) / 3.0f) / (float)width, 1.0);
                }
                grx.drawLine(0, 0, width, 0);
            } else {
                grx.translate((float)(element.getX() + offsetX) - leftOffset, (float)(element.getY() + offsetY) + BorderOffset.getOffset(topPen));
                grx.scale(((float)width + leftOffset + rightOffset) / (float)width, 1.0);
                grx.drawLine(0, 0, width, 0);
            }
            grx.setTransform(oldTx);
        }
    }

    protected void drawLeftPen(Graphics2D grx, JRPen topPen, JRPen leftPen, JRPen bottomPen, JRPrintElement element, int offsetX, int offsetY) {
        Stroke leftStroke = JRPenUtil.getStroke(leftPen, 0);
        int height = element.getHeight();
        float topOffset = topPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(topPen);
        float bottomOffset = bottomPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(bottomPen);
        if (leftStroke != null && height > 0) {
            grx.setStroke(leftStroke);
            grx.setColor(leftPen.getLineColor());
            AffineTransform oldTx = grx.getTransform();
            if (leftPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float leftPenWidth = leftPen.getLineWidth().floatValue();
                grx.translate((float)(element.getX() + offsetX) - leftPenWidth / 3.0f, (float)(element.getY() + offsetY) - topOffset);
                grx.scale(1.0, ((float)height + (topOffset + bottomOffset)) / (float)height);
                grx.drawLine(0, 0, 0, height);
                grx.setTransform(oldTx);
                grx.translate((float)(element.getX() + offsetX) + leftPenWidth / 3.0f, (float)(element.getY() + offsetY) + topOffset / 3.0f);
                if ((float)height > (topOffset + bottomOffset) / 3.0f) {
                    grx.scale(1.0, ((float)height - (topOffset + bottomOffset) / 3.0f) / (float)height);
                }
                grx.drawLine(0, 0, 0, height);
            } else {
                grx.translate((float)(element.getX() + offsetX) + BorderOffset.getOffset(leftPen), (float)(element.getY() + offsetY) - topOffset);
                grx.scale(1.0, ((float)height + topOffset + bottomOffset) / (float)height);
                grx.drawLine(0, 0, 0, height);
            }
            grx.setTransform(oldTx);
        }
    }

    protected void drawBottomPen(Graphics2D grx, JRPen leftPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element, int offsetX, int offsetY) {
        Stroke bottomStroke = JRPenUtil.getStroke(bottomPen, 0);
        int width = element.getWidth();
        int height = element.getHeight();
        float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(leftPen);
        float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(rightPen);
        if (bottomStroke != null && width > 0) {
            grx.setStroke(bottomStroke);
            grx.setColor(bottomPen.getLineColor());
            AffineTransform oldTx = grx.getTransform();
            if (bottomPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float bottomPenWidth = bottomPen.getLineWidth().floatValue();
                grx.translate((float)(element.getX() + offsetX) - leftOffset, (float)(element.getY() + offsetY + height) + bottomPenWidth / 3.0f);
                grx.scale(((float)width + leftOffset + rightOffset) / (float)width, 1.0);
                grx.drawLine(0, 0, width, 0);
                grx.setTransform(oldTx);
                grx.translate((float)(element.getX() + offsetX) + leftOffset / 3.0f, (float)(element.getY() + offsetY + height) - bottomPenWidth / 3.0f);
                if ((float)width > (leftOffset + rightOffset) / 3.0f) {
                    grx.scale(((float)width - (leftOffset + rightOffset) / 3.0f) / (float)width, 1.0);
                }
                grx.drawLine(0, 0, width, 0);
            } else {
                grx.translate((float)(element.getX() + offsetX) - leftOffset, (float)(element.getY() + offsetY + height) - BorderOffset.getOffset(bottomPen));
                grx.scale(((float)width + leftOffset + rightOffset) / (float)width, 1.0);
                grx.drawLine(0, 0, width, 0);
            }
            grx.setTransform(oldTx);
        }
    }

    protected void drawRightPen(Graphics2D grx, JRPen topPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element, int offsetX, int offsetY) {
        Stroke rightStroke = JRPenUtil.getStroke(rightPen, 0);
        int height = element.getHeight();
        int width = element.getWidth();
        float topOffset = topPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(topPen);
        float bottomOffset = bottomPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(bottomPen);
        if (rightStroke != null && height > 0) {
            grx.setStroke(rightStroke);
            grx.setColor(rightPen.getLineColor());
            AffineTransform oldTx = grx.getTransform();
            if (rightPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float rightPenWidth = rightPen.getLineWidth().floatValue();
                grx.translate((float)(element.getX() + offsetX + width) + rightPenWidth / 3.0f, (float)(element.getY() + offsetY) - topOffset);
                grx.scale(1.0, ((float)height + topOffset + bottomOffset) / (float)height);
                grx.drawLine(0, 0, 0, height);
                grx.setTransform(oldTx);
                grx.translate((float)(element.getX() + offsetX + width) - rightPenWidth / 3.0f, (float)(element.getY() + offsetY) + topOffset / 3.0f);
                if ((float)height > (topOffset + bottomOffset) / 3.0f) {
                    grx.scale(1.0, ((float)height - (topOffset + bottomOffset) / 3.0f) / (float)height);
                }
                grx.drawLine(0, 0, 0, height);
            } else {
                grx.translate((float)(element.getX() + offsetX + width) - BorderOffset.getOffset(rightPen), (float)(element.getY() + offsetY) - topOffset);
                grx.scale(1.0, ((float)height + topOffset + bottomOffset) / (float)height);
                grx.drawLine(0, 0, 0, height);
            }
            grx.setTransform(oldTx);
        }
    }
}

