<?php
	/*
	 * This file is part of the symfony package.
	 * (c) Fabien Potencier <fabien.potencier@symfony-project.com>
	 *
	 * For the full copyright and license information, please view the LICENSE
	 * file that was distributed with this source code.
	 */

	/**
	 * sfValidatorUrl validates Urls.
	 *
	 * @package    symfony
	 * @subpackage validator
	 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
	 * @version    SVN: $Id: sfValidatorUrl.class.php 14733 2016-02-12 14:14:26Z sigurdne $
	 */
	class sfValidatorUrl extends sfValidatorRegex
	{

		/**
		 * @param array $options   An array of options
		 * @param array $messages  An array of error messages
		 *
		 * @see sfValidatorRegex
		 */
		protected function configure( $options = array(), $messages = array() )
		{
			parent::configure($options, $messages);

			$this->setOption('pattern', '~^
      (https?|ftps?)://                       # http or ftp (+SSL)
      (
        ([a-z0-9-]+\.)+[a-z]{2,6}             # a domain name
          |                                   #  or
        \d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}    # a IP address
      )
      (:[0-9]+)?                              # a port (optional)
      (/?|/\S+)                               # a /, nothing or a / with something
    $~ix');
		}
	}