if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/gallery-sm-menu-base/gallery-sm-menu-base.js']) {
   __coverage__['build/gallery-sm-menu-base/gallery-sm-menu-base.js'] = {"path":"build/gallery-sm-menu-base/gallery-sm-menu-base.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":32},"end":{"line":1,"column":51}}},"2":{"name":"(anonymous_2)","line":63,"loc":{"start":{"line":63,"column":17},"end":{"line":63,"column":35}}},"3":{"name":"(anonymous_3)","line":77,"loc":{"start":{"line":77,"column":19},"end":{"line":77,"column":31}}},"4":{"name":"(anonymous_4)","line":79,"loc":{"start":{"line":79,"column":39},"end":{"line":79,"column":55}}},"5":{"name":"(anonymous_5)","line":96,"loc":{"start":{"line":96,"column":17},"end":{"line":96,"column":42}}},"6":{"name":"(anonymous_6)","line":117,"loc":{"start":{"line":117,"column":16},"end":{"line":117,"column":41}}},"7":{"name":"(anonymous_7)","line":138,"loc":{"start":{"line":138,"column":14},"end":{"line":138,"column":39}}},"8":{"name":"(anonymous_8)","line":159,"loc":{"start":{"line":159,"column":14},"end":{"line":159,"column":39}}},"9":{"name":"(anonymous_9)","line":179,"loc":{"start":{"line":179,"column":19},"end":{"line":179,"column":32}}},"10":{"name":"(anonymous_10)","line":190,"loc":{"start":{"line":190,"column":18},"end":{"line":190,"column":31}}},"11":{"name":"(anonymous_11)","line":201,"loc":{"start":{"line":201,"column":16},"end":{"line":201,"column":29}}},"12":{"name":"(anonymous_12)","line":212,"loc":{"start":{"line":212,"column":16},"end":{"line":212,"column":29}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":220,"column":91}},"2":{"start":{"line":30,"column":0},"end":{"line":30,"column":28}},"3":{"start":{"line":39,"column":0},"end":{"line":39,"column":26}},"4":{"start":{"line":48,"column":0},"end":{"line":48,"column":22}},"5":{"start":{"line":57,"column":0},"end":{"line":57,"column":22}},"6":{"start":{"line":59,"column":0},"end":{"line":215,"column":3}},"7":{"start":{"line":64,"column":8},"end":{"line":66,"column":9}},"8":{"start":{"line":65,"column":12},"end":{"line":65,"column":40}},"9":{"start":{"line":79,"column":8},"end":{"line":81,"column":17}},"10":{"start":{"line":80,"column":12},"end":{"line":80,"column":25}},"11":{"start":{"line":83,"column":8},"end":{"line":83,"column":20}},"12":{"start":{"line":97,"column":8},"end":{"line":102,"column":9}},"13":{"start":{"line":98,"column":12},"end":{"line":101,"column":15}},"14":{"start":{"line":104,"column":8},"end":{"line":104,"column":20}},"15":{"start":{"line":118,"column":8},"end":{"line":123,"column":9}},"16":{"start":{"line":119,"column":12},"end":{"line":122,"column":15}},"17":{"start":{"line":125,"column":8},"end":{"line":125,"column":20}},"18":{"start":{"line":139,"column":8},"end":{"line":144,"column":9}},"19":{"start":{"line":140,"column":12},"end":{"line":143,"column":15}},"20":{"start":{"line":146,"column":8},"end":{"line":146,"column":20}},"21":{"start":{"line":160,"column":8},"end":{"line":165,"column":9}},"22":{"start":{"line":161,"column":12},"end":{"line":164,"column":15}},"23":{"start":{"line":167,"column":8},"end":{"line":167,"column":20}},"24":{"start":{"line":180,"column":8},"end":{"line":180,"column":37}},"25":{"start":{"line":191,"column":8},"end":{"line":191,"column":37}},"26":{"start":{"line":202,"column":8},"end":{"line":202,"column":35}},"27":{"start":{"line":213,"column":8},"end":{"line":213,"column":35}},"28":{"start":{"line":217,"column":0},"end":{"line":217,"column":36}}},"branchMap":{"1":{"line":64,"type":"if","locations":[{"start":{"line":64,"column":8},"end":{"line":64,"column":8}},{"start":{"line":64,"column":8},"end":{"line":64,"column":8}}]},"2":{"line":97,"type":"if","locations":[{"start":{"line":97,"column":8},"end":{"line":97,"column":8}},{"start":{"line":97,"column":8},"end":{"line":97,"column":8}}]},"3":{"line":100,"type":"binary-expr","locations":[{"start":{"line":100,"column":27},"end":{"line":100,"column":34}},{"start":{"line":100,"column":38},"end":{"line":100,"column":52}}]},"4":{"line":118,"type":"if","locations":[{"start":{"line":118,"column":8},"end":{"line":118,"column":8}},{"start":{"line":118,"column":8},"end":{"line":118,"column":8}}]},"5":{"line":121,"type":"binary-expr","locations":[{"start":{"line":121,"column":27},"end":{"line":121,"column":34}},{"start":{"line":121,"column":38},"end":{"line":121,"column":52}}]},"6":{"line":139,"type":"if","locations":[{"start":{"line":139,"column":8},"end":{"line":139,"column":8}},{"start":{"line":139,"column":8},"end":{"line":139,"column":8}}]},"7":{"line":142,"type":"binary-expr","locations":[{"start":{"line":142,"column":27},"end":{"line":142,"column":34}},{"start":{"line":142,"column":38},"end":{"line":142,"column":52}}]},"8":{"line":160,"type":"if","locations":[{"start":{"line":160,"column":8},"end":{"line":160,"column":8}},{"start":{"line":160,"column":8},"end":{"line":160,"column":8}}]},"9":{"line":163,"type":"binary-expr","locations":[{"start":{"line":163,"column":27},"end":{"line":163,"column":34}},{"start":{"line":163,"column":38},"end":{"line":163,"column":52}}]}},"code":["(function () { YUI.add('gallery-sm-menu-base', function (Y, NAME) {","","/*jshint expr:true, onevar:false */","","/**","Provides `Menu.Base`.","","@module gallery-sm-menu","@submodule gallery-sm-menu-base","**/","","/**","Base menu functionality.","","@class Menu.Base","@constructor","@param {Object} [config] Config options.","    @param {Menu.Item[]|Object[]} [config.items] Array of `Menu.Item` instances","        or menu item config objects to add to this menu.","@extends Tree","**/","","/**","Fired when a menu item is disabled.","","@event disable","@param {Menu.Item} item Menu item that was disabled.","@preventable _defDisableFn","**/","var EVT_DISABLE = 'disable';","","/**","Fired when a menu item is enabled.","","@event enable","@param {Menu.Item} item Menu item that was enabled.","@preventable _defEnableFn","**/","var EVT_ENABLE = 'enable';","","/**","Fired when a menu item is hidden.","","@event hide","@param {Menu.Item} item Menu item that was hidden.","@preventable _defHideFn","**/","var EVT_HIDE = 'hide';","","/**","Fired when a menu item is shown.","","@event show","@param {Menu.Item} item Menu item that was shown.","@preventable _defShowFn","**/","var EVT_SHOW = 'show';","","var MenuBase = Y.Base.create('menuBase', Y.Tree, [Y.Tree.Labelable, Y.Tree.Openable], {","    nodeClass: Y.Menu.Item,","","    // -- Lifecycle ------------------------------------------------------------","    initializer: function (config) {","        if (config) {","            config.nodes = config.items;","        }","    },","","    // -- Public Methods -------------------------------------------------------","","    /**","    Closes all open submenus of this menu.","","    @method closeSubMenus","    @chainable","    **/","    closeSubMenus: function () {","        // Close all open submenus.","        Y.Object.each(this._openMenus, function (item) {","            item.close();","        }, this);","","        return this;","    },","","    /**","    Disables the specified menu item.","","    @method disableItem","    @param {Menu.Item} item Menu item to disable.","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `disable` event","            will be suppressed.","    @chainable","    **/","    disableItem: function (item, options) {","        if (!item.isDisabled()) {","            this._fireTreeEvent(EVT_DISABLE, {item: item}, {","                defaultFn: this._defDisableFn,","                silent   : options && options.silent","            });","        }","","        return this;","    },","","    /**","    Enables the specified menu item.","","    @method enableItem","    @param {Menu.Item} item Menu item to enable.","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `enable` event","            will be suppressed.","    @chainable","    **/","    enableItem: function (item, options) {","        if (item.isDisabled()) {","            this._fireTreeEvent(EVT_ENABLE, {item: item}, {","                defaultFn: this._defEnableFn,","                silent   : options && options.silent","            });","        }","","        return this;","    },","","    /**","    Hides the specified menu item.","","    @method hideItem","    @param {Menu.Item} item Menu item to hide.","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `hide` event","            will be suppressed.","    @chainable","    **/","    hideItem: function (item, options) {","        if (!item.isHidden()) {","            this._fireTreeEvent(EVT_HIDE, {item: item}, {","                defaultFn: this._defHideFn,","                silent   : options && options.silent","            });","        }","","        return this;","    },","","    /**","    Shows the specified menu item.","","    @method showItem","    @param {Menu.Item} item Menu item to show.","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `show` event","            will be suppressed.","    @chainable","    **/","    showItem: function (item, options) {","        if (item.isHidden()) {","            this._fireTreeEvent(EVT_SHOW, {item: item}, {","                defaultFn: this._defShowFn,","                silent   : options && options.silent","            });","        }","","        return this;","    },","","    // -- Default Event Handlers -----------------------------------------------","","    /**","    Default handler for the `disable` event.","","    @method _defDisableFn","    @param {EventFacade} e","    @protected","    **/","    _defDisableFn: function (e) {","        e.item.state.disabled = true;","    },","","    /**","    Default handler for the `enable` event.","","    @method _defEnableFn","    @param {EventFacade} e","    @protected","    **/","    _defEnableFn: function (e) {","        delete e.item.state.disabled;","    },","","    /**","    Default handler for the `hide` event.","","    @method _defHideFn","    @param {EventFacade} e","    @protected","    **/","    _defHideFn: function (e) {","        e.item.state.hidden = true;","    },","","    /**","    Default handler for the `show` event.","","    @method _defShowFn","    @param {EventFacade} e","    @protected","    **/","    _defShowFn: function (e) {","        delete e.item.state.hidden;","    }","});","","Y.namespace('Menu').Base = MenuBase;","","","}, '@VERSION@', {\"requires\": [\"gallery-sm-menu-item\", \"tree-labelable\", \"tree-openable\"]});","","}());"]};
}
var __cov_xds42LWOj2kKiFHTyUoXtw = __coverage__['build/gallery-sm-menu-base/gallery-sm-menu-base.js'];
__cov_xds42LWOj2kKiFHTyUoXtw.s['1']++;YUI.add('gallery-sm-menu-base',function(Y,NAME){__cov_xds42LWOj2kKiFHTyUoXtw.f['1']++;__cov_xds42LWOj2kKiFHTyUoXtw.s['2']++;var EVT_DISABLE='disable';__cov_xds42LWOj2kKiFHTyUoXtw.s['3']++;var EVT_ENABLE='enable';__cov_xds42LWOj2kKiFHTyUoXtw.s['4']++;var EVT_HIDE='hide';__cov_xds42LWOj2kKiFHTyUoXtw.s['5']++;var EVT_SHOW='show';__cov_xds42LWOj2kKiFHTyUoXtw.s['6']++;var MenuBase=Y.Base.create('menuBase',Y.Tree,[Y.Tree.Labelable,Y.Tree.Openable],{nodeClass:Y.Menu.Item,initializer:function(config){__cov_xds42LWOj2kKiFHTyUoXtw.f['2']++;__cov_xds42LWOj2kKiFHTyUoXtw.s['7']++;if(config){__cov_xds42LWOj2kKiFHTyUoXtw.b['1'][0]++;__cov_xds42LWOj2kKiFHTyUoXtw.s['8']++;config.nodes=config.items;}else{__cov_xds42LWOj2kKiFHTyUoXtw.b['1'][1]++;}},closeSubMenus:function(){__cov_xds42LWOj2kKiFHTyUoXtw.f['3']++;__cov_xds42LWOj2kKiFHTyUoXtw.s['9']++;Y.Object.each(this._openMenus,function(item){__cov_xds42LWOj2kKiFHTyUoXtw.f['4']++;__cov_xds42LWOj2kKiFHTyUoXtw.s['10']++;item.close();},this);__cov_xds42LWOj2kKiFHTyUoXtw.s['11']++;return this;},disableItem:function(item,options){__cov_xds42LWOj2kKiFHTyUoXtw.f['5']++;__cov_xds42LWOj2kKiFHTyUoXtw.s['12']++;if(!item.isDisabled()){__cov_xds42LWOj2kKiFHTyUoXtw.b['2'][0]++;__cov_xds42LWOj2kKiFHTyUoXtw.s['13']++;this._fireTreeEvent(EVT_DISABLE,{item:item},{defaultFn:this._defDisableFn,silent:(__cov_xds42LWOj2kKiFHTyUoXtw.b['3'][0]++,options)&&(__cov_xds42LWOj2kKiFHTyUoXtw.b['3'][1]++,options.silent)});}else{__cov_xds42LWOj2kKiFHTyUoXtw.b['2'][1]++;}__cov_xds42LWOj2kKiFHTyUoXtw.s['14']++;return this;},enableItem:function(item,options){__cov_xds42LWOj2kKiFHTyUoXtw.f['6']++;__cov_xds42LWOj2kKiFHTyUoXtw.s['15']++;if(item.isDisabled()){__cov_xds42LWOj2kKiFHTyUoXtw.b['4'][0]++;__cov_xds42LWOj2kKiFHTyUoXtw.s['16']++;this._fireTreeEvent(EVT_ENABLE,{item:item},{defaultFn:this._defEnableFn,silent:(__cov_xds42LWOj2kKiFHTyUoXtw.b['5'][0]++,options)&&(__cov_xds42LWOj2kKiFHTyUoXtw.b['5'][1]++,options.silent)});}else{__cov_xds42LWOj2kKiFHTyUoXtw.b['4'][1]++;}__cov_xds42LWOj2kKiFHTyUoXtw.s['17']++;return this;},hideItem:function(item,options){__cov_xds42LWOj2kKiFHTyUoXtw.f['7']++;__cov_xds42LWOj2kKiFHTyUoXtw.s['18']++;if(!item.isHidden()){__cov_xds42LWOj2kKiFHTyUoXtw.b['6'][0]++;__cov_xds42LWOj2kKiFHTyUoXtw.s['19']++;this._fireTreeEvent(EVT_HIDE,{item:item},{defaultFn:this._defHideFn,silent:(__cov_xds42LWOj2kKiFHTyUoXtw.b['7'][0]++,options)&&(__cov_xds42LWOj2kKiFHTyUoXtw.b['7'][1]++,options.silent)});}else{__cov_xds42LWOj2kKiFHTyUoXtw.b['6'][1]++;}__cov_xds42LWOj2kKiFHTyUoXtw.s['20']++;return this;},showItem:function(item,options){__cov_xds42LWOj2kKiFHTyUoXtw.f['8']++;__cov_xds42LWOj2kKiFHTyUoXtw.s['21']++;if(item.isHidden()){__cov_xds42LWOj2kKiFHTyUoXtw.b['8'][0]++;__cov_xds42LWOj2kKiFHTyUoXtw.s['22']++;this._fireTreeEvent(EVT_SHOW,{item:item},{defaultFn:this._defShowFn,silent:(__cov_xds42LWOj2kKiFHTyUoXtw.b['9'][0]++,options)&&(__cov_xds42LWOj2kKiFHTyUoXtw.b['9'][1]++,options.silent)});}else{__cov_xds42LWOj2kKiFHTyUoXtw.b['8'][1]++;}__cov_xds42LWOj2kKiFHTyUoXtw.s['23']++;return this;},_defDisableFn:function(e){__cov_xds42LWOj2kKiFHTyUoXtw.f['9']++;__cov_xds42LWOj2kKiFHTyUoXtw.s['24']++;e.item.state.disabled=true;},_defEnableFn:function(e){__cov_xds42LWOj2kKiFHTyUoXtw.f['10']++;__cov_xds42LWOj2kKiFHTyUoXtw.s['25']++;delete e.item.state.disabled;},_defHideFn:function(e){__cov_xds42LWOj2kKiFHTyUoXtw.f['11']++;__cov_xds42LWOj2kKiFHTyUoXtw.s['26']++;e.item.state.hidden=true;},_defShowFn:function(e){__cov_xds42LWOj2kKiFHTyUoXtw.f['12']++;__cov_xds42LWOj2kKiFHTyUoXtw.s['27']++;delete e.item.state.hidden;}});__cov_xds42LWOj2kKiFHTyUoXtw.s['28']++;Y.namespace('Menu').Base=MenuBase;},'@VERSION@',{'requires':['gallery-sm-menu-item','tree-labelable','tree-openable']});
