if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/gallery-sm-menu-item/gallery-sm-menu-item.js']) {
   __coverage__['build/gallery-sm-menu-item/gallery-sm-menu-item.js'] = {"path":"build/gallery-sm-menu-item/gallery-sm-menu-item.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":32},"end":{"line":1,"column":51}}},"2":{"name":"MenuItem","line":38,"loc":{"start":{"line":38,"column":0},"end":{"line":38,"column":32}}},"3":{"name":"(anonymous_3)","line":60,"loc":{"start":{"line":60,"column":13},"end":{"line":60,"column":32}}},"4":{"name":"(anonymous_4)","line":74,"loc":{"start":{"line":74,"column":12},"end":{"line":74,"column":31}}},"5":{"name":"(anonymous_5)","line":88,"loc":{"start":{"line":88,"column":10},"end":{"line":88,"column":29}}},"6":{"name":"(anonymous_6)","line":101,"loc":{"start":{"line":101,"column":16},"end":{"line":101,"column":28}}},"7":{"name":"(anonymous_7)","line":114,"loc":{"start":{"line":114,"column":14},"end":{"line":114,"column":26}}},"8":{"name":"(anonymous_8)","line":128,"loc":{"start":{"line":128,"column":10},"end":{"line":128,"column":29}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":137,"column":52}},"2":{"start":{"line":38,"column":0},"end":{"line":46,"column":1}},"3":{"start":{"line":39,"column":4},"end":{"line":39,"column":28}},"4":{"start":{"line":41,"column":4},"end":{"line":41,"column":62}},"5":{"start":{"line":42,"column":4},"end":{"line":42,"column":38}},"6":{"start":{"line":43,"column":4},"end":{"line":43,"column":34}},"7":{"start":{"line":45,"column":4},"end":{"line":45,"column":61}},"8":{"start":{"line":48,"column":0},"end":{"line":132,"column":3}},"9":{"start":{"line":61,"column":8},"end":{"line":61,"column":45}},"10":{"start":{"line":62,"column":8},"end":{"line":62,"column":20}},"11":{"start":{"line":75,"column":8},"end":{"line":75,"column":44}},"12":{"start":{"line":76,"column":8},"end":{"line":76,"column":20}},"13":{"start":{"line":89,"column":8},"end":{"line":89,"column":42}},"14":{"start":{"line":90,"column":8},"end":{"line":90,"column":20}},"15":{"start":{"line":102,"column":8},"end":{"line":103,"column":61}},"16":{"start":{"line":115,"column":8},"end":{"line":116,"column":59}},"17":{"start":{"line":129,"column":8},"end":{"line":129,"column":42}},"18":{"start":{"line":130,"column":8},"end":{"line":130,"column":20}},"19":{"start":{"line":134,"column":0},"end":{"line":134,"column":36}}},"branchMap":{"1":{"line":39,"type":"binary-expr","locations":[{"start":{"line":39,"column":4},"end":{"line":39,"column":10}},{"start":{"line":39,"column":15},"end":{"line":39,"column":26}}]},"2":{"line":41,"type":"binary-expr","locations":[{"start":{"line":41,"column":29},"end":{"line":41,"column":38}},{"start":{"line":41,"column":42},"end":{"line":41,"column":61}}]},"3":{"line":42,"type":"binary-expr","locations":[{"start":{"line":42,"column":16},"end":{"line":42,"column":27}},{"start":{"line":42,"column":31},"end":{"line":42,"column":37}}]},"4":{"line":43,"type":"binary-expr","locations":[{"start":{"line":43,"column":16},"end":{"line":43,"column":26}},{"start":{"line":43,"column":30},"end":{"line":43,"column":33}}]},"5":{"line":102,"type":"binary-expr","locations":[{"start":{"line":102,"column":15},"end":{"line":102,"column":36}},{"start":{"line":103,"column":13},"end":{"line":103,"column":59}}]},"6":{"line":103,"type":"cond-expr","locations":[{"start":{"line":103,"column":27},"end":{"line":103,"column":51}},{"start":{"line":103,"column":54},"end":{"line":103,"column":59}}]},"7":{"line":115,"type":"binary-expr","locations":[{"start":{"line":115,"column":15},"end":{"line":115,"column":34}},{"start":{"line":116,"column":13},"end":{"line":116,"column":57}}]},"8":{"line":116,"type":"cond-expr","locations":[{"start":{"line":116,"column":27},"end":{"line":116,"column":49}},{"start":{"line":116,"column":52},"end":{"line":116,"column":57}}]}},"code":["(function () { YUI.add('gallery-sm-menu-item', function (Y, NAME) {","","/*jshint expr:true, onevar:false */","","/**","Provides the `Menu.Item` class.","","@module gallery-sm-menu","@submodule gallery-sm-menu-item","**/","","/**","Represents a single menu item in a `Menu`.","","@class Menu.Item","@constructor","@param {Menu} menu `Menu` instance with which this node should be associated.","@param {Object} [config] Configuration hash for this menu item. Supports all the","    config properties of `Tree.Node` in addition to the following.","","    @param {Object} [config.state] State hash for this menu item.","","        @param {Boolean} [config.state.disabled=false] If `true`, this menu item","            will be disabled, and will not be clickable or selectable.","","        @param {Boolean} [config.state.hidden=false] If `true`, this menu item","            will be hidden.","","    @param {String} [config.type='item'] Type of this menu item. May be 'item',","        'heading', or 'separator'.","","    @param {String} [config.url='#'] URL associated with this item. If this item","        is of type 'item', clicking on the item will navigate to this URL.","","@extends Tree.Node","**/","","function MenuItem(menu, config) {","    config || (config = {});","","    this.id   = this._yuid = config.id || Y.guid('menuItem-');","    this.type = config.type || 'item';","    this.url  = config.url || '#';","","    MenuItem.superclass.constructor.call(this, menu, config);","}","","Y.extend(MenuItem, Y.Tree.Node, {","    _serializable: Y.Tree.Node.prototype._serializable.concat('type', 'url'),","","    /**","    Disables this menu item. Disabled items are not clickable or selectable.","","    @method disable","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `disable` event","            will be suppressed.","    @chainable","    **/","    disable: function (options) {","        this.tree.disableItem(this, options);","        return this;","    },","","    /**","    Enables this menu item.","","    @method enable","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `enable` event","            will be suppressed.","    @chainable","    **/","    enable: function (options) {","        this.tree.enableItem(this, options);","        return this;","    },","","    /**","    Hides this menu item.","","    @method hide","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `hide` event","            will be suppressed.","    @chainable","    **/","    hide: function (options) {","        this.tree.hideItem(this, options);","        return this;","    },","","    /**","    Returns `true` if this menu item or one of its ancestors is currently","    disabled.","","    @method isDisabled","    @return {Boolean} `true` if this menu item or one of its ancestors is","        currently disabled, `false` otherwise.","    **/","    isDisabled: function () {","        return !!this.state.disabled ||","            (this.parent ? this.parent.isDisabled() : false);","    },","","    /**","    Returns `true` if this menu item or one of its ancestors is currently","    hidden.","","    @method isHidden","    @return {Boolean} `true` if this menu item or one of its ancestors is","        currently hidden, `false` otherwise.","    **/","    isHidden: function () {","        return !!this.state.hidden ||","            (this.parent ? this.parent.isHidden() : false);","    },","","    /**","    Shows this menu item.","","    @method show","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `show` event","            will be suppressed.","    @chainable","    **/","    show: function (options) {","        this.tree.showItem(this, options);","        return this;","    }","});","","Y.namespace('Menu').Item = MenuItem;","","","}, '@VERSION@', {\"requires\": [\"tree-node\", \"oop\"]});","","}());"]};
}
var __cov_nnfyFp4BOcLPScgxn4HLcw = __coverage__['build/gallery-sm-menu-item/gallery-sm-menu-item.js'];
__cov_nnfyFp4BOcLPScgxn4HLcw.s['1']++;YUI.add('gallery-sm-menu-item',function(Y,NAME){__cov_nnfyFp4BOcLPScgxn4HLcw.f['1']++;__cov_nnfyFp4BOcLPScgxn4HLcw.s['2']++;function MenuItem(menu,config){__cov_nnfyFp4BOcLPScgxn4HLcw.f['2']++;__cov_nnfyFp4BOcLPScgxn4HLcw.s['3']++;(__cov_nnfyFp4BOcLPScgxn4HLcw.b['1'][0]++,config)||(__cov_nnfyFp4BOcLPScgxn4HLcw.b['1'][1]++,config={});__cov_nnfyFp4BOcLPScgxn4HLcw.s['4']++;this.id=this._yuid=(__cov_nnfyFp4BOcLPScgxn4HLcw.b['2'][0]++,config.id)||(__cov_nnfyFp4BOcLPScgxn4HLcw.b['2'][1]++,Y.guid('menuItem-'));__cov_nnfyFp4BOcLPScgxn4HLcw.s['5']++;this.type=(__cov_nnfyFp4BOcLPScgxn4HLcw.b['3'][0]++,config.type)||(__cov_nnfyFp4BOcLPScgxn4HLcw.b['3'][1]++,'item');__cov_nnfyFp4BOcLPScgxn4HLcw.s['6']++;this.url=(__cov_nnfyFp4BOcLPScgxn4HLcw.b['4'][0]++,config.url)||(__cov_nnfyFp4BOcLPScgxn4HLcw.b['4'][1]++,'#');__cov_nnfyFp4BOcLPScgxn4HLcw.s['7']++;MenuItem.superclass.constructor.call(this,menu,config);}__cov_nnfyFp4BOcLPScgxn4HLcw.s['8']++;Y.extend(MenuItem,Y.Tree.Node,{_serializable:Y.Tree.Node.prototype._serializable.concat('type','url'),disable:function(options){__cov_nnfyFp4BOcLPScgxn4HLcw.f['3']++;__cov_nnfyFp4BOcLPScgxn4HLcw.s['9']++;this.tree.disableItem(this,options);__cov_nnfyFp4BOcLPScgxn4HLcw.s['10']++;return this;},enable:function(options){__cov_nnfyFp4BOcLPScgxn4HLcw.f['4']++;__cov_nnfyFp4BOcLPScgxn4HLcw.s['11']++;this.tree.enableItem(this,options);__cov_nnfyFp4BOcLPScgxn4HLcw.s['12']++;return this;},hide:function(options){__cov_nnfyFp4BOcLPScgxn4HLcw.f['5']++;__cov_nnfyFp4BOcLPScgxn4HLcw.s['13']++;this.tree.hideItem(this,options);__cov_nnfyFp4BOcLPScgxn4HLcw.s['14']++;return this;},isDisabled:function(){__cov_nnfyFp4BOcLPScgxn4HLcw.f['6']++;__cov_nnfyFp4BOcLPScgxn4HLcw.s['15']++;return(__cov_nnfyFp4BOcLPScgxn4HLcw.b['5'][0]++,!!this.state.disabled)||(__cov_nnfyFp4BOcLPScgxn4HLcw.b['5'][1]++,this.parent?(__cov_nnfyFp4BOcLPScgxn4HLcw.b['6'][0]++,this.parent.isDisabled()):(__cov_nnfyFp4BOcLPScgxn4HLcw.b['6'][1]++,false));},isHidden:function(){__cov_nnfyFp4BOcLPScgxn4HLcw.f['7']++;__cov_nnfyFp4BOcLPScgxn4HLcw.s['16']++;return(__cov_nnfyFp4BOcLPScgxn4HLcw.b['7'][0]++,!!this.state.hidden)||(__cov_nnfyFp4BOcLPScgxn4HLcw.b['7'][1]++,this.parent?(__cov_nnfyFp4BOcLPScgxn4HLcw.b['8'][0]++,this.parent.isHidden()):(__cov_nnfyFp4BOcLPScgxn4HLcw.b['8'][1]++,false));},show:function(options){__cov_nnfyFp4BOcLPScgxn4HLcw.f['8']++;__cov_nnfyFp4BOcLPScgxn4HLcw.s['17']++;this.tree.showItem(this,options);__cov_nnfyFp4BOcLPScgxn4HLcw.s['18']++;return this;}});__cov_nnfyFp4BOcLPScgxn4HLcw.s['19']++;Y.namespace('Menu').Item=MenuItem;},'@VERSION@',{'requires':['tree-node','oop']});
