/*
YUI 3.16.0 (build 76f0e08)
Copyright 2014 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/intl-base/intl-base.js']) {
   __coverage__['build/intl-base/intl-base.js'] = {"path":"build/intl-base/intl-base.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0]},"f":{"1":0,"2":0,"3":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":21},"end":{"line":1,"column":40}}},"2":{"name":"(anonymous_2)","line":36,"loc":{"start":{"line":36,"column":20},"end":{"line":36,"column":69}}},"3":{"name":"scan","line":42,"loc":{"start":{"line":42,"column":8},"end":{"line":42,"column":32}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":88,"column":41}},"2":{"start":{"line":12,"column":0},"end":{"line":12,"column":25}},"3":{"start":{"line":14,"column":0},"end":{"line":85,"column":3}},"4":{"start":{"line":38,"column":8},"end":{"line":38,"column":39}},"5":{"start":{"line":42,"column":8},"end":{"line":50,"column":9}},"6":{"start":{"line":43,"column":12},"end":{"line":43,"column":18}},"7":{"start":{"line":44,"column":12},"end":{"line":49,"column":13}},"8":{"start":{"line":45,"column":16},"end":{"line":48,"column":17}},"9":{"start":{"line":47,"column":20},"end":{"line":47,"column":49}},"10":{"start":{"line":52,"column":8},"end":{"line":54,"column":9}},"11":{"start":{"line":53,"column":12},"end":{"line":53,"column":71}},"12":{"start":{"line":56,"column":8},"end":{"line":81,"column":9}},"13":{"start":{"line":57,"column":12},"end":{"line":57,"column":45}},"14":{"start":{"line":58,"column":12},"end":{"line":60,"column":13}},"15":{"start":{"line":59,"column":16},"end":{"line":59,"column":25}},"16":{"start":{"line":62,"column":12},"end":{"line":80,"column":13}},"17":{"start":{"line":63,"column":16},"end":{"line":63,"column":40}},"18":{"start":{"line":64,"column":16},"end":{"line":79,"column":17}},"19":{"start":{"line":65,"column":20},"end":{"line":65,"column":34}},"20":{"start":{"line":67,"column":20},"end":{"line":67,"column":54}},"21":{"start":{"line":68,"column":20},"end":{"line":78,"column":21}},"22":{"start":{"line":69,"column":24},"end":{"line":69,"column":64}},"23":{"start":{"line":72,"column":24},"end":{"line":74,"column":25}},"24":{"start":{"line":73,"column":28},"end":{"line":73,"column":72}},"25":{"start":{"line":77,"column":24},"end":{"line":77,"column":30}},"26":{"start":{"line":83,"column":8},"end":{"line":83,"column":18}}},"branchMap":{"1":{"line":45,"type":"if","locations":[{"start":{"line":45,"column":16},"end":{"line":45,"column":16}},{"start":{"line":45,"column":16},"end":{"line":45,"column":16}}]},"2":{"line":52,"type":"if","locations":[{"start":{"line":52,"column":8},"end":{"line":52,"column":8}},{"start":{"line":52,"column":8},"end":{"line":52,"column":8}}]},"3":{"line":58,"type":"if","locations":[{"start":{"line":58,"column":12},"end":{"line":58,"column":12}},{"start":{"line":58,"column":12},"end":{"line":58,"column":12}}]},"4":{"line":58,"type":"binary-expr","locations":[{"start":{"line":58,"column":16},"end":{"line":58,"column":25}},{"start":{"line":58,"column":29},"end":{"line":58,"column":45}}]},"5":{"line":64,"type":"if","locations":[{"start":{"line":64,"column":16},"end":{"line":64,"column":16}},{"start":{"line":64,"column":16},"end":{"line":64,"column":16}}]},"6":{"line":68,"type":"if","locations":[{"start":{"line":68,"column":20},"end":{"line":68,"column":20}},{"start":{"line":68,"column":20},"end":{"line":68,"column":20}}]},"7":{"line":72,"type":"if","locations":[{"start":{"line":72,"column":24},"end":{"line":72,"column":24}},{"start":{"line":72,"column":24},"end":{"line":72,"column":24}}]},"8":{"line":72,"type":"binary-expr","locations":[{"start":{"line":72,"column":28},"end":{"line":72,"column":38}},{"start":{"line":72,"column":42},"end":{"line":72,"column":76}}]}},"code":["(function () { YUI.add('intl-base', function (Y, NAME) {","","/**"," * The Intl utility provides a central location for managing sets of"," * localized resources (strings and formatting patterns)."," *"," * @class Intl"," * @uses EventTarget"," * @static"," */","","var SPLIT_REGEX = /[, ]/;","","Y.mix(Y.namespace('Intl'), {",""," /**","    * Returns the language among those available that","    * best matches the preferred language list, using the Lookup","    * algorithm of BCP 47.","    * If none of the available languages meets the user's preferences,","    * then \"\" is returned.","    * Extended language ranges are not supported.","    *","    * @method lookupBestLang","    * @param {String[] | String} preferredLanguages The list of preferred","    * languages in descending preference order, represented as BCP 47","    * language tags. A string array or a comma-separated list.","    * @param {String[]} availableLanguages The list of languages","    * that the application supports, represented as BCP 47 language","    * tags.","    *","    * @return {String} The available language that best matches the","    * preferred language list, or \"\".","    * @since 3.1.0","    */","    lookupBestLang: function(preferredLanguages, availableLanguages) {","","        var i, language, result, index;","","        // check whether the list of available languages contains language;","        // if so return it","        function scan(language) {","            var i;","            for (i = 0; i < availableLanguages.length; i += 1) {","                if (language.toLowerCase() ===","                            availableLanguages[i].toLowerCase()) {","                    return availableLanguages[i];","                }","            }","        }","","        if (Y.Lang.isString(preferredLanguages)) {","            preferredLanguages = preferredLanguages.split(SPLIT_REGEX);","        }","","        for (i = 0; i < preferredLanguages.length; i += 1) {","            language = preferredLanguages[i];","            if (!language || language === '*') {","                continue;","            }","            // check the fallback sequence for one language","            while (language.length > 0) {","                result = scan(language);","                if (result) {","                    return result;","                } else {","                    index = language.lastIndexOf('-');","                    if (index >= 0) {","                        language = language.substring(0, index);","                        // one-character subtags get cut along with the","                        // following subtag","                        if (index >= 2 && language.charAt(index - 2) === '-') {","                            language = language.substring(0, index - 2);","                        }","                    } else {","                        // nothing available for this language","                        break;","                    }","                }","            }","        }","","        return '';","    }","});","","","}, '3.16.0', {\"requires\": [\"yui-base\"]});","","}());"]};
}
var __cov_AozP7VJyVhImPsJEySoFxg = __coverage__['build/intl-base/intl-base.js'];
__cov_AozP7VJyVhImPsJEySoFxg.s['1']++;YUI.add('intl-base',function(Y,NAME){__cov_AozP7VJyVhImPsJEySoFxg.f['1']++;__cov_AozP7VJyVhImPsJEySoFxg.s['2']++;var SPLIT_REGEX=/[, ]/;__cov_AozP7VJyVhImPsJEySoFxg.s['3']++;Y.mix(Y.namespace('Intl'),{lookupBestLang:function(preferredLanguages,availableLanguages){__cov_AozP7VJyVhImPsJEySoFxg.f['2']++;__cov_AozP7VJyVhImPsJEySoFxg.s['4']++;var i,language,result,index;__cov_AozP7VJyVhImPsJEySoFxg.s['5']++;function scan(language){__cov_AozP7VJyVhImPsJEySoFxg.f['3']++;__cov_AozP7VJyVhImPsJEySoFxg.s['6']++;var i;__cov_AozP7VJyVhImPsJEySoFxg.s['7']++;for(i=0;i<availableLanguages.length;i+=1){__cov_AozP7VJyVhImPsJEySoFxg.s['8']++;if(language.toLowerCase()===availableLanguages[i].toLowerCase()){__cov_AozP7VJyVhImPsJEySoFxg.b['1'][0]++;__cov_AozP7VJyVhImPsJEySoFxg.s['9']++;return availableLanguages[i];}else{__cov_AozP7VJyVhImPsJEySoFxg.b['1'][1]++;}}}__cov_AozP7VJyVhImPsJEySoFxg.s['10']++;if(Y.Lang.isString(preferredLanguages)){__cov_AozP7VJyVhImPsJEySoFxg.b['2'][0]++;__cov_AozP7VJyVhImPsJEySoFxg.s['11']++;preferredLanguages=preferredLanguages.split(SPLIT_REGEX);}else{__cov_AozP7VJyVhImPsJEySoFxg.b['2'][1]++;}__cov_AozP7VJyVhImPsJEySoFxg.s['12']++;for(i=0;i<preferredLanguages.length;i+=1){__cov_AozP7VJyVhImPsJEySoFxg.s['13']++;language=preferredLanguages[i];__cov_AozP7VJyVhImPsJEySoFxg.s['14']++;if((__cov_AozP7VJyVhImPsJEySoFxg.b['4'][0]++,!language)||(__cov_AozP7VJyVhImPsJEySoFxg.b['4'][1]++,language==='*')){__cov_AozP7VJyVhImPsJEySoFxg.b['3'][0]++;__cov_AozP7VJyVhImPsJEySoFxg.s['15']++;continue;}else{__cov_AozP7VJyVhImPsJEySoFxg.b['3'][1]++;}__cov_AozP7VJyVhImPsJEySoFxg.s['16']++;while(language.length>0){__cov_AozP7VJyVhImPsJEySoFxg.s['17']++;result=scan(language);__cov_AozP7VJyVhImPsJEySoFxg.s['18']++;if(result){__cov_AozP7VJyVhImPsJEySoFxg.b['5'][0]++;__cov_AozP7VJyVhImPsJEySoFxg.s['19']++;return result;}else{__cov_AozP7VJyVhImPsJEySoFxg.b['5'][1]++;__cov_AozP7VJyVhImPsJEySoFxg.s['20']++;index=language.lastIndexOf('-');__cov_AozP7VJyVhImPsJEySoFxg.s['21']++;if(index>=0){__cov_AozP7VJyVhImPsJEySoFxg.b['6'][0]++;__cov_AozP7VJyVhImPsJEySoFxg.s['22']++;language=language.substring(0,index);__cov_AozP7VJyVhImPsJEySoFxg.s['23']++;if((__cov_AozP7VJyVhImPsJEySoFxg.b['8'][0]++,index>=2)&&(__cov_AozP7VJyVhImPsJEySoFxg.b['8'][1]++,language.charAt(index-2)==='-')){__cov_AozP7VJyVhImPsJEySoFxg.b['7'][0]++;__cov_AozP7VJyVhImPsJEySoFxg.s['24']++;language=language.substring(0,index-2);}else{__cov_AozP7VJyVhImPsJEySoFxg.b['7'][1]++;}}else{__cov_AozP7VJyVhImPsJEySoFxg.b['6'][1]++;__cov_AozP7VJyVhImPsJEySoFxg.s['25']++;break;}}}}__cov_AozP7VJyVhImPsJEySoFxg.s['26']++;return'';}});},'3.16.0',{'requires':['yui-base']});
