/*
YUI 3.16.0 (build 76f0e08)
Copyright 2014 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/pluginhost-base/pluginhost-base.js']) {
   __coverage__['build/pluginhost-base/pluginhost-base.js'] = {"path":"build/pluginhost-base/pluginhost-base.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0,0],"13":[0,0],"14":[0,0],"15":[0,0],"16":[0,0],"17":[0,0],"18":[0,0],"19":[0,0],"20":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":27},"end":{"line":1,"column":46}}},"2":{"name":"PluginHost","line":38,"loc":{"start":{"line":38,"column":4},"end":{"line":38,"column":26}}},"3":{"name":"(anonymous_3)","line":61,"loc":{"start":{"line":61,"column":14},"end":{"line":61,"column":39}}},"4":{"name":"(anonymous_4)","line":106,"loc":{"start":{"line":106,"column":16},"end":{"line":106,"column":33}}},"5":{"name":"(anonymous_5)","line":146,"loc":{"start":{"line":146,"column":20},"end":{"line":146,"column":33}}},"6":{"name":"(anonymous_6)","line":160,"loc":{"start":{"line":160,"column":22},"end":{"line":160,"column":39}}},"7":{"name":"(anonymous_7)","line":173,"loc":{"start":{"line":173,"column":25},"end":{"line":173,"column":36}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":181,"column":41}},"2":{"start":{"line":36,"column":4},"end":{"line":36,"column":19}},"3":{"start":{"line":38,"column":4},"end":{"line":40,"column":5}},"4":{"start":{"line":39,"column":8},"end":{"line":39,"column":27}},"5":{"start":{"line":42,"column":4},"end":{"line":176,"column":6}},"6":{"start":{"line":62,"column":12},"end":{"line":62,"column":26}},"7":{"start":{"line":64,"column":12},"end":{"line":92,"column":13}},"8":{"start":{"line":65,"column":16},"end":{"line":67,"column":17}},"9":{"start":{"line":66,"column":20},"end":{"line":66,"column":41}},"10":{"start":{"line":69,"column":16},"end":{"line":72,"column":17}},"11":{"start":{"line":70,"column":20},"end":{"line":70,"column":40}},"12":{"start":{"line":71,"column":20},"end":{"line":71,"column":39}},"13":{"start":{"line":75,"column":16},"end":{"line":91,"column":17}},"14":{"start":{"line":76,"column":20},"end":{"line":76,"column":35}},"15":{"start":{"line":78,"column":20},"end":{"line":78,"column":42}},"16":{"start":{"line":79,"column":20},"end":{"line":79,"column":39}},"17":{"start":{"line":81,"column":20},"end":{"line":90,"column":21}},"18":{"start":{"line":83,"column":24},"end":{"line":85,"column":25}},"19":{"start":{"line":84,"column":28},"end":{"line":84,"column":54}},"20":{"start":{"line":88,"column":24},"end":{"line":88,"column":54}},"21":{"start":{"line":89,"column":24},"end":{"line":89,"column":51}},"22":{"start":{"line":93,"column":12},"end":{"line":93,"column":24}},"23":{"start":{"line":107,"column":12},"end":{"line":108,"column":40}},"24":{"start":{"line":110,"column":12},"end":{"line":135,"column":13}},"25":{"start":{"line":111,"column":16},"end":{"line":116,"column":17}},"26":{"start":{"line":112,"column":20},"end":{"line":112,"column":35}},"27":{"start":{"line":113,"column":20},"end":{"line":115,"column":21}},"28":{"start":{"line":114,"column":24},"end":{"line":114,"column":34}},"29":{"start":{"line":118,"column":16},"end":{"line":128,"column":17}},"30":{"start":{"line":119,"column":20},"end":{"line":124,"column":21}},"31":{"start":{"line":120,"column":24},"end":{"line":122,"column":25}},"32":{"start":{"line":121,"column":28},"end":{"line":121,"column":47}},"33":{"start":{"line":123,"column":24},"end":{"line":123,"column":40}},"34":{"start":{"line":125,"column":20},"end":{"line":127,"column":21}},"35":{"start":{"line":126,"column":24},"end":{"line":126,"column":43}},"36":{"start":{"line":130,"column":16},"end":{"line":134,"column":17}},"37":{"start":{"line":131,"column":20},"end":{"line":133,"column":21}},"38":{"start":{"line":132,"column":24},"end":{"line":132,"column":40}},"39":{"start":{"line":136,"column":12},"end":{"line":136,"column":24}},"40":{"start":{"line":147,"column":12},"end":{"line":147,"column":51}},"41":{"start":{"line":161,"column":12},"end":{"line":161,"column":48}},"42":{"start":{"line":163,"column":12},"end":{"line":165,"column":13}},"43":{"start":{"line":164,"column":16},"end":{"line":164,"column":48}},"44":{"start":{"line":174,"column":12},"end":{"line":174,"column":26}},"45":{"start":{"line":178,"column":4},"end":{"line":178,"column":44}}},"branchMap":{"1":{"line":64,"type":"if","locations":[{"start":{"line":64,"column":12},"end":{"line":64,"column":12}},{"start":{"line":64,"column":12},"end":{"line":64,"column":12}}]},"2":{"line":69,"type":"if","locations":[{"start":{"line":69,"column":16},"end":{"line":69,"column":16}},{"start":{"line":69,"column":16},"end":{"line":69,"column":16}}]},"3":{"line":69,"type":"binary-expr","locations":[{"start":{"line":69,"column":20},"end":{"line":69,"column":26}},{"start":{"line":69,"column":30},"end":{"line":69,"column":51}}]},"4":{"line":75,"type":"if","locations":[{"start":{"line":75,"column":16},"end":{"line":75,"column":16}},{"start":{"line":75,"column":16},"end":{"line":75,"column":16}}]},"5":{"line":75,"type":"binary-expr","locations":[{"start":{"line":75,"column":20},"end":{"line":75,"column":26}},{"start":{"line":75,"column":30},"end":{"line":75,"column":39}}]},"6":{"line":78,"type":"binary-expr","locations":[{"start":{"line":78,"column":29},"end":{"line":78,"column":35}},{"start":{"line":78,"column":39},"end":{"line":78,"column":41}}]},"7":{"line":81,"type":"if","locations":[{"start":{"line":81,"column":20},"end":{"line":81,"column":20}},{"start":{"line":81,"column":20},"end":{"line":81,"column":20}}]},"8":{"line":83,"type":"if","locations":[{"start":{"line":83,"column":24},"end":{"line":83,"column":24}},{"start":{"line":83,"column":24},"end":{"line":83,"column":24}}]},"9":{"line":110,"type":"if","locations":[{"start":{"line":110,"column":12},"end":{"line":110,"column":12}},{"start":{"line":110,"column":12},"end":{"line":110,"column":12}}]},"10":{"line":111,"type":"if","locations":[{"start":{"line":111,"column":16},"end":{"line":111,"column":16}},{"start":{"line":111,"column":16},"end":{"line":111,"column":16}}]},"11":{"line":113,"type":"if","locations":[{"start":{"line":113,"column":20},"end":{"line":113,"column":20}},{"start":{"line":113,"column":20},"end":{"line":113,"column":20}}]},"12":{"line":113,"type":"binary-expr","locations":[{"start":{"line":113,"column":24},"end":{"line":113,"column":26}},{"start":{"line":113,"column":31},"end":{"line":113,"column":43}},{"start":{"line":113,"column":47},"end":{"line":113,"column":69}}]},"13":{"line":118,"type":"if","locations":[{"start":{"line":118,"column":16},"end":{"line":118,"column":16}},{"start":{"line":118,"column":16},"end":{"line":118,"column":16}}]},"14":{"line":119,"type":"if","locations":[{"start":{"line":119,"column":20},"end":{"line":119,"column":20}},{"start":{"line":119,"column":20},"end":{"line":119,"column":20}}]},"15":{"line":120,"type":"if","locations":[{"start":{"line":120,"column":24},"end":{"line":120,"column":24}},{"start":{"line":120,"column":24},"end":{"line":120,"column":24}}]},"16":{"line":125,"type":"if","locations":[{"start":{"line":125,"column":20},"end":{"line":125,"column":20}},{"start":{"line":125,"column":20},"end":{"line":125,"column":20}}]},"17":{"line":131,"type":"if","locations":[{"start":{"line":131,"column":20},"end":{"line":131,"column":20}},{"start":{"line":131,"column":20},"end":{"line":131,"column":20}}]},"18":{"line":147,"type":"binary-expr","locations":[{"start":{"line":147,"column":20},"end":{"line":147,"column":37}},{"start":{"line":147,"column":41},"end":{"line":147,"column":49}}]},"19":{"line":161,"type":"binary-expr","locations":[{"start":{"line":161,"column":28},"end":{"line":161,"column":41}},{"start":{"line":161,"column":45},"end":{"line":161,"column":47}}]},"20":{"line":163,"type":"if","locations":[{"start":{"line":163,"column":12},"end":{"line":163,"column":12}},{"start":{"line":163,"column":12},"end":{"line":163,"column":12}}]}},"code":["(function () { YUI.add('pluginhost-base', function (Y, NAME) {","","    /**","     * Provides the augmentable PluginHost interface, which can be added to any class.","     * @module pluginhost","     */","","    /**","     * Provides the augmentable PluginHost interface, which can be added to any class.","     * @module pluginhost-base","     */","","    /**","     * <p>","     * An augmentable class, which provides the augmented class with the ability to host plugins.","     * It adds <a href=\"#method_plug\">plug</a> and <a href=\"#method_unplug\">unplug</a> methods to the augmented class, which can","     * be used to add or remove plugins from instances of the class.","     * </p>","     *","     * <p>Plugins can also be added through the constructor configuration object passed to the host class' constructor using","     * the \"plugins\" property. Supported values for the \"plugins\" property are those defined by the <a href=\"#method_plug\">plug</a> method.","     *","     * For example the following code would add the AnimPlugin and IOPlugin to Overlay (the plugin host):","     * <xmp>","     * var o = new Overlay({plugins: [ AnimPlugin, {fn:IOPlugin, cfg:{section:\"header\"}}]});","     * </xmp>","     * </p>","     * <p>","     * Plug.Host's protected <a href=\"#method_initPlugins\">_initPlugins</a> and <a href=\"#method_destroyPlugins\">_destroyPlugins</a>","     * methods should be invoked by the host class at the appropriate point in the host's lifecyle.","     * </p>","     *","     * @class Plugin.Host","     */","","    var L = Y.Lang;","","    function PluginHost() {","        this._plugins = {};","    }","","    PluginHost.prototype = {","","        /**","         * Adds a plugin to the host object. This will instantiate the","         * plugin and attach it to the configured namespace on the host object.","         *","         * @method plug","         * @chainable","         * @param P {Function | Object |Array} Accepts the plugin class, or an","         * object with a \"fn\" property specifying the plugin class and","         * a \"cfg\" property specifying the configuration for the Plugin.","         * <p>","         * Additionally an Array can also be passed in, with the above function or","         * object values, allowing the user to add multiple plugins in a single call.","         * </p>","         * @param config (Optional) If the first argument is the plugin class, the second argument","         * can be the configuration for the plugin.","         * @return {Base} A reference to the host object","         */","        plug: function(Plugin, config) {","            var i, ln, ns;","","            if (L.isArray(Plugin)) {","                for (i = 0, ln = Plugin.length; i < ln; i++) {","                    this.plug(Plugin[i]);","                }","            } else {","                if (Plugin && !L.isFunction(Plugin)) {","                    config = Plugin.cfg;","                    Plugin = Plugin.fn;","                }","","                // Plugin should be fn by now","                if (Plugin && Plugin.NS) {","                    ns = Plugin.NS;","","                    config = config || {};","                    config.host = this;","","                    if (this.hasPlugin(ns)) {","                        // Update config","                        if (this[ns].setAttrs) {","                            this[ns].setAttrs(config);","                        }","                    } else {","                        // Create new instance","                        this[ns] = new Plugin(config);","                        this._plugins[ns] = Plugin;","                    }","                }","            }","            return this;","        },","","        /**","         * Removes a plugin from the host object. This will destroy the","         * plugin instance and delete the namespace from the host object.","         *","         * @method unplug","         * @param {String | Function} plugin The namespace of the plugin, or the plugin class with the static NS namespace property defined. If not provided,","         * all registered plugins are unplugged.","         * @return {Base} A reference to the host object","         * @chainable","         */","        unplug: function(plugin) {","            var ns = plugin,","                plugins = this._plugins;","","            if (plugin) {","                if (L.isFunction(plugin)) {","                    ns = plugin.NS;","                    if (ns && (!plugins[ns] || plugins[ns] !== plugin)) {","                        ns = null;","                    }","                }","","                if (ns) {","                    if (this[ns]) {","                        if (this[ns].destroy) {","                            this[ns].destroy();","                        }","                        delete this[ns];","                    }","                    if (plugins[ns]) {","                        delete plugins[ns];","                    }","                }","            } else {","                for (ns in this._plugins) {","                    if (this._plugins.hasOwnProperty(ns)) {","                        this.unplug(ns);","                    }","                }","            }","            return this;","        },","","        /**","         * Determines if a plugin has plugged into this host.","         *","         * @method hasPlugin","         * @param {String} ns The plugin's namespace","         * @return {Plugin} Returns a truthy value (the plugin instance) if present, or undefined if not.","         */","        hasPlugin : function(ns) {","            return (this._plugins[ns] && this[ns]);","        },","","        /**","         * Initializes static plugins registered on the host (using the","         * Base.plug static method) and any plugins passed to the","         * instance through the \"plugins\" configuration property.","         *","         * @method _initPlugins","         * @param {Object} config The configuration object with property name/value pairs.","         * @private","         */","","        _initPlugins: function(config) {","            this._plugins = this._plugins || {};","","            if (this._initConfigPlugins) {","                this._initConfigPlugins(config);","            }","        },","","        /**","         * Unplugs and destroys all plugins on the host","         * @method _destroyPlugins","         * @private","         */","        _destroyPlugins: function() {","            this.unplug();","        }","    };","","    Y.namespace(\"Plugin\").Host = PluginHost;","","","}, '3.16.0', {\"requires\": [\"yui-base\"]});","","}());"]};
}
var __cov_dDY1oPzWlroRs49oPPuh3Q = __coverage__['build/pluginhost-base/pluginhost-base.js'];
__cov_dDY1oPzWlroRs49oPPuh3Q.s['1']++;YUI.add('pluginhost-base',function(Y,NAME){__cov_dDY1oPzWlroRs49oPPuh3Q.f['1']++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['2']++;var L=Y.Lang;__cov_dDY1oPzWlroRs49oPPuh3Q.s['3']++;function PluginHost(){__cov_dDY1oPzWlroRs49oPPuh3Q.f['2']++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['4']++;this._plugins={};}__cov_dDY1oPzWlroRs49oPPuh3Q.s['5']++;PluginHost.prototype={plug:function(Plugin,config){__cov_dDY1oPzWlroRs49oPPuh3Q.f['3']++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['6']++;var i,ln,ns;__cov_dDY1oPzWlroRs49oPPuh3Q.s['7']++;if(L.isArray(Plugin)){__cov_dDY1oPzWlroRs49oPPuh3Q.b['1'][0]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['8']++;for(i=0,ln=Plugin.length;i<ln;i++){__cov_dDY1oPzWlroRs49oPPuh3Q.s['9']++;this.plug(Plugin[i]);}}else{__cov_dDY1oPzWlroRs49oPPuh3Q.b['1'][1]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['10']++;if((__cov_dDY1oPzWlroRs49oPPuh3Q.b['3'][0]++,Plugin)&&(__cov_dDY1oPzWlroRs49oPPuh3Q.b['3'][1]++,!L.isFunction(Plugin))){__cov_dDY1oPzWlroRs49oPPuh3Q.b['2'][0]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['11']++;config=Plugin.cfg;__cov_dDY1oPzWlroRs49oPPuh3Q.s['12']++;Plugin=Plugin.fn;}else{__cov_dDY1oPzWlroRs49oPPuh3Q.b['2'][1]++;}__cov_dDY1oPzWlroRs49oPPuh3Q.s['13']++;if((__cov_dDY1oPzWlroRs49oPPuh3Q.b['5'][0]++,Plugin)&&(__cov_dDY1oPzWlroRs49oPPuh3Q.b['5'][1]++,Plugin.NS)){__cov_dDY1oPzWlroRs49oPPuh3Q.b['4'][0]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['14']++;ns=Plugin.NS;__cov_dDY1oPzWlroRs49oPPuh3Q.s['15']++;config=(__cov_dDY1oPzWlroRs49oPPuh3Q.b['6'][0]++,config)||(__cov_dDY1oPzWlroRs49oPPuh3Q.b['6'][1]++,{});__cov_dDY1oPzWlroRs49oPPuh3Q.s['16']++;config.host=this;__cov_dDY1oPzWlroRs49oPPuh3Q.s['17']++;if(this.hasPlugin(ns)){__cov_dDY1oPzWlroRs49oPPuh3Q.b['7'][0]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['18']++;if(this[ns].setAttrs){__cov_dDY1oPzWlroRs49oPPuh3Q.b['8'][0]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['19']++;this[ns].setAttrs(config);}else{__cov_dDY1oPzWlroRs49oPPuh3Q.b['8'][1]++;}}else{__cov_dDY1oPzWlroRs49oPPuh3Q.b['7'][1]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['20']++;this[ns]=new Plugin(config);__cov_dDY1oPzWlroRs49oPPuh3Q.s['21']++;this._plugins[ns]=Plugin;}}else{__cov_dDY1oPzWlroRs49oPPuh3Q.b['4'][1]++;}}__cov_dDY1oPzWlroRs49oPPuh3Q.s['22']++;return this;},unplug:function(plugin){__cov_dDY1oPzWlroRs49oPPuh3Q.f['4']++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['23']++;var ns=plugin,plugins=this._plugins;__cov_dDY1oPzWlroRs49oPPuh3Q.s['24']++;if(plugin){__cov_dDY1oPzWlroRs49oPPuh3Q.b['9'][0]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['25']++;if(L.isFunction(plugin)){__cov_dDY1oPzWlroRs49oPPuh3Q.b['10'][0]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['26']++;ns=plugin.NS;__cov_dDY1oPzWlroRs49oPPuh3Q.s['27']++;if((__cov_dDY1oPzWlroRs49oPPuh3Q.b['12'][0]++,ns)&&((__cov_dDY1oPzWlroRs49oPPuh3Q.b['12'][1]++,!plugins[ns])||(__cov_dDY1oPzWlroRs49oPPuh3Q.b['12'][2]++,plugins[ns]!==plugin))){__cov_dDY1oPzWlroRs49oPPuh3Q.b['11'][0]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['28']++;ns=null;}else{__cov_dDY1oPzWlroRs49oPPuh3Q.b['11'][1]++;}}else{__cov_dDY1oPzWlroRs49oPPuh3Q.b['10'][1]++;}__cov_dDY1oPzWlroRs49oPPuh3Q.s['29']++;if(ns){__cov_dDY1oPzWlroRs49oPPuh3Q.b['13'][0]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['30']++;if(this[ns]){__cov_dDY1oPzWlroRs49oPPuh3Q.b['14'][0]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['31']++;if(this[ns].destroy){__cov_dDY1oPzWlroRs49oPPuh3Q.b['15'][0]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['32']++;this[ns].destroy();}else{__cov_dDY1oPzWlroRs49oPPuh3Q.b['15'][1]++;}__cov_dDY1oPzWlroRs49oPPuh3Q.s['33']++;delete this[ns];}else{__cov_dDY1oPzWlroRs49oPPuh3Q.b['14'][1]++;}__cov_dDY1oPzWlroRs49oPPuh3Q.s['34']++;if(plugins[ns]){__cov_dDY1oPzWlroRs49oPPuh3Q.b['16'][0]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['35']++;delete plugins[ns];}else{__cov_dDY1oPzWlroRs49oPPuh3Q.b['16'][1]++;}}else{__cov_dDY1oPzWlroRs49oPPuh3Q.b['13'][1]++;}}else{__cov_dDY1oPzWlroRs49oPPuh3Q.b['9'][1]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['36']++;for(ns in this._plugins){__cov_dDY1oPzWlroRs49oPPuh3Q.s['37']++;if(this._plugins.hasOwnProperty(ns)){__cov_dDY1oPzWlroRs49oPPuh3Q.b['17'][0]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['38']++;this.unplug(ns);}else{__cov_dDY1oPzWlroRs49oPPuh3Q.b['17'][1]++;}}}__cov_dDY1oPzWlroRs49oPPuh3Q.s['39']++;return this;},hasPlugin:function(ns){__cov_dDY1oPzWlroRs49oPPuh3Q.f['5']++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['40']++;return(__cov_dDY1oPzWlroRs49oPPuh3Q.b['18'][0]++,this._plugins[ns])&&(__cov_dDY1oPzWlroRs49oPPuh3Q.b['18'][1]++,this[ns]);},_initPlugins:function(config){__cov_dDY1oPzWlroRs49oPPuh3Q.f['6']++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['41']++;this._plugins=(__cov_dDY1oPzWlroRs49oPPuh3Q.b['19'][0]++,this._plugins)||(__cov_dDY1oPzWlroRs49oPPuh3Q.b['19'][1]++,{});__cov_dDY1oPzWlroRs49oPPuh3Q.s['42']++;if(this._initConfigPlugins){__cov_dDY1oPzWlroRs49oPPuh3Q.b['20'][0]++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['43']++;this._initConfigPlugins(config);}else{__cov_dDY1oPzWlroRs49oPPuh3Q.b['20'][1]++;}},_destroyPlugins:function(){__cov_dDY1oPzWlroRs49oPPuh3Q.f['7']++;__cov_dDY1oPzWlroRs49oPPuh3Q.s['44']++;this.unplug();}};__cov_dDY1oPzWlroRs49oPPuh3Q.s['45']++;Y.namespace('Plugin').Host=PluginHost;},'3.16.0',{'requires':['yui-base']});
