/*
YUI 3.16.0 (build 76f0e08)
Copyright 2014 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/tree-selectable/tree-selectable.js']) {
   __coverage__['build/tree-selectable/tree-selectable.js'] = {"path":"build/tree-selectable/tree-selectable.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0,"48":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":27},"end":{"line":1,"column":46}}},"2":{"name":"Selectable","line":41,"loc":{"start":{"line":41,"column":0},"end":{"line":41,"column":22}}},"3":{"name":"(anonymous_3)","line":55,"loc":{"start":{"line":55,"column":17},"end":{"line":55,"column":29}}},"4":{"name":"(anonymous_4)","line":68,"loc":{"start":{"line":68,"column":16},"end":{"line":68,"column":28}}},"5":{"name":"(anonymous_5)","line":83,"loc":{"start":{"line":83,"column":22},"end":{"line":83,"column":34}}},"6":{"name":"(anonymous_6)","line":101,"loc":{"start":{"line":101,"column":16},"end":{"line":101,"column":41}}},"7":{"name":"(anonymous_7)","line":132,"loc":{"start":{"line":132,"column":14},"end":{"line":132,"column":33}}},"8":{"name":"(anonymous_8)","line":156,"loc":{"start":{"line":156,"column":18},"end":{"line":156,"column":43}}},"9":{"name":"(anonymous_9)","line":171,"loc":{"start":{"line":171,"column":30},"end":{"line":171,"column":43}}},"10":{"name":"(anonymous_10)","line":179,"loc":{"start":{"line":179,"column":32},"end":{"line":179,"column":44}}},"11":{"name":"(anonymous_11)","line":183,"loc":{"start":{"line":183,"column":33},"end":{"line":183,"column":46}}},"12":{"name":"(anonymous_12)","line":189,"loc":{"start":{"line":189,"column":29},"end":{"line":189,"column":41}}},"13":{"name":"(anonymous_13)","line":193,"loc":{"start":{"line":193,"column":18},"end":{"line":193,"column":31}}},"14":{"name":"(anonymous_14)","line":202,"loc":{"start":{"line":202,"column":20},"end":{"line":202,"column":33}}},"15":{"name":"NodeSelectable","line":235,"loc":{"start":{"line":235,"column":0},"end":{"line":235,"column":26}}},"16":{"name":"(anonymous_16)","line":245,"loc":{"start":{"line":245,"column":16},"end":{"line":245,"column":28}}},"17":{"name":"(anonymous_17)","line":262,"loc":{"start":{"line":262,"column":12},"end":{"line":262,"column":31}}},"18":{"name":"(anonymous_18)","line":280,"loc":{"start":{"line":280,"column":14},"end":{"line":280,"column":33}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":289,"column":37}},"2":{"start":{"line":13,"column":0},"end":{"line":13,"column":14}},"3":{"start":{"line":30,"column":0},"end":{"line":30,"column":26}},"4":{"start":{"line":39,"column":0},"end":{"line":39,"column":30}},"5":{"start":{"line":41,"column":0},"end":{"line":41,"column":24}},"6":{"start":{"line":43,"column":0},"end":{"line":206,"column":2}},"7":{"start":{"line":56,"column":8},"end":{"line":56,"column":81}},"8":{"start":{"line":57,"column":8},"end":{"line":57,"column":33}},"9":{"start":{"line":59,"column":8},"end":{"line":59,"column":67}},"10":{"start":{"line":60,"column":8},"end":{"line":60,"column":71}},"11":{"start":{"line":61,"column":8},"end":{"line":61,"column":73}},"12":{"start":{"line":63,"column":8},"end":{"line":65,"column":10}},"13":{"start":{"line":69,"column":8},"end":{"line":69,"column":61}},"14":{"start":{"line":71,"column":8},"end":{"line":71,"column":38}},"15":{"start":{"line":72,"column":8},"end":{"line":72,"column":38}},"16":{"start":{"line":84,"column":8},"end":{"line":84,"column":50}},"17":{"start":{"line":106,"column":8},"end":{"line":114,"column":9}},"18":{"start":{"line":107,"column":12},"end":{"line":113,"column":15}},"19":{"start":{"line":116,"column":8},"end":{"line":116,"column":20}},"20":{"start":{"line":133,"column":8},"end":{"line":137,"column":9}},"21":{"start":{"line":134,"column":12},"end":{"line":136,"column":13}},"22":{"start":{"line":135,"column":16},"end":{"line":135,"column":66}},"23":{"start":{"line":139,"column":8},"end":{"line":139,"column":20}},"24":{"start":{"line":157,"column":8},"end":{"line":165,"column":9}},"25":{"start":{"line":158,"column":12},"end":{"line":164,"column":15}},"26":{"start":{"line":167,"column":8},"end":{"line":167,"column":20}},"27":{"start":{"line":174,"column":8},"end":{"line":176,"column":9}},"28":{"start":{"line":175,"column":12},"end":{"line":175,"column":36}},"29":{"start":{"line":180,"column":8},"end":{"line":180,"column":31}},"30":{"start":{"line":184,"column":8},"end":{"line":184,"column":37}},"31":{"start":{"line":185,"column":8},"end":{"line":185,"column":44}},"32":{"start":{"line":190,"column":8},"end":{"line":190,"column":24}},"33":{"start":{"line":194,"column":8},"end":{"line":196,"column":9}},"34":{"start":{"line":195,"column":12},"end":{"line":195,"column":28}},"35":{"start":{"line":198,"column":8},"end":{"line":198,"column":37}},"36":{"start":{"line":199,"column":8},"end":{"line":199,"column":46}},"37":{"start":{"line":203,"column":8},"end":{"line":203,"column":37}},"38":{"start":{"line":204,"column":8},"end":{"line":204,"column":44}},"39":{"start":{"line":208,"column":0},"end":{"line":218,"column":2}},"40":{"start":{"line":220,"column":0},"end":{"line":220,"column":31}},"41":{"start":{"line":235,"column":0},"end":{"line":235,"column":28}},"42":{"start":{"line":237,"column":0},"end":{"line":284,"column":2}},"43":{"start":{"line":246,"column":8},"end":{"line":246,"column":37}},"44":{"start":{"line":263,"column":8},"end":{"line":263,"column":44}},"45":{"start":{"line":264,"column":8},"end":{"line":264,"column":20}},"46":{"start":{"line":281,"column":8},"end":{"line":281,"column":46}},"47":{"start":{"line":282,"column":8},"end":{"line":282,"column":20}},"48":{"start":{"line":286,"column":0},"end":{"line":286,"column":40}}},"branchMap":{"1":{"line":106,"type":"if","locations":[{"start":{"line":106,"column":8},"end":{"line":106,"column":8}},{"start":{"line":106,"column":8},"end":{"line":106,"column":8}}]},"2":{"line":109,"type":"binary-expr","locations":[{"start":{"line":109,"column":22},"end":{"line":109,"column":29}},{"start":{"line":109,"column":33},"end":{"line":109,"column":44}}]},"3":{"line":112,"type":"binary-expr","locations":[{"start":{"line":112,"column":27},"end":{"line":112,"column":34}},{"start":{"line":112,"column":38},"end":{"line":112,"column":52}}]},"4":{"line":134,"type":"if","locations":[{"start":{"line":134,"column":12},"end":{"line":134,"column":12}},{"start":{"line":134,"column":12},"end":{"line":134,"column":12}}]},"5":{"line":157,"type":"if","locations":[{"start":{"line":157,"column":8},"end":{"line":157,"column":8}},{"start":{"line":157,"column":8},"end":{"line":157,"column":8}}]},"6":{"line":157,"type":"binary-expr","locations":[{"start":{"line":157,"column":12},"end":{"line":157,"column":29}},{"start":{"line":157,"column":33},"end":{"line":157,"column":59}}]},"7":{"line":160,"type":"binary-expr","locations":[{"start":{"line":160,"column":22},"end":{"line":160,"column":29}},{"start":{"line":160,"column":33},"end":{"line":160,"column":44}}]},"8":{"line":163,"type":"binary-expr","locations":[{"start":{"line":163,"column":27},"end":{"line":163,"column":34}},{"start":{"line":163,"column":38},"end":{"line":163,"column":52}}]},"9":{"line":174,"type":"if","locations":[{"start":{"line":174,"column":8},"end":{"line":174,"column":8}},{"start":{"line":174,"column":8},"end":{"line":174,"column":8}}]},"10":{"line":194,"type":"if","locations":[{"start":{"line":194,"column":8},"end":{"line":194,"column":8}},{"start":{"line":194,"column":8},"end":{"line":194,"column":8}}]}},"code":["(function () { YUI.add('tree-selectable', function (Y, NAME) {","","/*jshint expr:true, onevar:false */","","/**","Extension for `Tree` that adds the concept of selection state for nodes.","","@module tree","@submodule tree-selectable","@main tree-selectable","**/","","var Do = Y.Do;","","/**","Extension for `Tree` that adds the concept of selection state for nodes.","","@class Tree.Selectable","@constructor","@extensionfor Tree","**/","","/**","Fired when a node is selected.","","@event select","@param {Tree.Node} node Node being selected.","@preventable _defSelectFn","**/","var EVT_SELECT = 'select';","","/**","Fired when a node is unselected.","","@event unselect","@param {Tree.Node} node Node being unselected.","@preventable _defUnselectFn","**/","var EVT_UNSELECT = 'unselect';","","function Selectable() {}","","Selectable.prototype = {","    // -- Protected Properties -------------------------------------------------","","    /**","    Mapping of node ids to node instances for nodes in this tree that are","    currently selected.","","    @property {Object} _selectedMap","    @protected","    **/","","    // -- Lifecycle ------------------------------------------------------------","    initializer: function () {","        this.nodeExtensions = this.nodeExtensions.concat(Y.Tree.Node.Selectable);","        this._selectedMap   = {};","","        Do.after(this._selectableAfterDefAddFn, this, '_defAddFn');","        Do.after(this._selectableAfterDefClearFn, this, '_defClearFn');","        Do.after(this._selectableAfterDefRemoveFn, this, '_defRemoveFn');","","        this._selectableEvents = [","            this.after('multiSelectChange', this._afterMultiSelectChange)","        ];","    },","","    destructor: function () {","        (new Y.EventHandle(this._selectableEvents)).detach();","","        this._selectableEvents = null;","        this._selectedMap      = null;","    },","","    // -- Public Methods -------------------------------------------------------","","    /**","    Returns an array of nodes that are currently selected.","","    @method getSelectedNodes","    @return {Tree.Node.Selectable[]} Array of selected nodes.","    **/","    getSelectedNodes: function () {","        return Y.Object.values(this._selectedMap);","    },","","    /**","    Selects the specified node.","","    @method selectNode","    @param {Tree.Node.Selectable} node Node to select.","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `select` event","            will be suppressed.","        @param {String} [options.src] Source of the change, to be passed along","            to the event facade of the resulting event. This can be used to","            distinguish between changes triggered by a user and changes","            triggered programmatically, for example.","    @chainable","    **/","    selectNode: function (node, options) {","        // Instead of calling node.isSelected(), we look for the node in this","        // tree's selectedMap, which ensures that the `select` event will fire","        // in cases such as a node being added to this tree with its selected","        // state already set to true.","        if (!this._selectedMap[node.id]) {","            this._fireTreeEvent(EVT_SELECT, {","                node: node,","                src : options && options.src","            }, {","                defaultFn: this._defSelectFn,","                silent   : options && options.silent","            });","        }","","        return this;","    },","","    /**","    Unselects all selected nodes.","","    @method unselect","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `unselect` event","            will be suppressed.","        @param {String} [options.src] Source of the change, to be passed along","            to the event facade of the resulting event. This can be used to","            distinguish between changes triggered by a user and changes","            triggered programmatically, for example.","    @chainable","    **/","    unselect: function (options) {","        for (var id in this._selectedMap) {","            if (this._selectedMap.hasOwnProperty(id)) {","                this.unselectNode(this._selectedMap[id], options);","            }","        }","","        return this;","    },","","    /**","    Unselects the specified node.","","    @method unselectNode","    @param {Tree.Node.Selectable} node Node to unselect.","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `unselect` event","            will be suppressed.","        @param {String} [options.src] Source of the change, to be passed along","            to the event facade of the resulting event. This can be used to","            distinguish between changes triggered by a user and changes","            triggered programmatically, for example.","    @chainable","    **/","    unselectNode: function (node, options) {","        if (node.isSelected() || this._selectedMap[node.id]) {","            this._fireTreeEvent(EVT_UNSELECT, {","                node: node,","                src : options && options.src","            }, {","                defaultFn: this._defUnselectFn,","                silent   : options && options.silent","            });","        }","","        return this;","    },","","    // -- Protected Methods ----------------------------------------------------","    _selectableAfterDefAddFn: function (e) {","        // If the node is marked as selected, we need go through the select","        // flow.","        if (e.node.isSelected()) {","            this.selectNode(e.node);","        }","    },","","    _selectableAfterDefClearFn: function () {","        this._selectedMap = {};","    },","","    _selectableAfterDefRemoveFn: function (e) {","        delete e.node.state.selected;","        delete this._selectedMap[e.node.id];","    },","","    // -- Protected Event Handlers ---------------------------------------------","    _afterMultiSelectChange: function () {","        this.unselect();","    },","","    _defSelectFn: function (e) {","        if (!this.get('multiSelect')) {","            this.unselect();","        }","","        e.node.state.selected = true;","        this._selectedMap[e.node.id] = e.node;","    },","","    _defUnselectFn: function (e) {","        delete e.node.state.selected;","        delete this._selectedMap[e.node.id];","    }","};","","Selectable.ATTRS = {","    /**","    Whether or not to allow multiple nodes to be selected at once.","","    @attribute {Boolean} multiSelect","    @default false","    **/","    multiSelect: {","        value: false","    }","};","","Y.Tree.Selectable = Selectable;","/**","@module tree","@submodule tree-selectable","**/","","/**","`Tree.Node` extension that adds methods useful for nodes in trees that use the","`Tree.Selectable` extension.","","@class Tree.Node.Selectable","@constructor","@extensionfor Tree.Node","**/","","function NodeSelectable() {}","","NodeSelectable.prototype = {","    /**","    Returns `true` if this node is currently selected.","","    @method isSelected","    @return {Boolean} `true` if this node is currently selected, `false`","        otherwise.","    **/","    isSelected: function () {","        return !!this.state.selected;","    },","","    /**","    Selects this node.","","    @method select","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `select` event","            will be suppressed.","        @param {String} [options.src] Source of the change, to be passed along","            to the event facade of the resulting event. This can be used to","            distinguish between changes triggered by a user and changes","            triggered programmatically, for example.","    @chainable","    **/","    select: function (options) {","        this.tree.selectNode(this, options);","        return this;","    },","","    /**","    Unselects this node.","","    @method unselect","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `unselect` event","            will be suppressed.","        @param {String} [options.src] Source of the change, to be passed along","            to the event facade of the resulting event. This can be used to","            distinguish between changes triggered by a user and changes","            triggered programmatically, for example.","    @chainable","    **/","    unselect: function (options) {","        this.tree.unselectNode(this, options);","        return this;","    }","};","","Y.Tree.Node.Selectable = NodeSelectable;","","","}, '3.16.0', {\"requires\": [\"tree\"]});","","}());"]};
}
var __cov_Gv82L4iyzp9EcbJf9Nq4lQ = __coverage__['build/tree-selectable/tree-selectable.js'];
__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['1']++;YUI.add('tree-selectable',function(Y,NAME){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['1']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['2']++;var Do=Y.Do;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['3']++;var EVT_SELECT='select';__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['4']++;var EVT_UNSELECT='unselect';__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['5']++;function Selectable(){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['2']++;}__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['6']++;Selectable.prototype={initializer:function(){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['3']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['7']++;this.nodeExtensions=this.nodeExtensions.concat(Y.Tree.Node.Selectable);__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['8']++;this._selectedMap={};__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['9']++;Do.after(this._selectableAfterDefAddFn,this,'_defAddFn');__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['10']++;Do.after(this._selectableAfterDefClearFn,this,'_defClearFn');__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['11']++;Do.after(this._selectableAfterDefRemoveFn,this,'_defRemoveFn');__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['12']++;this._selectableEvents=[this.after('multiSelectChange',this._afterMultiSelectChange)];},destructor:function(){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['4']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['13']++;new Y.EventHandle(this._selectableEvents).detach();__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['14']++;this._selectableEvents=null;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['15']++;this._selectedMap=null;},getSelectedNodes:function(){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['5']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['16']++;return Y.Object.values(this._selectedMap);},selectNode:function(node,options){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['6']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['17']++;if(!this._selectedMap[node.id]){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['1'][0]++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['18']++;this._fireTreeEvent(EVT_SELECT,{node:node,src:(__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['2'][0]++,options)&&(__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['2'][1]++,options.src)},{defaultFn:this._defSelectFn,silent:(__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['3'][0]++,options)&&(__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['3'][1]++,options.silent)});}else{__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['1'][1]++;}__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['19']++;return this;},unselect:function(options){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['7']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['20']++;for(var id in this._selectedMap){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['21']++;if(this._selectedMap.hasOwnProperty(id)){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['4'][0]++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['22']++;this.unselectNode(this._selectedMap[id],options);}else{__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['4'][1]++;}}__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['23']++;return this;},unselectNode:function(node,options){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['8']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['24']++;if((__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['6'][0]++,node.isSelected())||(__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['6'][1]++,this._selectedMap[node.id])){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['5'][0]++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['25']++;this._fireTreeEvent(EVT_UNSELECT,{node:node,src:(__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['7'][0]++,options)&&(__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['7'][1]++,options.src)},{defaultFn:this._defUnselectFn,silent:(__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['8'][0]++,options)&&(__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['8'][1]++,options.silent)});}else{__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['5'][1]++;}__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['26']++;return this;},_selectableAfterDefAddFn:function(e){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['9']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['27']++;if(e.node.isSelected()){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['9'][0]++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['28']++;this.selectNode(e.node);}else{__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['9'][1]++;}},_selectableAfterDefClearFn:function(){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['10']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['29']++;this._selectedMap={};},_selectableAfterDefRemoveFn:function(e){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['11']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['30']++;delete e.node.state.selected;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['31']++;delete this._selectedMap[e.node.id];},_afterMultiSelectChange:function(){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['12']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['32']++;this.unselect();},_defSelectFn:function(e){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['13']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['33']++;if(!this.get('multiSelect')){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['10'][0]++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['34']++;this.unselect();}else{__cov_Gv82L4iyzp9EcbJf9Nq4lQ.b['10'][1]++;}__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['35']++;e.node.state.selected=true;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['36']++;this._selectedMap[e.node.id]=e.node;},_defUnselectFn:function(e){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['14']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['37']++;delete e.node.state.selected;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['38']++;delete this._selectedMap[e.node.id];}};__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['39']++;Selectable.ATTRS={multiSelect:{value:false}};__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['40']++;Y.Tree.Selectable=Selectable;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['41']++;function NodeSelectable(){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['15']++;}__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['42']++;NodeSelectable.prototype={isSelected:function(){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['16']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['43']++;return!!this.state.selected;},select:function(options){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['17']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['44']++;this.tree.selectNode(this,options);__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['45']++;return this;},unselect:function(options){__cov_Gv82L4iyzp9EcbJf9Nq4lQ.f['18']++;__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['46']++;this.tree.unselectNode(this,options);__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['47']++;return this;}};__cov_Gv82L4iyzp9EcbJf9Nq4lQ.s['48']++;Y.Tree.Node.Selectable=NodeSelectable;},'3.16.0',{'requires':['tree']});
