<?php
	/**
	 * phpGroupWare
	 *
	 * @author Sigurd Nes <sigurdne@online.no>
	 * @copyright Copyright (C) 2011 Free Software Foundation, Inc. http://www.fsf.org/
	 * @license http://www.gnu.org/licenses/gpl.html GNU General Public License
	 * @internal Development of this application was funded by http://www.bergen.kommune.no/bbb_/ekstern/
	 * @package phpgroupware
	 * @subpackage communication
	 * @category core
	 * @version $Id: SMSService.php 4237 2009-11-27 23:17:21Z sigurd $
	 */
	/*
	  This program is free software: you can redistribute it and/or modify
	  it under the terms of the GNU General Public License as published by
	  the Free Software Foundation, either version 2 of the License, or
	  (at your option) any later version.

	  This program is distributed in the hope that it will be useful,
	  but WITHOUT ANY WARRANTY; without even the implied warranty of
	  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	  GNU General Public License for more details.

	  You should have received a copy of the GNU General Public License
	  along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 */

	/**
	 * soap client for pswin.com SMS service
	 * this code is generated by the http://code.google.com/p/wsdl2php-interpreter/ 
	 *
	 * @package phpgroupware
	 * @subpackage sms
	 */

	/**
	 * SendSingleMessage
	 */
	class SendSingleMessage
	{

		/**
		 * @access public
		 * @var sstring
		 */
		public $username;

		/**
		 * @access public
		 * @var sstring
		 */
		public $password;

		/**
		 * @access public
		 * @var SMSMessage
		 */
		public $m;

	}

	/**
	 * SMSMessage
	 */
	class SMSMessage
	{

		/**
		 * @access public
		 * @var sstring
		 */
		public $ReceiverNumber;

		/**
		 * @access public
		 * @var sstring
		 */
		public $SenderNumber;

		/**
		 * @access public
		 * @var sstring
		 */
		public $Text;

		/**
		 * @access public
		 * @var sstring
		 */
		public $Network;

		/**
		 * @access public
		 * @var sstring
		 */
		public $TypeOfMessage;

		/**
		 * @access public
		 * @var sint
		 */
		public $Tariff;

		/**
		 * @access public
		 * @var sint
		 */
		public $TimeToLive;

		/**
		 * @access public
		 * @var sstring
		 */
		public $CPATag;

		/**
		 * @access public
		 * @var sboolean
		 */
		public $RequestReceipt;

		/**
		 * @access public
		 * @var sstring
		 */
		public $SessionData;

		/**
		 * @access public
		 * @var sstring
		 */
		public $AffiliateProgram;

		/**
		 * @access public
		 * @var sstring
		 */
		public $DeliveryTime;

		/**
		 * @access public
		 * @var sstring
		 */
		public $ServiceCode;

	}

	/**
	 * SendSingleMessageResponse
	 */
	class SendSingleMessageResponse
	{

		/**
		 * @access public
		 * @var ReturnValue
		 */
		public $SendSingleMessageResult;

	}

	/**
	 * ReturnValue
	 */
	class ReturnValue
	{

		/**
		 * @access public
		 * @var sint
		 */
		public $Code;

		/**
		 * @access public
		 * @var sstring
		 */
		public $Description;

		/**
		 * @access public
		 * @var sstring
		 */
		public $Reference;

	}

	/**
	 * SendMessages
	 */
	class SendMessages
	{

		/**
		 * @access public
		 * @var sstring
		 */
		public $username;

		/**
		 * @access public
		 * @var sstring
		 */
		public $password;

		/**
		 * @access public
		 * @var ArrayOfSMSMessage
		 */
		public $m;

	}

	/**
	 * SendMessagesResponse
	 */
	class SendMessagesResponse
	{

		/**
		 * @access public
		 * @var ArrayOfReturnValue
		 */
		public $SendMessagesResult;

	}

	/**
	 * SendSingleWapPush
	 */
	class SendSingleWapPush
	{

		/**
		 * @access public
		 * @var sstring
		 */
		public $username;

		/**
		 * @access public
		 * @var sstring
		 */
		public $password;

		/**
		 * @access public
		 * @var WapPushMessage
		 */
		public $m;

	}

	/**
	 * WapPushMessage
	 */
	class WapPushMessage
	{

		/**
		 * @access public
		 * @var sstring
		 */
		public $ReceiverNumber;

		/**
		 * @access public
		 * @var sstring
		 */
		public $SenderNumber;

		/**
		 * @access public
		 * @var sstring
		 */
		public $Url;

		/**
		 * @access public
		 * @var sstring
		 */
		public $Description;

		/**
		 * @access public
		 * @var sstring
		 */
		public $Network;

		/**
		 * @access public
		 * @var sint
		 */
		public $Tariff;

		/**
		 * @access public
		 * @var sint
		 */
		public $TimeToLive;

		/**
		 * @access public
		 * @var sstring
		 */
		public $CPATag;

		/**
		 * @access public
		 * @var sboolean
		 */
		public $RequestReceipt;

		/**
		 * @access public
		 * @var sstring
		 */
		public $SessionData;

		/**
		 * @access public
		 * @var sstring
		 */
		public $AffiliateProgram;

		/**
		 * @access public
		 * @var sstring
		 */
		public $DeliveryTime;

	}

	/**
	 * SendSingleWapPushResponse
	 */
	class SendSingleWapPushResponse
	{

		/**
		 * @access public
		 * @var ReturnValue
		 */
		public $SendSingleWapPushResult;

	}

	/**
	 * SendMultipleWapPush
	 */
	class SendMultipleWapPush
	{

		/**
		 * @access public
		 * @var sstring
		 */
		public $username;

		/**
		 * @access public
		 * @var sstring
		 */
		public $password;

		/**
		 * @access public
		 * @var ArrayOfWapPushMessage
		 */
		public $m;

	}

	/**
	 * SendMultipleWapPushResponse
	 */
	class SendMultipleWapPushResponse
	{

		/**
		 * @access public
		 * @var ArrayOfReturnValue
		 */
		public $SendMultipleWapPushResult;

	}

	/**
	 * SMSService
	 * @author WSDLInterpreter
	 */
	class SMSService extends SoapClient
	{

		/**
		 * Default class map for wsdl=>php
		 * @access private
		 * @var array
		 */
		private static $classmap = array(
			"SendSingleMessage" => "SendSingleMessage",
			"SMSMessage" => "SMSMessage",
			"SendSingleMessageResponse" => "SendSingleMessageResponse",
			"ReturnValue" => "ReturnValue",
			"SendMessages" => "SendMessages",
			"SendMessagesResponse" => "SendMessagesResponse",
			"SendSingleWapPush" => "SendSingleWapPush",
			"WapPushMessage" => "WapPushMessage",
			"SendSingleWapPushResponse" => "SendSingleWapPushResponse",
			"SendMultipleWapPush" => "SendMultipleWapPush",
			"SendMultipleWapPushResponse" => "SendMultipleWapPushResponse",
		);

		/**
		 * Constructor using wsdl location and options array
		 * @param string $wsdl WSDL location for this service
		 * @param array $options Options for the SoapClient
		 */
		public function __construct( $wsdl = "http://sms.pswin.com/SOAP/SMS.asmx?wsdl", $options = array() )
		{
			foreach (self::$classmap as $wsdlClassName => $phpClassName)
			{
				if (!isset($options['classmap'][$wsdlClassName]))
				{
					$options['classmap'][$wsdlClassName] = $phpClassName;
				}
			}
			parent::__construct($wsdl, $options);
		}

		/**
		 * Checks if an argument list matches against a valid argument type list
		 * @param array $arguments The argument list to check
		 * @param array $validParameters A list of valid argument types
		 * @return boolean true if arguments match against validParameters
		 * @throws Exception invalid function signature message
		 */
		public function _checkArguments( $arguments, $validParameters )
		{
			$variables = "";
			foreach ($arguments as $arg)
			{
				$type = gettype($arg);
				if ($type == "object")
				{
					$type = get_class($arg);
				}
				$variables .= "(" . $type . ")";
			}
			if (!in_array($variables, $validParameters))
			{
				throw new Exception("Invalid parameter types: " . str_replace(")(", ", ", $variables));
			}
			return true;
		}

		/**
		 * Service Call: SendSingleMessage
		 * Parameter options:
		 * (SendSingleMessage) parameters
		 * (SendSingleMessage) parameters
		 * @param mixed,... See function description for parameter options
		 * @return SendSingleMessageResponse
		 * @throws Exception invalid function signature message
		 */
		public function SendSingleMessage( $mixed = null )
		{
			$validParameters = array(
				"(SendSingleMessage)",
				"(SendSingleMessage)",
			);
			$args = func_get_args();
			$this->_checkArguments($args, $validParameters);
			return $this->__soapCall("SendSingleMessage", $args);
		}

		/**
		 * Service Call: SendMessages
		 * Parameter options:
		 * (SendMessages) parameters
		 * (SendMessages) parameters
		 * @param mixed,... See function description for parameter options
		 * @return SendMessagesResponse
		 * @throws Exception invalid function signature message
		 */
		public function SendMessages( $mixed = null )
		{
			$validParameters = array(
				"(SendMessages)",
				"(SendMessages)",
			);
			$args = func_get_args();
			$this->_checkArguments($args, $validParameters);
			return $this->__soapCall("SendMessages", $args);
		}

		/**
		 * Service Call: SendSingleWapPush
		 * Parameter options:
		 * (SendSingleWapPush) parameters
		 * (SendSingleWapPush) parameters
		 * @param mixed,... See function description for parameter options
		 * @return SendSingleWapPushResponse
		 * @throws Exception invalid function signature message
		 */
		public function SendSingleWapPush( $mixed = null )
		{
			$validParameters = array(
				"(SendSingleWapPush)",
				"(SendSingleWapPush)",
			);
			$args = func_get_args();
			$this->_checkArguments($args, $validParameters);
			return $this->__soapCall("SendSingleWapPush", $args);
		}

		/**
		 * Service Call: SendMultipleWapPush
		 * Parameter options:
		 * (SendMultipleWapPush) parameters
		 * (SendMultipleWapPush) parameters
		 * @param mixed,... See function description for parameter options
		 * @return SendMultipleWapPushResponse
		 * @throws Exception invalid function signature message
		 */
		public function SendMultipleWapPush( $mixed = null )
		{
			$validParameters = array(
				"(SendMultipleWapPush)",
				"(SendMultipleWapPush)",
			);
			$args = func_get_args();
			$this->_checkArguments($args, $validParameters);
			return $this->__soapCall("SendMultipleWapPush", $args);
		}
	}