#!/usr/bin/env python

##    Fonty Python Copyright (C) 2006 Donn.C.Ingle
##
##    Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation; either version 2 of the License, or
##    (at your option) any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##

ver = "0.1.3"

import sys

try:
    import wxversion
    #Let's make sure things will work.
    wxversion.ensureMinimal("2.6")
except:
    print """I cannot find python-wxversion, this
    may mean you have some missing dependencies.
    Fonty Python will try to install anyway ...
    
    On Ubuntu (and Co.) you should be able to type:
    sudo apt-get install python-wxgtk2.6
            
    If you get long error messages, you will need to
    install python-wxgtk2.6 or better.
    Go to http://wxpython.sourceforge.net/download.php
    """

#Try main wx
try:
    import wx
except:
    print """Fonty Python depends on "wxPython".
    Please install "python-wxgtk2.6" (or better).
    
    On Ubuntu (and Co.) you should be able to type:
    sudo apt-get install python-wxgtk2.6
            
    Go to http://wxpython.sourceforge.net/download.php
    
    When you are done, come back and run setup again.
    """
    sys.exit ()

#import PIL
try:
    import Image, ImageFont, ImageDraw #The PIL stuff.
except:
    print """Fonty Python depends on "PIL" - Python Imaging Library.
    Please install "python2.4-imaging" using your distro's tools.
    
    See: http://www.pythonware.com/products/pil/index.htm
    
    When you are done, come back and run setup again.
    """
    sys.exit()
    
from distutils.core import setup

#This is a list of files to install, and where:
files = ["things/*"]

setup(name = "fontypython",
    version = ver,
    description = "Fonty Python - manage ttf fonts on Gnu/Linux",
    author = "Donn.C.Ingle",
    author_email = "donn.ingle@gmail.com",
    licence = "GNU GPL",
    url = "none",
    packages = ['fontypython'],
    #'fontypython' package must contain 'files' (see list above)
    package_data = {'fontypython' : files },
    #'fp' is in the root.
    scripts = ["fp"],
    long_description = """Manage your ttf fonts on Gnu/Linux with Fonty Python.
    You can collect any fonts together into 'pogs' and then install and remove 
    the pogs as you need them. This way you can control what fonts are in your
    user font folder - thus avoiding long lists of fonts in your design apps.
    
    Copyright (C) 2006 Donn.C.Ingle
    donn.ingle@gmail.com""",
    classifiers=[
      'Development Status :: 4 - Beta',
      'Environment :: X11 Applications :: GTK',
      'Intended Audience :: End Users/Desktop',
      'Intended Audience :: Developers',
      'License :: OSI Approved :: GNU General Public License (GPL)',
      'Operating System :: POSIX :: Linux',
      'Programming Language :: Python',
      'Topic :: Desktop Environment',
      'Topic :: Text Processing :: Fonts'
      ]    
) 

