##    Fonty Python Copyright  (C)  2006 Donn.C.Ingle
##
##    Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation; either version 2 of the License, or
##     ( at your option )  any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##

import sys
import strings
import pathcontrol
import fpsys
import fpversion
import fontybugs

from pog import *

####
## Ensure we have a .fontypython folder and a .fonts folder.
iPC = pathcontrol.PathControl (  )  

####
## Sort out this command line stuff:

from optparse import OptionParser
parser = OptionParser (  ) 
use = strings.use ( )
parser = OptionParser ( usage=use, version="Fonty Python %s Copyright (C) 2006 Donn.C.Ingle" % fpversion.version ) 
parser.add_option ( "-e", "--examples", action="store_const",dest="examples", const=True, help="show some %$@#$ examples!" ) 
parser.add_option ( "-i", "--install", dest="install",metavar="pog", help="install the fonts in this pog to your fonts folder" ) 
parser.add_option ( "-u", "--uninstall",dest="uninstall",metavar="pog", help="uninstall the fonts in this pog" ) 
parser.add_option ( "-l", "--list",action="store_const", const=True, help="list the names of all the pogs" )     
parser.add_option ( "-s", "--size",action="store", metavar="num",dest="points", help="set a new default point size. 64 is best" )     
parser.add_option ( "-v", "--view",action="store", metavar="num",dest="numinpage", help="set a new default for how many fonts to view at one go. 10 is good" )   
parser.add_option ( "-t", "--text",action="store", metavar="\"text\"",dest="text", type="string", help="set a new default sample text. \"This is an ex-parrot!\" is good. Be sure to use the quotes" )   
parser.add_option ( "-p", "--purge",action="store", metavar="pog",dest="purge", help="purge the pog of ttf files that are no longer really there" )   
#parser.add_option ( "-g", "--gui",action="store",metavar="(wxgui OR qtgui)",dest="gui", help="choose a graphical interface, one of wxgui or qtgui. Only one that is available and working on your system will be used. The default is wxgui" )
parser.add_option ( "--min", action="store_const", const=True, help = "only show the minimal interface. This will be set as the default for next time." )
parser.add_option ( "--max", action="store_const", const=True, help = "show the entire interface.This will be set as the default for next time." )

( options, args )  = parser.parse_args (  ) 

if options.examples:
    sys.exit ( strings.examples ( ) ) 

####
## Let's handle those options that DO NOT require args
## List -  Quick and dirty. 
if options.list:
    poglist = iPC.getPogNames (  )
    if len ( poglist )  == 0:
        print "There are no pogs available."
        sys.exit (  ) 
    print "Listing %d pog(s) " % len ( poglist ) 
    print " (*) indicates installed pogs"
    for pog in poglist:
        paf = iPC.appPath (  )  + pog + ".pog"
        try:
            f = open ( paf,"r" ) 
            installed = f.readline (  ) [:-1] #Strips the \n off the end
            f.close (  ) 
        except:
            print "Could not open %s." % paf
        s = " "
        if installed.upper  (  )  == "INSTALLED":
            s = "*"
        print "%s %s" %  ( s,pog ) 
    sys.exit (  ) 

## The gui
#if options.gui: fpsys.config.usegui = options.gui # In another lifetime :)

## The min/max
if options.min: fpsys.config.max = False
if options.max: fpsys.config.max = True
    
####
## Size
## This one can mix with other args, so don't exit.
if options.points > 0: fpsys.config.points = int  (  options.points  ) 
    
####
## View
## This one can mix with other args, so don't exit.
if options.numinpage > 1:
    fpsys.config.numinpage = int ( options.numinpage ) 

####
## Text
## This one has potential to screw-up badly
## if the user forgets the quotes.
## For now, I will exit app.
if options.text:
    fpsys.config.text = options.text
    fpsys.config.Save (  )         
    print "Your text has been set to \"%s\"" % options.text
    print "Tip: Did you use quotes to surround your text?"
    print "Start FontyPython again to see the result."
    sys.exit (  ) 
    
####
## Let's just make sure the user has a .fonts folder
##dst = iPC.userFontPath (  ) 

####
##Handle purge
if options.purge:
    pogtopurge = options.purge # for clarity
    if fpsys.isPog ( pogtopurge ):
        pog = Pog ( pogtopurge )
        try:
            pog.genList ( )
        except fontybugs.PogInvalid, e:
            sys.exit ( str ( e ) )
        try:
            ## pog.purge ( ) Raises
            ##          PogEmpty
            ##          PogInstalled            
            pog.purge ( )
        except ( fontybugs.PogEmpty, fontybugs.PogInstalled ), e:
            print str ( e )
    else:
        sys.exit  ( "%s cannot be found. Try -l to see the names." % pogtopurge ) 
    fpsys.config.Save ( )
    sys.exit ( strings.done )
    
####
## Report stuff to console.
def printProgressToConsole ( message ):
    print message

####    
## Install:
if options.install:
    pogtoinstall = options.install
    if fpsys.isPog ( pogtoinstall ):
        pog = Pog ( pogtoinstall, printProgressToConsole ) 
        try:
            pog.genList ( )
        except fontybugs.PogInvalid, e:
            sys.exit ( str ( e ) )
        try:
            ## pog.install ( ) Raises:
            ##          PogEmpty
            ##          PogAllFontsFailedToInstall
            ##          PogSomeFontsDidNotInstall            
            print "Installing %s" % pogtoinstall
            pog.install ( ) # will use progressCallBack to print each font name.
        except (  fontybugs.PogEmpty, 
                        fontybugs.PogAllFontsFailedToInstall,
                        fontybugs.PogSomeFontsDidNotInstall,
                    ), e:
            print str ( e )
    else: # not a pogname
        sys.exit  ( "%s cannot be found. Try -l to see the names." % pogtoinstall ) 
    fpsys.config.Save ( )
    sys.exit ( strings.done )
    
####
## uninstall
if options.uninstall:
    pogtouninstall = options.uninstall
    if fpsys.isPog ( pogtouninstall ):
        pog = Pog ( pogtouninstall, printProgressToConsole )
        try:
            pog.genList ( )
        except fontybugs.PogInvalid, e:
            sys.exit ( str ( e ) )
        try:
            ## Raises:
            ##          PogEmpty
            ##          PogLinksRemain
            ##          PogNotInstalled            
            print "Removing %s" % pogtouninstall
            pog.uninstall ( )
        except (  fontybugs.PogEmpty,
                        fontybugs.PogNotInstalled,
                        fontybugs.PogLinksRemain ), e:
            print str ( e )
    else:
        sys.exit ( "Sorry, can't find %s. Try -l to see the names." % pogtouninstall )
    fpsys.config.Save ( )
    sys.exit ( strings.done )
            
####
## If there are > 2 args then there is chaos:
if len ( args )  > 2:
    ## The user may have chosen a pogname with spaces and no quotes
    print """Please check your arguments, there seem to be too many.
(Remember: it's one pound for a five-minute argument, but only 
eight pounds for a course of ten.)
    
NB: If you wanted to use spaces in a pogname or folder then
please put quotes around them."""
    sys.exit  (  ) 
    
    
####
## Handle Cases :
A = None
B = None

fakearg = False 
if not args:
    args = [ ]
    fakearg = True
    lv = fpsys.config.lastview
    if not fpsys.isFolder ( lv ) and not fpsys.isPog ( lv ): lv = "EMPTY"
    args.append ( lv ) #Fakes an arg, will be last pog used (recovered from config) or "EMPTY"

## Get the args into simple vars:
A = args [0]
if len ( args ) == 2: B = args [1]
    
## Let's ensure that, should A be a pog, that it exists, BUT only if it was not a fakearg:
if not fpsys.isFolder ( A ) and not fpsys.isPog ( A ) and not fakearg:
    ## It's a non starter:
    sys.exit ( "%s does not exist. Try --list" % A )

## Disallow Folder in arg B
if B and fpsys.isFolder ( B ):
    sys.exit ( "You cannot use a folder as the target argument. Try --help" )
    
## Let's ensure that B exists, else we must make it.
if B and not fpsys.isPog ( B ):
    ipog = Pog ( B )
    try:
        ipog.write ( )
    except fontybugs.PogWriteError, e:
        sys.exit ( e )
    del ipog

## Build the fpsys structure
## Calls to validateXYZ are vital. They are where the View or Target Objects get 
## generated - i.e. where all their fontItems are built-up.
## One arg:
if A and not B:
    if fpsys.isFolder ( A ): 
        try:
            fpsys.validateViewFolder ( A )
        except fontybugs.FolderHasNoFonts, e:
            sys.exit ( str ( e ) )
    if fpsys.isPog ( A ): 
        try:
            fpsys.validateViewPog ( A )
        except fontybugs.PogInvalid, e:
            sys.exit ( str ( e ) )
    ## Because we are catering for a potential full gui,
    ## we must make an official "targetobject" set to None
    fpsys.SetTargetPogToNone ( )
    
## Two args:
if A and B:
    if fpsys.isFolder ( A ) and fpsys.isPog ( B ): 
        ## "FP"
        try:
            fpsys.validateViewFolder ( A )
        except fontybugs.FolderHasNoFonts, e:
            sys.exit ( str ( e ) )
        try:
            installed = fpsys.validateTargetPog ( B )
        except fontybugs.PogInvalid, e:
             sys.exit ( str ( e ) )
        if installed: sys.exit ( "The target pog (%s) is currently installed,\nyou can't use it as a target." % B )
        
    if fpsys.isPog ( A ) and fpsys.isPog ( B ):
        ## "PP"
        if A == B:
            sys.exit ( "Your pogs are the same! Try -e" ) 
        try:
            empty = fpsys.validateViewPog ( A )
        except fontybugs.PogInvalid, e:
             sys.exit ( str ( e ) )
        if empty: sys.exit ( "This pog is empty" )
 
        try:
            installed = fpsys.validateTargetPog ( B )
        except fontybugs.PogInvalid, e:
             sys.exit ( str ( e ) )
        if installed: sys.exit ( "The target pog (%s) is currently installed,\nyou can't use it as a target." % B )

## sys.exit ( "Your arguments amuse me :) Please try -h" )

