## Module: FontItem

##    Fonty Python Copyright  (C)  2006 Donn.C.Ingle
##
##    Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation; either version 2 of the License, or
##     ( at your option )  any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##

import os

####
## The basic unit of a single font
class FontItem:
    """Represents a single font"""
    def __init__ ( self, paf, ticked, inactive = False, msg = "" ) :
        self.paf = paf
        if self.paf == "EMPTY": self.name = "EMPTY"
        else: self.name = os.path.basename ( paf )
        self.ticked = ticked
        self.inactive = inactive #Means it shows, but cannot be ticked.
        self.msg = msg #Say something unique when I draw this item.        
        self.family = "" #The font family :: added Nov 2006
        self.style = "" # font.getname ( ) [ 1 ] = found in ImageFont.py
