## Module: fontybugs

##    Fonty Python Copyright  (C)  2006 Donn.C.Ingle
##
##    Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation; either version 2 of the License, or
##     ( at your option )  any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##

## Fontybugs
## I want a single file which contains all the errors.

class Errors ( Exception ):
    checkperms = "Also check your file permissions"
    messages = {
                            001 : "Bad voodoo error. I give up.",
                            100 : "There is no such item",
                            200 : "Pog is empty",
                            300 : "Pog is already installed",
                            #400 : "Pog cannot be read",
                            500 : "Pog cannot be written to.\nCheck your filesystem.\n%s" % checkperms,
                            600 : "Pog is invalid, please hand-edit it",
                            700 : "Some fonts did not install.\nPerhaps the original fonts folder has moved or been renamed.\nYou should purge or hand-edit",
                            800 : "Pog is not installed.",
                            900 : "Some fonts could not be uninstalled.\nPlease check your home .fonts (with a dot in front) folder for broken links.\n%s" % checkperms,
                            1000 : "Cannot delete the Pog. %s" % checkperms,
                            1010 : "Not a single font in this pog could be installed.\nThe original font folder has probably moved or been renamed." ,
                            1020 : "Not a single font in this pog could be uninstalled.\nNone of the fonts were in your fonts folder, please check your home .fonts (with a dot in front) folder for broken links.\nThe pog has been marked as \"not installed\"",
                            1030 : "This folder has not ttf fonts in it"
                        }
    def __str__ ( self ):
        return str ( "%s : %s" % ( self.__class__.messages [ self._id] , self._item ) )

class BadVoodoo ( Errors ):
    def __init__ ( self, item = None): 
        self._item = item
        self._id = 001
        
class ErrNoSuchItem ( Errors ):
    def __init__ ( self, item = None): 
        self._item = item
        self._id = 100

class PogEmpty ( Errors ):
    def __init__ ( self, item = None): 
        self._item = item
        self._id = 200
        
class PogInstalled ( Errors ):
    def __init__ ( self, item = None): 
        self._item = item
        self._id = 300        
 
class PogWriteError ( Errors ):
    def __init__ ( self, item = None): 
        self._item = item
        self._id = 500         
        
class PogInvalid ( Errors ):
    def __init__ ( self, item = None): 
        self._item = item
        self._id = 600       

class PogSomeFontsDidNotInstall ( Errors ): #Some fonts did get installed, but not all
    def __init__ ( self, item = None): 
        self._item = item
        self._id = 700  
        
#FontNotInstalled
class PogNotInstalled ( Errors ):
    def __init__ ( self, item = None): 
        self._item = item
        self._id = 800  
        
class PogLinksRemain ( Errors ):
    def __init__ ( self, item = None): 
        self._item = item
        self._id = 900        
        
#PogCannotDelete
class PogCannotDelete ( Errors ):
    def __init__ ( self, item = None): 
        self._item = item
        self._id = 1000
        
class PogAllFontsFailedToInstall ( Errors ):
    def __init__ ( self, item = None): 
        self._item = item
        self._id = 1010      

class PogAllFontsFailedToUninstall ( Errors ):
    def __init__ ( self, item = None): 
        self._item = item
        self._id = 1020         
        
class FolderHasNoFonts ( Errors ):
    def __init__ ( self, item = None): 
        self._item = item
        self._id = 1030            
        
        
        
        
        
        
        
        
        
